/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.replenishment;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MProduct;
import org.compiere.model.MReplenish;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_T_Replenish;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ReplenishInterface;
import org.compiere.util.Util;
import org.eevolution.engine.warehouse.WMRuleEngine;
import org.eevolution.model.MWMStrategy;

public class WMSBasedDemandAndMinimumInventory
implements ReplenishInterface {
    public static final String COLUMNNAME_LastReplenishmentDate = "LastReplenishmentDate";

    public BigDecimal getQtyToOrder(MWarehouse warehouse, X_T_Replenish replenishLine) {
        MReplenish replenish = this.getReplenishForProduct(replenishLine, warehouse.getM_Warehouse_ID());
        Timestamp lastReplenishmentDate = new Timestamp(System.currentTimeMillis());
        if (replenish != null) {
            if (replenish.get_Value(COLUMNNAME_LastReplenishmentDate) != null) {
                lastReplenishmentDate = (Timestamp)replenish.get_Value(COLUMNNAME_LastReplenishmentDate);
            }
            BigDecimal quantityToOrder = DB.getSQLValueBDEx((String)replenishLine.get_TrxName(), (String)"SELECT ABS(SUM(t.MovementQty)) FROM M_Transaction t WHERE t.M_Product_ID = ? AND t.MovementDate >= ? AND t.MovementType IN('C-', 'C+') AND EXISTS(SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID = t.M_Locator_ID AND l.M_Warehouse_ID = ?)", (Object[])new Object[]{replenishLine.getM_Product_ID(), lastReplenishmentDate, warehouse.getM_Warehouse_ID()});
            if (!Util.isEmpty((String)replenishLine.getReplenishmentCreate())) {
                lastReplenishmentDate = new Timestamp(System.currentTimeMillis());
                replenish.set_ValueOfColumn(COLUMNNAME_LastReplenishmentDate, (Object)lastReplenishmentDate);
                replenish.saveEx();
            }
            if (Optional.ofNullable(quantityToOrder).orElse(Env.ZERO).compareTo(Env.ZERO) <= 0 && Optional.ofNullable(replenishLine.getLevel_Min()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0 && Optional.ofNullable(replenishLine.getLevel_Min()).orElse(Env.ZERO).compareTo(replenishLine.getQtyOnHand()) > 0) {
                quantityToOrder = replenishLine.getLevel_Min().subtract(replenishLine.getQtyOnHand());
            }
            if (replenish.getM_WarehouseSource_ID() > 0) {
                replenishLine.setM_WarehouseSource_ID(replenish.getM_WarehouseSource_ID());
            } else {
                Optional maybeSourceStorage;
                int locatorToId = replenish.getM_Locator_ID();
                if (locatorToId <= 0) {
                    locatorToId = MWarehouse.get((Properties)replenishLine.getCtx(), (int)replenishLine.getM_Warehouse_ID()).getDefaultLocator().getM_Locator_ID();
                }
                if ((maybeSourceStorage = this.getStorage(replenishLine, Optional.ofNullable(quantityToOrder).orElse(Env.ZERO), locatorToId).stream().findFirst()).isPresent()) {
                    replenishLine.setM_WarehouseSource_ID(((MStorage)maybeSourceStorage.get()).getM_Warehouse_ID());
                } else {
                    quantityToOrder = null;
                }
            }
            return Optional.ofNullable(quantityToOrder).orElse(Env.ZERO);
        }
        return Env.ZERO;
    }

    private List<MStorage> getStorage(X_T_Replenish replenishLine, BigDecimal quantityToOrder, int locatorToId) {
        ArrayList<MStorage> storageList = new ArrayList<MStorage>();
        List<MWMStrategy> strategies = this.applyDefinition(replenishLine, locatorToId);
        strategies.forEach(strategy -> storageList.addAll(WMRuleEngine.getStorage((MWMStrategy)strategy, (int)replenishLine.getM_Product_ID(), (int)0, (BigDecimal)quantityToOrder, (int)0, (int)0)));
        return storageList;
    }

    private List<MWMStrategy> applyDefinition(X_T_Replenish replenishLine, int locatorToId) {
        ArrayList<MWMStrategy> strategies = new ArrayList<MWMStrategy>();
        StringBuilder whereClause = new StringBuilder("(");
        whereClause.append("M_Product_ID IN (0,?) OR ");
        whereClause.append("M_Product_ID IS NULL");
        whereClause.append(") AND ");
        whereClause.append("(");
        whereClause.append("M_Product_Category_ID IN (0,?) OR ");
        whereClause.append("M_Product_Category_ID IS NULL");
        whereClause.append(") AND ");
        whereClause.append("(");
        whereClause.append("Group1 IN ('',?) OR ");
        whereClause.append("Group1 IS NULL");
        whereClause.append(") AND ");
        whereClause.append("(");
        whereClause.append("Group2 IN ('',?) OR ");
        whereClause.append("Group2 IS NULL");
        whereClause.append(") AND ");
        whereClause.append("(");
        whereClause.append("Classification IN ('',?) OR ");
        whereClause.append("Classification IS NULL");
        whereClause.append(") AND ");
        whereClause.append("(");
        whereClause.append("C_BPartner_ID IN (0,?) OR ");
        whereClause.append("C_BPartner_ID IS NULL");
        whereClause.append(") AND ");
        whereClause.append("(");
        whereClause.append("C_BP_Group_ID IN (0,?) OR ");
        whereClause.append("C_BP_Group_ID IS NULL");
        whereClause.append(") AND ");
        whereClause.append("(");
        whereClause.append("WM_Area_Type_ID IN (0,?) OR ");
        whereClause.append("WM_Area_Type_ID IS NULL");
        whereClause.append(") AND ");
        whereClause.append("(");
        whereClause.append("WM_Section_Type_ID IN (0,?) OR ");
        whereClause.append("WM_Section_Type_ID IS NULL");
        whereClause.append(")");
        whereClause.append(" AND (");
        whereClause.append("M_Locator_ID").append(" IN (0,?) OR ").append("M_Locator_ID").append(" IS NULL) ");
        whereClause.append(" AND EXISTS (SELECT 1 FROM WM_Strategy");
        whereClause.append(" WHERE ");
        whereClause.append("WM_Strategy.WM_Strategy_ID=");
        whereClause.append("WM_Definition.WM_Strategy_ID");
        whereClause.append(" AND ");
        whereClause.append("InOutBoundType=?");
        whereClause.append(")");
        MProduct product = MProduct.get((Properties)replenishLine.getCtx(), (int)replenishLine.getM_Product_ID());
        int businessPartnerId = 0;
        int businessPartnerGroupId = 0;
        if (replenishLine.getC_BPartner_ID() > 0) {
            MBPartner partner = MBPartner.get((Properties)replenishLine.getCtx(), (int)replenishLine.getC_BPartner_ID());
            businessPartnerId = partner.getC_BPartner_ID();
            businessPartnerGroupId = partner.getC_BP_Group_ID();
        }
        List definitionList = new Query(replenishLine.getCtx(), "WM_Definition", whereClause.toString(), replenishLine.get_TrxName()).setClient_ID().setParameters(new Object[]{product.getM_Product_ID(), product.getM_Product_Category_ID(), product.getGroup1(), product.getGroup2(), product.getClassification(), businessPartnerId, businessPartnerGroupId, 0, 0, locatorToId, "O"}).setOrderBy("SeqNo , PriorityRule").list();
        definitionList.forEach(definition -> strategies.add(definition.getWarehouseStrategy()));
        if (strategies.size() == 0) {
            throw new AdempiereException("@WM_Definition_ID@ @NotFound@");
        }
        return strategies;
    }

    private MReplenish getReplenishForProduct(X_T_Replenish replenishLine, int warehouseId) {
        return (MReplenish)new Query(replenishLine.getCtx(), "M_Replenish", "M_Product_ID=? AND AD_Org_ID IN (0, ?) AND M_Warehouse_ID = ? AND ReplenishType = ?", replenishLine.get_TrxName()).setParameters(new Object[]{replenishLine.getM_Product_ID(), replenishLine.getAD_Org_ID(), warehouseId, "9"}).setClient_ID().setOnlyActiveRecords(true).first();
    }
}

