/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.replenishment;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Optional;
import org.compiere.model.MReplenish;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_T_Replenish;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ReplenishInterface;
import org.compiere.util.Util;

public class DemandInventory
implements ReplenishInterface {
    public static final String COLUMNNAME_LastReplenishmentDate = "LastReplenishmentDate";

    public BigDecimal getQtyToOrder(MWarehouse warehouse, X_T_Replenish replenishLine) {
        MReplenish replenish = this.getReplenishForProduct(replenishLine, warehouse.getM_Warehouse_ID());
        Timestamp lastReplenishmentDate = new Timestamp(System.currentTimeMillis());
        if (replenish != null) {
            if (replenish.get_Value(COLUMNNAME_LastReplenishmentDate) != null) {
                lastReplenishmentDate = (Timestamp)replenish.get_Value(COLUMNNAME_LastReplenishmentDate);
            }
            BigDecimal quantityToOrder = DB.getSQLValueBDEx((String)replenishLine.get_TrxName(), (String)"SELECT ABS(SUM(t.MovementQty)) FROM M_Transaction t WHERE t.M_Product_ID = ? AND t.MovementDate >= ? AND t.MovementType LIKE '%-' AND EXISTS(SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID = t.M_Locator_ID AND l.M_Warehouse_ID = ?)", (Object[])new Object[]{replenishLine.getM_Product_ID(), lastReplenishmentDate, warehouse.getM_Warehouse_ID()});
            if (!Util.isEmpty((String)replenishLine.getReplenishmentCreate())) {
                lastReplenishmentDate = new Timestamp(System.currentTimeMillis());
                replenish.set_ValueOfColumn(COLUMNNAME_LastReplenishmentDate, (Object)lastReplenishmentDate);
                replenish.saveEx();
            }
            if (replenish.getM_WarehouseSource_ID() > 0) {
                replenishLine.setM_WarehouseSource_ID(replenish.getM_WarehouseSource_ID());
                replenishLine.saveEx();
            }
            return Optional.ofNullable(quantityToOrder).orElse(Env.ZERO);
        }
        return Env.ZERO;
    }

    private MReplenish getReplenishForProduct(X_T_Replenish replenishLine, int warehouseId) {
        return (MReplenish)new Query(replenishLine.getCtx(), "M_Replenish", "M_Product_ID=? AND AD_Org_ID IN (0, ?) AND M_Warehouse_ID = ? AND ReplenishType = ?", replenishLine.get_TrxName()).setParameters(new Object[]{replenishLine.getM_Product_ID(), replenishLine.getAD_Org_ID(), warehouseId, "9"}).setClient_ID().setOnlyActiveRecords(true).first();
    }
}

