/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.process;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.POInfo;
import org.spin.mm.process.InventoryCustomCountCreateAbstract;
import org.spin.mm.util.CountInfo;
import org.spin.mm.util.CustomCountFactory;
import org.spin.mm.util.ICustomCount;

public class InventoryCustomCountCreate
extends InventoryCustomCountCreateAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
    }

    protected String doIt() throws Exception {
        ICustomCount customCounter = CustomCountFactory.getCustomCountDefinition(this.getCtx(), this.getCustomCountDefinitionId(), this.get_TrxName());
        if (customCounter == null) {
            throw new AdempiereException("@CustomCountClass@ @Invalid@");
        }
        MInventory inventory = new MInventory(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (inventory.isProcessed()) {
            throw new AdempiereException("@M_Inventory_ID@ @Processed@");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        POInfo tableInfo = POInfo.getPOInfo((Properties)this.getCtx(), (int)MInventory.Table_ID, (String)this.get_TrxName());
        for (int index = 0; index < tableInfo.getColumnCount(); ++index) {
            parameters.put(tableInfo.getColumnName(index), inventory.get_Value(tableInfo.getColumnName(index)));
        }
        List<CountInfo> countList = customCounter.getCountList(this.getCtx(), inventory.getM_Warehouse_ID(), this.getProductId(), this.getProductCategoryId(), this.getProductGroupId(), this.getProductClassId(), this.getProductClassificationId(), inventory.getM_Inventory_ID(), inventory.getMovementDate(), this.get_TrxName(), parameters);
        AtomicInteger counter = new AtomicInteger(0);
        if (countList != null) {
            countList.stream().filter(countInfo -> countInfo.getProductId() > 0 && countInfo.getLocatorId() > 0).forEach(countInfo -> {
                MInventoryLine inventoryLine = new MInventoryLine(inventory, countInfo.getLocatorId(), countInfo.getProductId(), countInfo.getAttributeSetInstanceId(), null, countInfo.getQuantityCount());
                inventoryLine.saveEx(this.get_TrxName());
            });
        }
        return "@Created@: " + counter.get();
    }
}

