/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.process;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.exceptions.NoBPartnerLinkedforOrgException;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.spin.mm.process.GenerateInventoryMoveFromSalesOrdersAbstract;

public class GenerateInventoryMoveFromSalesOrders
extends GenerateInventoryMoveFromSalesOrdersAbstract {
    private MDDOrder distributionOrder = null;
    private MMovement movement = null;
    private Map<String, MDDOrderLine> distributionOrderLines = new HashMap<String, MDDOrderLine>();
    private Map<String, MMovementLine> movementLines = new HashMap<String, MMovementLine>();

    protected String doIt() throws Exception {
        if (this.isCreateDistribution()) {
            return this.createDistributionOrder();
        }
        return this.createMovement();
    }

    private String createDistributionOrder() {
        AtomicBoolean first = new AtomicBoolean(true);
        this.getSelectionKeys().forEach(salesOrderLineId -> {
            MOrderLine salesOrderLine = new MOrderLine(this.getCtx(), salesOrderLineId.intValue(), this.get_TrxName());
            MWarehouse replenishReferenceWarehouse = MWarehouse.get((Properties)this.getCtx(), (int)salesOrderLine.get_ValueAsInt("Ref_WarehouseSource_ID"));
            if (replenishReferenceWarehouse == null) {
                throw new AdempiereException("@" + salesOrderLine.get_ValueAsInt("Ref_WarehouseSource_ID") + "@ @NotFound@");
            }
            if (first.get()) {
                this.createDistributionOrderHeader(replenishReferenceWarehouse.getAD_Org_ID());
                first.set(false);
            }
            this.createDistributionOrderLine(salesOrderLine);
        });
        if (this.distributionOrder == null) {
            return "@DD_Order_ID@ @NotFound@";
        }
        if (!this.distributionOrder.processIt(this.getDocAction())) {
            this.addLog("@ProcessFailed@ : " + this.distributionOrder.getDocumentInfo());
            this.log.warning("@ProcessFailed@ :" + this.distributionOrder.getDocumentInfo());
        }
        this.distributionOrder.saveEx();
        return "@Created@ " + this.distributionOrder.getDocumentNo();
    }

    private String createMovement() {
        AtomicBoolean first = new AtomicBoolean(true);
        this.getSelectionKeys().forEach(salesOrderLineId -> {
            MOrderLine salesOrderLine = new MOrderLine(this.getCtx(), salesOrderLineId.intValue(), this.get_TrxName());
            MWarehouse replenishReferenceWarehouse = MWarehouse.get((Properties)this.getCtx(), (int)salesOrderLine.get_ValueAsInt("Ref_WarehouseSource_ID"));
            if (replenishReferenceWarehouse == null) {
                throw new AdempiereException("@" + salesOrderLine.get_ValueAsInt("Ref_WarehouseSource_ID") + "@ @NotFound@");
            }
            if (first.get()) {
                this.createMovementHeader(replenishReferenceWarehouse.getAD_Org_ID());
                first.set(false);
            }
            this.createMovementLine(salesOrderLine);
        });
        if (this.movement == null) {
            return "@M_Movement_ID@ @NotFound@";
        }
        if (!this.movement.processIt(this.getDocAction())) {
            this.addLog("@ProcessFailed@ : " + this.movement.getDocumentInfo());
            this.log.warning("@ProcessFailed@ :" + this.movement.getDocumentInfo());
        }
        this.movement.saveEx();
        return "@Created@ " + this.movement.getDocumentNo();
    }

    private void createMovementHeader(int organizationId) {
        List<MWarehouse> transitWarehouse = Arrays.asList(MWarehouse.getInTransitForOrg((Properties)this.getCtx(), (int)organizationId));
        if (transitWarehouse.isEmpty()) {
            throw new AdempiereException("@M_Warehouse_ID@ @IsInTransit@ @NotFound@");
        }
        int warehouseId = ((MWarehouse)transitWarehouse.stream().findFirst().get()).get_ID();
        MLocator defaultLocator = MWarehouse.get((Properties)this.getCtx(), (int)warehouseId).getDefaultLocator();
        if (defaultLocator == null) {
            throw new AdempiereException("@M_Locator_ID@ @IsIntransit@ @NotFound@");
        }
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)organizationId);
        int partnerId = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (partnerId <= 0) {
            throw new NoBPartnerLinkedforOrgException(org);
        }
        this.movement = new MMovement(this.getCtx(), 0, this.get_TrxName());
        this.movement.setAD_Org_ID(organizationId);
        this.movement.setC_BPartner_ID(partnerId);
        this.movement.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generate@"));
        this.movement.setDocAction(Optional.ofNullable(this.getDocAction()).orElseGet(() -> "PR"));
        this.movement.setSalesRep_ID(this.getAD_User_ID());
        this.movement.setMovementDate(this.getDateDoc());
        this.movement.setIsInTransit(false);
        this.movement.setDocStatus("DR");
        this.movement.saveEx();
    }

    private void createMovementLine(MOrderLine salesOrderLine) {
        MMovementLine movementLine = this.movementLines.get(salesOrderLine.getM_Product_ID() + "|" + salesOrderLine.getC_UOM_ID() + "|" + salesOrderLine.getM_AttributeSetInstance_ID());
        MLocator defaultSalesLocator = MWarehouse.get((Properties)this.getCtx(), (int)salesOrderLine.getM_Warehouse_ID()).getDefaultLocator();
        MLocator defaultReplenishLocator = MWarehouse.get((Properties)this.getCtx(), (int)salesOrderLine.get_ValueAsInt("Ref_WarehouseSource_ID")).getDefaultLocator();
        if (defaultSalesLocator == null) {
            throw new AdempiereException("@C_OrderLine_ID@ @M_Locator_ID@ @NotFound@");
        }
        if (defaultReplenishLocator == null) {
            throw new AdempiereException("@Ref_WarehouseSource_ID@ @M_Locator_ID@ @NotFounds@");
        }
        if (movementLine == null) {
            movementLine = new MMovementLine(this.movement);
            movementLine.setM_Locator_ID(defaultReplenishLocator.getM_Locator_ID());
            movementLine.setM_LocatorTo_ID(defaultSalesLocator.getM_Locator_ID());
            movementLine.setM_Product_ID(salesOrderLine.getM_Product_ID());
            movementLine.setM_AttributeSetInstance_ID(salesOrderLine.getM_AttributeSetInstance_ID());
            movementLine.setM_AttributeSetInstanceTo_ID(salesOrderLine.getM_AttributeSetInstance_ID());
            movementLine.setMovementQty(salesOrderLine.getQtyOrdered());
        } else {
            movementLine.setMovementQty(movementLine.getMovementQty().add(salesOrderLine.getQtyOrdered()));
        }
        movementLine.saveEx();
        salesOrderLine.set_ValueOfColumn("Ref_ReplenishMovementLine_ID", (Object)movementLine.getM_MovementLine_ID());
        salesOrderLine.saveEx();
    }

    private void createDistributionOrderLine(MOrderLine salesOrderLine) {
        MDDOrderLine distributionOrderLine = this.distributionOrderLines.get(salesOrderLine.getM_Product_ID() + "|" + salesOrderLine.getC_UOM_ID() + "|" + salesOrderLine.getM_AttributeSetInstance_ID());
        MLocator defaultSalesLocator = MWarehouse.get((Properties)this.getCtx(), (int)salesOrderLine.getM_Warehouse_ID()).getDefaultLocator();
        MLocator defaultReplenishLocator = MWarehouse.get((Properties)this.getCtx(), (int)salesOrderLine.get_ValueAsInt("Ref_WarehouseSource_ID")).getDefaultLocator();
        if (defaultSalesLocator == null) {
            throw new AdempiereException("@C_OrderLine_ID@ @M_Locator_ID@ @NotFounds@");
        }
        if (defaultReplenishLocator == null) {
            throw new AdempiereException("@Ref_WarehouseSource_ID@ @M_Locator_ID@ @NotFounds@");
        }
        MOrder salesOrder = salesOrderLine.getParent();
        if (distributionOrderLine == null) {
            distributionOrderLine = new MDDOrderLine(this.distributionOrder);
            distributionOrderLine.setM_Locator_ID(defaultReplenishLocator.getM_Locator_ID());
            distributionOrderLine.setM_LocatorTo_ID(defaultSalesLocator.getM_Locator_ID());
            distributionOrderLine.setC_UOM_ID(salesOrderLine.getC_UOM_ID());
            distributionOrderLine.setM_Product_ID(salesOrderLine.getM_Product_ID());
            distributionOrderLine.setDateOrdered(this.getDateDoc());
            distributionOrderLine.setDatePromised(salesOrder.getDatePromised());
            distributionOrderLine.setIsInvoiced(false);
            distributionOrderLine.setM_AttributeSetInstance_ID(salesOrderLine.getM_AttributeSetInstance_ID());
            distributionOrderLine.setM_AttributeSetInstanceTo_ID(salesOrderLine.getM_AttributeSetInstance_ID());
            distributionOrderLine.setFreightAmt(Env.ZERO);
            distributionOrderLine.setConfirmedQty(salesOrderLine.getQtyOrdered());
            distributionOrderLine.setQtyEntered(salesOrderLine.getQtyEntered());
            distributionOrderLine.setQtyOrdered(salesOrderLine.getQtyOrdered());
            distributionOrderLine.setTargetQty(salesOrderLine.getQtyOrdered());
        } else {
            distributionOrderLine.setConfirmedQty(distributionOrderLine.getConfirmedQty().add(salesOrderLine.getQtyOrdered()));
            distributionOrderLine.setQtyEntered(distributionOrderLine.getQtyEntered().add(salesOrderLine.getQtyEntered()));
            distributionOrderLine.setQtyOrdered(distributionOrderLine.getQtyOrdered().add(salesOrderLine.getQtyOrdered()));
            distributionOrderLine.setTargetQty(distributionOrderLine.getTargetQty().add(salesOrderLine.getQtyOrdered()));
        }
        distributionOrderLine.saveEx();
        salesOrderLine.set_ValueOfColumn("Ref_ReplenishDOrderLine_ID", (Object)distributionOrderLine.getDD_OrderLine_ID());
        salesOrderLine.saveEx();
    }

    private void createDistributionOrderHeader(int organizationId) {
        List<MWarehouse> transitWarehouse = Arrays.asList(MWarehouse.getInTransitForOrg((Properties)this.getCtx(), (int)organizationId));
        if (transitWarehouse.isEmpty()) {
            throw new AdempiereException("@M_Warehouse_ID@ @IsInTransit@ @NotFound@");
        }
        int warehouseId = ((MWarehouse)transitWarehouse.stream().findFirst().get()).get_ID();
        MLocator defaultLocator = MWarehouse.get((Properties)this.getCtx(), (int)warehouseId).getDefaultLocator();
        if (defaultLocator == null) {
            throw new AdempiereException("@M_Locator_ID@ @IsIntransit@ @NotFounds@");
        }
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)organizationId);
        int partnerId = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (partnerId <= 0) {
            throw new NoBPartnerLinkedforOrgException(org);
        }
        MBPartner partner = MBPartner.get((Properties)this.getCtx(), (int)partnerId);
        if (this.distributionOrder == null) {
            this.distributionOrder = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
        }
        this.distributionOrder.setAD_Org_ID(organizationId);
        this.distributionOrder.setC_BPartner_ID(partnerId);
        this.distributionOrder.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Generate@"));
        if (this.getDocTypeTargetId() > 0) {
            this.distributionOrder.setC_DocType_ID(this.getDocTypeTargetId());
        } else {
            this.distributionOrder.setC_DocType_ID(MDocType.getDocType((String)"DOO"));
        }
        this.distributionOrder.setM_Warehouse_ID(warehouseId);
        this.distributionOrder.setDocAction(Optional.ofNullable(this.getDocAction()).orElseGet(() -> "PR"));
        List<MUser> users = Arrays.asList(MUser.getOfBPartner((Properties)this.getCtx(), (int)partner.getC_BPartner_ID(), (String)this.get_TrxName()));
        if (users.isEmpty()) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@ @Value@ - @C_BPartner_ID@ : " + partner.getValue() + " - " + partner.getName());
        }
        this.distributionOrder.setAD_User_ID(((MUser)users.stream().findFirst().get()).getAD_User_ID());
        this.distributionOrder.setDateOrdered(this.getDateDoc());
        this.distributionOrder.setDatePromised(this.getDateDoc());
        this.distributionOrder.setIsInDispute(false);
        this.distributionOrder.setIsInTransit(false);
        this.distributionOrder.setSalesRep_ID(this.getAD_User_ID());
        this.distributionOrder.setDocStatus("DR");
        this.distributionOrder.saveEx();
    }
}

