/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.process;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.spin.mm.process.CreatePurchaseOrderFromSalesOrdersAbstract;

public class CreatePurchaseOrderFromSalesOrders
extends CreatePurchaseOrderFromSalesOrdersAbstract {
    private MOrder order = null;
    private Map<String, MOrderLine> lines = new HashMap<String, MOrderLine>();

    @Override
    protected void prepare() {
        super.prepare();
        this.order = new MOrder(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.order.isProcessed()) {
            throw new AdempiereException("@C_Order_ID@ @Processed@");
        }
    }

    protected String doIt() throws Exception {
        AtomicInteger created = new AtomicInteger();
        this.getSelectionKeys().forEach(salesOrderLineId -> {
            MOrderLine salesOrderLine = new MOrderLine(this.getCtx(), salesOrderLineId.intValue(), this.get_TrxName());
            MOrderLine purchaseOrderLine = this.lines.get(salesOrderLine.getM_Product_ID() + "|" + salesOrderLine.getC_UOM_ID() + "|" + salesOrderLine.getM_AttributeSetInstance_ID());
            if (purchaseOrderLine == null) {
                purchaseOrderLine = new MOrderLine(this.order);
                purchaseOrderLine.setM_Product_ID(salesOrderLine.getM_Product_ID());
                purchaseOrderLine.setM_AttributeSetInstance_ID(salesOrderLine.getM_AttributeSetInstance_ID());
                purchaseOrderLine.setC_UOM_ID(salesOrderLine.getC_UOM_ID());
                purchaseOrderLine.setQtyEntered(salesOrderLine.getQtyEntered());
                purchaseOrderLine.setQtyOrdered(salesOrderLine.getQtyOrdered());
            } else {
                purchaseOrderLine.setQtyEntered(purchaseOrderLine.getQtyEntered().add(salesOrderLine.getQtyEntered()));
                purchaseOrderLine.setQtyOrdered(purchaseOrderLine.getQtyOrdered().add(salesOrderLine.getQtyOrdered()));
            }
            purchaseOrderLine.saveEx();
            salesOrderLine.set_ValueOfColumn("Ref_ReplenishOrderLine_ID", (Object)purchaseOrderLine.getC_OrderLine_ID());
            salesOrderLine.saveEx();
            created.incrementAndGet();
        });
        return "@Created@: " + created.get();
    }
}

