/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.model.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.mm.util.MaterialManagementImprovementsChanges;

public class StockValidation
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(StockValidation.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if ((type == 1 || type == 2) && entity.get_TableName().equals("C_OrderLine") && (entity.is_new() || entity.is_ValueChanged("M_Product_ID") || entity.is_ValueChanged("QtyOrdered"))) {
            MOrderLine orderLine = (MOrderLine)entity;
            MOrder salesOrder = orderLine.getParent();
            BigDecimal availableForValidate = Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO).subtract(Optional.ofNullable(orderLine.getQtyReserved()).orElse(Env.ZERO));
            if (salesOrder.isSOTrx() && !salesOrder.isReturnOrder() && availableForValidate.compareTo(Env.ZERO) != 0 && orderLine.getM_Product_ID() > 0) {
                MProduct product = MProduct.get((Properties)entity.getCtx(), (int)orderLine.getM_Product_ID());
                MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)salesOrder.getC_DocTypeTarget_ID());
                if (product.isStocked() && documentType.get_ValueAsBoolean("IsValidateAvailability")) {
                    MaterialManagementImprovementsChanges.validateStock(entity.getCtx(), orderLine.getM_Warehouse_ID(), 0, orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID(), availableForValidate, entity.get_TrxName());
                }
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 7 && entity.get_TableName().equals("C_Order")) {
            MOrder order = (MOrder)entity;
            MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)order.getC_DocTypeTarget_ID());
            if (order.isSOTrx() && !order.isReturnOrder() && documentType.get_ValueAsBoolean("IsValidateAvailability")) {
                StringBuffer errorMessage = new StringBuffer();
                Arrays.asList(order.getLines()).stream().filter(orderLine -> {
                    if (orderLine.getM_Product_ID() <= 0) {
                        return false;
                    }
                    MProduct product = MProduct.get((Properties)entity.getCtx(), (int)orderLine.getM_Product_ID());
                    if (!product.isStocked()) {
                        return false;
                    }
                    return Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0;
                }).forEach(orderLine -> {
                    BigDecimal availableForValidate = Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO).subtract(Optional.ofNullable(orderLine.getQtyReserved()).orElse(Env.ZERO));
                    Optional.ofNullable(MaterialManagementImprovementsChanges.validateStock(entity.getCtx(), orderLine.getLine(), orderLine.getM_Warehouse_ID(), 0, orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID(), availableForValidate, entity.get_TrxName())).ifPresent(error -> {
                        if (errorMessage.length() > 0) {
                            errorMessage.append(Env.NL);
                        }
                        errorMessage.append((String)error);
                    });
                });
                if (errorMessage.length() > 0) {
                    throw new AdempiereException("@InsufficientQtyAvailable@ " + errorMessage.toString());
                }
            }
        }
        return null;
    }
}

