/*
 * Decompiled with CFR 0.152.
 */
package org.spin.mm.model.validator;

import org.compiere.model.MClient;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.spin.mm.util.ManualReplenishmentUtil;

public class ManualReplenishment
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ManualReplenishment.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("DD_Order", (ModelValidator)this);
        engine.addDocValidate("M_Movement", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
        engine.addModelChange("DD_OrderLine", (ModelValidator)this);
        engine.addModelChange("M_MovementLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 3) {
            MMovementLine movementLine;
            if (entity.get_TableName().equals("C_OrderLine")) {
                MOrderLine purchaseOrderLine = (MOrderLine)entity;
                MOrder purchaseOrder = purchaseOrderLine.getParent();
                if (!purchaseOrder.isSOTrx() && !purchaseOrder.isProcessed()) {
                    ManualReplenishmentUtil.getLinkedSalesOrderLinesFromPurchaseOrderLine(purchaseOrderLine.getCtx(), purchaseOrderLine.getC_OrderLine_ID(), purchaseOrderLine.get_TrxName()).forEach(salesOrderLineId -> {
                        MOrderLine salesOrderLine = new MOrderLine(purchaseOrderLine.getCtx(), salesOrderLineId.intValue(), purchaseOrderLine.get_TrxName());
                        salesOrderLine.set_ValueOfColumn("Ref_ReplenishOrderLine_ID", null);
                        salesOrderLine.saveEx();
                    });
                }
            } else if (entity.get_TableName().equals("DD_OrderLine")) {
                MDDOrderLine distributionOrderLine = (MDDOrderLine)entity;
                if (!distributionOrderLine.isProcessed()) {
                    ManualReplenishmentUtil.getLinkedSalesOrderLinesFromDistributionOrderLine(distributionOrderLine.getCtx(), distributionOrderLine.getDD_OrderLine_ID(), distributionOrderLine.get_TrxName()).forEach(salesOrderLineId -> {
                        MOrderLine salesOrderLine = new MOrderLine(distributionOrderLine.getCtx(), salesOrderLineId.intValue(), distributionOrderLine.get_TrxName());
                        salesOrderLine.set_ValueOfColumn("Ref_ReplenishDOrderLine_ID", null);
                        salesOrderLine.saveEx();
                    });
                }
            } else if (entity.get_TableName().equals("M_MovementLine") && !(movementLine = (MMovementLine)entity).isProcessed()) {
                ManualReplenishmentUtil.getLinkedSalesOrderLinesFromMovementLine(movementLine.getCtx(), movementLine.getM_MovementLine_ID(), movementLine.get_TrxName()).forEach(salesOrderLineId -> {
                    MOrderLine salesOrderLine = new MOrderLine(movementLine.getCtx(), salesOrderLineId.intValue(), movementLine.get_TrxName());
                    salesOrderLine.set_ValueOfColumn("Ref_ReplenishMovementLine_ID", null);
                    salesOrderLine.saveEx();
                });
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        if (timing == 13 || timing == 14 || timing == 10) {
            MOrder purchaseOrder;
            if (entity.get_TableName().equals("DD_Order")) {
                MDDOrder distributionOrder = (MDDOrder)entity;
                ManualReplenishmentUtil.getLinkedSalesOrderLinesFromDistributionOrder(distributionOrder.getCtx(), distributionOrder.getDD_Order_ID(), distributionOrder.get_TrxName()).forEach(salesOrderLineId -> {
                    MOrderLine salesOrderLine = new MOrderLine(distributionOrder.getCtx(), salesOrderLineId.intValue(), distributionOrder.get_TrxName());
                    salesOrderLine.set_ValueOfColumn("Ref_ReplenishDOrderLine_ID", null);
                    salesOrderLine.saveEx();
                });
            }
            if (entity.get_TableName().equals("M_Movement")) {
                MMovement movement = (MMovement)entity;
                ManualReplenishmentUtil.getLinkedSalesOrderLinesFromMovement(movement.getCtx(), movement.getM_Movement_ID(), movement.get_TrxName()).forEach(salesOrderLineId -> {
                    MOrderLine salesOrderLine = new MOrderLine(movement.getCtx(), salesOrderLineId.intValue(), movement.get_TrxName());
                    salesOrderLine.set_ValueOfColumn("Ref_ReplenishMovementLine_ID", null);
                    salesOrderLine.saveEx();
                });
            } else if (entity.get_TableName().equals("C_Order") && !(purchaseOrder = (MOrder)entity).isSOTrx()) {
                ManualReplenishmentUtil.getLinkedSalesOrderLinesFromPurchaseOrder(purchaseOrder.getCtx(), purchaseOrder.getC_Order_ID(), purchaseOrder.get_TrxName()).forEach(salesOrderLineId -> {
                    MOrderLine salesOrderLine = new MOrderLine(purchaseOrder.getCtx(), salesOrderLineId.intValue(), purchaseOrder.get_TrxName());
                    salesOrderLine.set_ValueOfColumn("Ref_ReplenishOrderLine_ID", null);
                    salesOrderLine.saveEx();
                });
            }
        }
        return null;
    }
}

