/*
 * Decompiled with CFR 0.152.
 */
package org.spin.replication.kafka.support;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.ITestImportProcessor;
import org.adempiere.process.rpl.exp.WrapperUtil;
import org.adempiere.server.rpl.IImportProcessor;
import org.adempiere.util.rpl.EntityWrapper;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.compiere.model.MIMPProcessor;
import org.compiere.model.MIMPProcessorLog;
import org.compiere.server.ReplicationProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.tools.kafka.util.MapDeserializer;

public class KafkaImporter
implements IImportProcessor,
ITestImportProcessor {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private final String TOPIC_NAME_KEY = "TOPIC_NAME";
    private final String CLIENT_ID_KEY = "CLIENT_ID";
    private final String INTENTS_KEY = "INTENTS";

    public void test(Properties ctx, MIMPProcessor importProcessor, String trxName) throws Exception {
        String host = importProcessor.getHost();
        if (Util.isEmpty((String)host)) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        String topicName = importProcessor.getParameterAsString("TOPIC_NAME");
        if (Util.isEmpty((String)topicName)) {
            throw new AdempiereException("@DB_NAME_KEY@ @NotFound@");
        }
        int port = importProcessor.getPort();
        if (port == 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
        int intents = importProcessor.getParameterAsInt("INTENTS");
        if (intents == 0) {
            intents = 100;
        }
        String clientId = importProcessor.getParameterAsString("CLIENT_ID");
        if (Util.isEmpty((String)"CLIENT_ID")) {
            throw new AdempiereException("@CLIENT_ID_KEY@ @NotFound@");
        }
        String completeUrl = host + ":" + port;
        Properties config = new Properties();
        config.put("client.id", InetAddress.getLocalHost().getHostName());
        config.put("group.id", clientId);
        config.put("bootstrap.servers", completeUrl);
        config.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        config.put("value.deserializer", MapDeserializer.class.getName());
        KafkaConsumer consumer = new KafkaConsumer(config);
        consumer.subscribe(Arrays.asList(topicName));
        AtomicInteger iterate = new AtomicInteger(0);
        String errorMessage = Msg.parseTranslation((Properties)ctx, (String)"@Error@");
        String errorSummary = Msg.parseTranslation((Properties)ctx, (String)"@SaveError@");
        long startTime = System.currentTimeMillis();
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger imported = new AtomicInteger();
        while (iterate.incrementAndGet() < intents) {
            ConsumerRecords records = consumer.poll(Duration.ofSeconds(10L));
            records.forEach(record -> {
                try {
                    EntityWrapper wrapper = new EntityWrapper();
                    wrapper.setMap((Map)record.value());
                    WrapperUtil.importWrapper((Properties)ctx, (EntityWrapper)wrapper, (String)trxName);
                    imported.addAndGet(1);
                }
                catch (Exception e) {
                    errors.addAndGet(1);
                    this.addLog(importProcessor, errorMessage, errorSummary, e.getLocalizedMessage(), true);
                }
            });
            consumer.commitSync();
        }
        consumer.unsubscribe();
        consumer.close(Duration.ofSeconds(1L));
        long endTime = System.currentTimeMillis();
        SimpleDateFormat format = DisplayType.getDateFormat((int)16);
        String message = Msg.parseTranslation((Properties)ctx, (String)("@I_IsImported@: " + imported.get() + " @Errors@: " + errors.get() + " @StartTime@: " + format.format(new Timestamp(startTime)) + " @EndTime@: " + format.format(new Timestamp(startTime)) + " @Duration@" + TimeUtil.formatElapsed((long)(startTime - endTime))));
        this.addLog(importProcessor, Msg.getMsg((Properties)ctx, (String)"Process"), Msg.getMsg((Properties)ctx, (String)"Summary"), message, false);
    }

    public void process(Properties ctx, ReplicationProcessor replicationProcessor, String trxName) throws Exception {
        if (replicationProcessor == null) {
            return;
        }
        MIMPProcessor importProcessor = replicationProcessor.getMImportProcessor();
        String host = importProcessor.getHost();
        if (Util.isEmpty((String)host)) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        String database = importProcessor.getParameterAsString("TOPIC_NAME");
        if (Util.isEmpty((String)database)) {
            throw new AdempiereException("@DB_NAME_KEY@ @NotFound@");
        }
        int port = importProcessor.getPort();
        if (port == 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
        int intents = importProcessor.getParameterAsInt("INTENTS");
        if (intents == 0) {
            intents = 100;
        }
        if (Util.isEmpty((String)database)) {
            throw new AdempiereException("@DB_NAME_KEY@ @NotFound@");
        }
        String completeUrl = host + ":" + port;
        String errorMessage = Msg.parseTranslation((Properties)ctx, (String)"@Error@");
        String errorSummary = Msg.parseTranslation((Properties)ctx, (String)"@SaveError@");
        long startTime = System.currentTimeMillis();
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger imported = new AtomicInteger();
        AtomicInteger iterate = new AtomicInteger(0);
        Properties config = new Properties();
        config.put("client.id", InetAddress.getLocalHost().getHostName());
        config.put("group.id", "foo");
        config.put("bootstrap.servers", completeUrl);
        config.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        config.put("value.deserializer", MapDeserializer.class.getName());
        config.put("default.api.timeout.ms", (Object)5000);
        KafkaConsumer consumer = new KafkaConsumer(config);
        consumer.subscribe(Arrays.asList(database));
        while (iterate.incrementAndGet() < intents) {
            ConsumerRecords records = consumer.poll(Duration.ofSeconds(10L));
            records.forEach(record -> {
                try {
                    EntityWrapper wrapper = new EntityWrapper();
                    wrapper.setMap((Map)record.value());
                    WrapperUtil.importWrapper((Properties)ctx, (EntityWrapper)wrapper, (String)trxName);
                    imported.addAndGet(1);
                }
                catch (Exception e) {
                    errors.addAndGet(1);
                    this.addLog(importProcessor, errorMessage, errorSummary, e.getLocalizedMessage(), true);
                }
            });
            consumer.commitSync();
        }
        consumer.unsubscribe();
        consumer.close(Duration.ofSeconds(1L));
        long endTime = System.currentTimeMillis();
        SimpleDateFormat format = DisplayType.getDateFormat((int)16);
        String message = Msg.parseTranslation((Properties)ctx, (String)("@I_IsImported@: " + imported.get() + " @Errors@: " + errors.get() + " @StartTime@: " + format.format(new Timestamp(startTime)) + " @EndTime@: " + format.format(new Timestamp(startTime)) + " @Duration@" + TimeUtil.formatElapsed((long)(startTime - endTime))));
        this.addLog(importProcessor, Msg.getMsg((Properties)ctx, (String)"Process"), Msg.getMsg((Properties)ctx, (String)"Summary"), message, false);
    }

    private void addLog(MIMPProcessor importProcessor, String header, String summary, String textMessage, boolean isError) {
        MIMPProcessorLog log = new MIMPProcessorLog(importProcessor, summary);
        log.setReference(header);
        log.setTextMsg(textMessage);
        log.setIsError(isError);
        log.save();
    }

    public void stop() throws Exception {
    }
}

