/*
 * Decompiled with CFR 0.152.
 */
package org.spin.replication.kafka.support;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.IExportProcessorAsWrapper;
import org.adempiere.util.rpl.EntityWrapper;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.MOrg;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.tools.kafka.util.KafkaLoader;

public class KafkaExporter
implements IExportProcessorAsWrapper {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private final String TOPIC_PREFIX_KEY = "TOPIC_PREFIX";

    public void process(Properties ctx, MEXPProcessor exportProcessor, EntityWrapper wrapper, String transactionName) throws Exception {
        String host = exportProcessor.getHost();
        if (Util.isEmpty((String)host)) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        String topic = exportProcessor.getParameterAsString("TOPIC_PREFIX");
        int port = exportProcessor.getPort();
        if (port == 0) {
            throw new AdempiereException("@Port@ @NotFound@");
        }
        String completeUrl = host + ":" + port;
        topic = (Optional.ofNullable(topic).orElse("") + MOrg.get((Properties)ctx, (int)Env.getAD_Org_ID((Properties)ctx)).getValue()).replaceAll("[^0-9a-zA-Z_]", "").toLowerCase();
        KafkaProducer producer = KafkaLoader.getInstance().getProducer(completeUrl, topic);
        ProducerRecord record = new ProducerRecord(topic, (Object)wrapper.getUuid(), (Object)wrapper.getMap());
        Future future = producer.send(record);
        RecordMetadata metadata = (RecordMetadata)future.get();
    }
}

