/*
 * Decompiled with CFR 0.152.
 */
package org.spin.file;

import java.io.File;
import java.io.FileWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.adempiere.util.rpl.EntityWrapper;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FileExportManager {
    private static FileExportManager instance;
    private boolean isEnabledDatabase = false;
    private static final Logger logger;
    public static final String DATABASE_FORMAT = "yyyy-MM-dd-hh:mm:ss";
    private String path;

    public static FileExportManager getInstance() {
        if (instance == null) {
            instance = new FileExportManager();
        }
        return instance;
    }

    public FileExportManager validate(String path) throws Exception {
        if (path == null || path.trim().length() == 0) {
            throw new Exception("Path not found");
        }
        this.path = path;
        this.createDirectory();
        return this;
    }

    private void createDirectory() {
        try {
            File directory = new File(this.path);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            this.isEnabledDatabase = true;
            logger.info("Folder created" + this.path);
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
        }
    }

    public void saveDocument(EntityWrapper wrapper) {
        if (!this.isEnabledDatabase) {
            return;
        }
        this.saveFile(this.populateMap(wrapper, true), wrapper.getTableName() + "_" + wrapper.getUuid() + ".json");
        logger.info("Document: " + wrapper.getUuid() + " saved");
    }

    public List<EntityWrapper> getDocuments() {
        ArrayList<EntityWrapper> wrapperList = new ArrayList<EntityWrapper>();
        if (!this.isEnabledDatabase) {
            return wrapperList;
        }
        logger.info("Retrieved Documents: " + wrapperList.size());
        return wrapperList;
    }

    private boolean isSameValue(Object value, Object previousValue) {
        if (value == null && previousValue != null || value != null && previousValue == null) {
            return false;
        }
        if (value == null && previousValue == null) {
            return true;
        }
        if (value.toString().equals(previousValue.toString())) {
            return true;
        }
        return true;
    }

    private JSONObject populateMap(EntityWrapper wrapper, boolean isNew) {
        JSONObject map = new JSONObject();
        map.put((Object)"id", (Object)wrapper.getUuid());
        map.put((Object)"Created", (Object)this.getFormatedDate(System.currentTimeMillis()));
        wrapper.getMap().keySet().forEach(key -> {
            Object value = wrapper.getValueAsObject(key);
            Object convertedValue = null;
            if (value != null) {
                convertedValue = value instanceof Timestamp ? this.getFormatedDate(((Timestamp)value).getTime()) : (value instanceof List ? this.getChildren((List)value, isNew) : (value instanceof EntityWrapper ? this.populateMap((EntityWrapper)value, isNew) : value));
            }
            if (convertedValue != null || !isNew) {
                map.put(key, convertedValue);
            }
        });
        return map;
    }

    private JSONArray getChildren(List<EntityWrapper> wrapperList, boolean isNew) {
        JSONArray list = new JSONArray();
        wrapperList.forEach(wrapper -> list.add((Object)this.populateMap((EntityWrapper)wrapper, isNew)));
        return list;
    }

    private String getFormatedDate(long dateAsLong) {
        return new SimpleDateFormat(DATABASE_FORMAT).format(new Date(dateAsLong));
    }

    private String saveFile(JSONObject document, String fileName) {
        if (fileName == null) {
            logger.severe("File name Not Found");
            return null;
        }
        try {
            FileWriter file = new FileWriter(this.path + File.separator + fileName);
            file.write(document.toString());
            file.close();
            logger.info("File write: " + fileName);
        }
        catch (Exception e) {
            logger.severe(e.getLocalizedMessage());
        }
        return fileName;
    }

    static {
        logger = Logger.getLogger(FileExportManager.class.getName());
    }
}

