/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.util.Strings;

public class SMIMEGenerator {
    private static Map BASE_CIPHER_NAMES = new HashMap();
    protected boolean useBase64 = true;
    protected String encoding = "base64";

    protected SMIMEGenerator() {
    }

    public void setContentTransferEncoding(String string) {
        this.encoding = string;
        this.useBase64 = Strings.toLowerCase((String)string).equals("base64");
    }

    protected MimeBodyPart makeContentBodyPart(MimeBodyPart mimeBodyPart) throws SMIMEException {
        try {
            Header header;
            MimeMessage mimeMessage = new MimeMessage((Session)null);
            Enumeration enumeration = mimeBodyPart.getAllHeaders();
            mimeMessage.setDataHandler(mimeBodyPart.getDataHandler());
            while (enumeration.hasMoreElements()) {
                header = (Header)enumeration.nextElement();
                mimeMessage.setHeader(header.getName(), header.getValue());
            }
            mimeMessage.saveChanges();
            enumeration = mimeMessage.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                header = (Header)enumeration.nextElement();
                if (!Strings.toLowerCase((String)header.getName()).startsWith("content-")) continue;
                mimeBodyPart.setHeader(header.getName(), header.getValue());
            }
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception saving message state.", (Exception)((Object)messagingException));
        }
        return mimeBodyPart;
    }

    protected MimeBodyPart makeContentBodyPart(MimeMessage mimeMessage) throws SMIMEException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        try {
            mimeMessage.removeHeader("Message-Id");
            mimeMessage.removeHeader("Mime-Version");
            try {
                if (mimeMessage.getContent() instanceof Multipart) {
                    mimeBodyPart.setContent((Object)mimeMessage.getRawInputStream(), mimeMessage.getContentType());
                    this.extractHeaders(mimeBodyPart, mimeMessage);
                    return mimeBodyPart;
                }
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            mimeBodyPart.setContent(mimeMessage.getContent(), mimeMessage.getContentType());
            this.extractHeaders(mimeBodyPart, mimeMessage);
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception saving message state.", (Exception)((Object)messagingException));
        }
        catch (IOException iOException) {
            throw new SMIMEException("exception getting message content.", iOException);
        }
        return mimeBodyPart;
    }

    private void extractHeaders(MimeBodyPart mimeBodyPart, MimeMessage mimeMessage) throws MessagingException {
        Enumeration enumeration = mimeMessage.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            mimeBodyPart.setHeader(header.getName(), header.getValue());
        }
    }

    protected KeyGenerator createSymmetricKeyGenerator(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            return this.createKeyGenerator(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                String string3 = (String)BASE_CIPHER_NAMES.get(string);
                if (string3 != null) {
                    return this.createKeyGenerator(string3, string2);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                // empty catch block
            }
            if (string2 != null) {
                return this.createSymmetricKeyGenerator(string, null);
            }
            throw noSuchAlgorithmException;
        }
    }

    private KeyGenerator createKeyGenerator(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 != null) {
            return KeyGenerator.getInstance(string, string2);
        }
        return KeyGenerator.getInstance(string);
    }

    static {
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AES");
    }
}

