/*
 * Decompiled with CFR 0.152.
 */
package org.spin.dms.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPackage;
import org.compiere.model.MPackageLine;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.dms.model.MMPackageType;

public class PackageFactory {
    private BigDecimal maximumWeight;
    private BigDecimal maximumVolume;
    private BigDecimal maximumWidth;
    private BigDecimal maximumHeight;
    private BigDecimal maximumDepth;
    private MMPackageType packageType;
    private String transactionName;
    private Properties context;
    private List<MOrder> orders = new ArrayList<MOrder>();
    private List<MPackage> packages = new ArrayList<MPackage>();

    public static PackageFactory newInstance() {
        return new PackageFactory();
    }

    public final BigDecimal getMaximumWeight() {
        return this.maximumWeight;
    }

    public final PackageFactory withMaximumWeight(BigDecimal maximumWeight) {
        this.maximumWeight = Optional.ofNullable(maximumWeight).orElse(Env.ZERO);
        return this;
    }

    public final BigDecimal getMaximumVolume() {
        return this.maximumVolume;
    }

    public final PackageFactory withMaximumVolume(BigDecimal maximumVolume) {
        this.maximumVolume = Optional.ofNullable(maximumVolume).orElse(Env.ZERO);
        return this;
    }

    public final MMPackageType getPackageType() {
        return this.packageType;
    }

    public final PackageFactory withPackageTypeId(int packageTypeId) {
        this.validateTransactionAndContext();
        if (packageTypeId <= 0) {
            throw new AdempiereException("@M_PackageType_ID@ @IsMandatory@");
        }
        this.packageType = MMPackageType.getById(this.context, packageTypeId, this.getTransactionName());
        this.withMaximumWeight(this.packageType.getWeight());
        this.withMaximumVolume(this.packageType.getVolume());
        this.withMaximumWidth(this.packageType.getWidth());
        this.withMaximumHeight(this.packageType.getHeight());
        this.withMaximumDepth(this.packageType.getDepth());
        return this;
    }

    private void validateTransactionAndContext() {
        if (Util.isEmpty((String)this.getTransactionName())) {
            throw new AdempiereException("Transaction Name is Mandatory");
        }
        if (this.getContext() == null) {
            throw new AdempiereException("Context is Mandatory");
        }
    }

    public final String getTransactionName() {
        return this.transactionName;
    }

    public final PackageFactory withTransactionName(String transactionName) {
        this.transactionName = transactionName;
        return this;
    }

    public final Properties getContext() {
        return this.context;
    }

    public final PackageFactory withContext(Properties context) {
        this.context = context;
        return this;
    }

    public final BigDecimal getMaximumWidth() {
        return this.maximumWidth;
    }

    public final PackageFactory withMaximumWidth(BigDecimal maximumWidth) {
        this.maximumWidth = Optional.ofNullable(maximumWidth).orElse(Env.ZERO);
        return this;
    }

    public final BigDecimal getMaximumHeight() {
        return this.maximumHeight;
    }

    public final PackageFactory withMaximumHeight(BigDecimal maximumHeight) {
        this.maximumHeight = Optional.ofNullable(maximumHeight).orElse(Env.ZERO);
        return this;
    }

    public final BigDecimal getMaximumDepth() {
        return this.maximumDepth;
    }

    public final PackageFactory withMaximumDepth(BigDecimal maximumDepth) {
        this.maximumDepth = Optional.ofNullable(maximumDepth).orElse(Env.ZERO);
        return this;
    }

    public final PackageFactory addOrder(MOrder order) {
        this.orders.add(order);
        return this;
    }

    private void calculatePackagingFromOrderLine(MOrder order, MOrderLine orderLine) {
        MProduct product = MProduct.get((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID());
        AtomicReference<BigDecimal> unitsPerPallet = new AtomicReference<BigDecimal>((BigDecimal)orderLine.get_Value("MinimalUnitsPerPallet"));
        if (!Optional.ofNullable(unitsPerPallet.get()).isPresent()) {
            unitsPerPallet.set(this.getUnitsPerPallet(product.getWeight(), product.getVolume()));
        }
        if (unitsPerPallet.get() == null || unitsPerPallet.get().compareTo(Env.ZERO) <= 0) {
            return;
        }
        int series = orderLine.getQtyOrdered().divide(unitsPerPallet.get(), 0, RoundingMode.UP).intValue();
        AtomicReference<BigDecimal> remainingQuantity = new AtomicReference<BigDecimal>(orderLine.getQtyOrdered());
        IntStream.range(0, series).forEach(serie -> {
            AtomicReference<BigDecimal> quantityToPackaging = new AtomicReference<BigDecimal>((BigDecimal)unitsPerPallet.get());
            if (((BigDecimal)unitsPerPallet.get()).compareTo((BigDecimal)remainingQuantity.get()) > 0) {
                quantityToPackaging.set((BigDecimal)remainingQuantity.get());
            }
            if (quantityToPackaging.get().compareTo(Env.ZERO) > 0) {
                MPackage packageToAdd = this.getLastPackage();
                if (packageToAdd == null) {
                    packageToAdd = this.createPackage(order);
                } else {
                    BigDecimal remainingFromPackage = this.getUnitsPerPallet(product.getWeight(), product.getVolume(), this.maximumWeight.subtract(packageToAdd.getWeight()), this.maximumVolume.subtract(packageToAdd.getVolume()));
                    if (remainingFromPackage.compareTo(Env.ZERO) > 0) {
                        if (remainingFromPackage.compareTo((BigDecimal)remainingQuantity.get()) > 0) {
                            quantityToPackaging.set((BigDecimal)remainingQuantity.get());
                        } else {
                            quantityToPackaging.set(remainingFromPackage);
                        }
                    } else {
                        packageToAdd = this.createPackage(order);
                    }
                }
                this.createPackageLine(packageToAdd, orderLine, quantityToPackaging.get());
                remainingQuantity.updateAndGet(remaining -> remaining.subtract((BigDecimal)quantityToPackaging.get()));
            }
        });
    }

    private MPackage getLastPackage() {
        if (this.packages.size() > 0) {
            MPackage packageGetted = this.packages.get(this.packages.size() - 1);
            packageGetted.load(this.transactionName);
            return packageGetted;
        }
        return null;
    }

    private MPackageLine createPackageLine(MPackage packageToAdd, MOrderLine orderLine, BigDecimal quantityToPackaging) {
        MProduct product = MProduct.get((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID());
        MPackageLine packageLine = new MPackageLine(packageToAdd);
        packageLine.set_ValueOfColumn("C_OrderLine_ID", (Object)orderLine.getC_OrderLine_ID());
        packageLine.setDescription(orderLine.getDescription());
        packageLine.setQty(quantityToPackaging);
        packageLine.setWidth(new BigDecimal(product.getShelfWidth()));
        packageLine.setHeight(Optional.ofNullable(product.getShelfHeight()).orElse(Env.ZERO));
        packageLine.setDepth(new BigDecimal(product.getShelfDepth()));
        BigDecimal totalWeight = quantityToPackaging.multiply(Optional.ofNullable(product.getWeight()).orElse(Env.ZERO));
        BigDecimal totalVolume = quantityToPackaging.multiply(Optional.ofNullable(product.getVolume()).orElse(Env.ZERO));
        packageLine.setWeight(totalWeight);
        packageLine.setVolume(totalVolume);
        packageLine.saveEx();
        return packageLine;
    }

    private MPackage createPackage(MOrder order) {
        MPackage packageToCreate = new MPackage(this.getContext(), 0, this.getTransactionName());
        packageToCreate.setAD_Org_ID(order.getAD_Org_ID());
        packageToCreate.setM_Warehouse_ID(order.getM_Warehouse_ID());
        packageToCreate.setDateDoc(order.getDateOrdered());
        if (order.getM_Shipper_ID() > 0) {
            packageToCreate.setM_Shipper_ID(order.getM_Shipper_ID());
        }
        packageToCreate.setC_BPartner_ID(order.getC_BPartner_ID());
        packageToCreate.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        packageToCreate.setDeliveryViaRule(order.getDeliveryViaRule());
        if (!Util.isEmpty((String)order.getFreightCostRule())) {
            packageToCreate.setFreightCostRule(order.getFreightCostRule());
        }
        if (order.getM_FreightCategory_ID() > 0) {
            packageToCreate.setM_FreightCategory_ID(order.getM_FreightCategory_ID());
        }
        packageToCreate.set_ValueOfColumn("C_Order_ID", (Object)order.getC_Order_ID());
        Optional<Integer> maybeDocumentType = Optional.of(MDocType.getDocType((String)"MMK", (int)packageToCreate.getAD_Org_ID()));
        if (maybeDocumentType.isPresent()) {
            packageToCreate.setC_DocType_ID(maybeDocumentType.get().intValue());
        }
        packageToCreate.setSalesRep_ID(order.getSalesRep_ID());
        packageToCreate.set_ValueOfColumn("M_PackageType_ID", (Object)this.getPackageType().getM_PackageType_ID());
        packageToCreate.saveEx(this.getTransactionName());
        this.packages.add(packageToCreate);
        return packageToCreate;
    }

    public final List<MPackage> createPackages() {
        this.orders.forEach(order -> Arrays.asList(order.getLines()).forEach(orderLine -> this.calculatePackagingFromOrderLine((MOrder)order, (MOrderLine)orderLine)));
        this.packages.forEach(packageToProcess -> {
            packageToProcess.processIt("CO");
            packageToProcess.saveEx();
        });
        return this.packages;
    }

    private BigDecimal getUnitsPerPallet(BigDecimal weight, BigDecimal volume) {
        return this.getUnitsPerPallet(weight, volume, null, null);
    }

    private BigDecimal getUnitsPerPallet(BigDecimal weight, BigDecimal volume, BigDecimal packageWeight, BigDecimal packageVolume) {
        weight = Optional.ofNullable(weight).orElse(Env.ZERO);
        volume = Optional.ofNullable(volume).orElse(Env.ZERO);
        if (weight.compareTo(Env.ZERO) == 0) {
            weight = Env.ONE;
        }
        if (volume.compareTo(Env.ZERO) == 0) {
            volume = Env.ONE;
        }
        BigDecimal weightPerPallet = Optional.ofNullable(packageWeight).orElse(Optional.ofNullable(this.maximumWeight).orElse(Env.ZERO)).divide(weight, 0, RoundingMode.DOWN);
        BigDecimal volumePerPallet = Optional.ofNullable(packageVolume).orElse(Optional.ofNullable(this.maximumVolume).orElse(Env.ZERO)).divide(volume, 0, RoundingMode.DOWN);
        BigDecimal unitPerPallet = weightPerPallet.min(volumePerPallet);
        return unitPerPallet.setScale(0, RoundingMode.DOWN);
    }
}

