/*
 * Decompiled with CFR 0.152.
 */
package org.spin.dms.util;

import java.sql.Timestamp;
import org.compiere.model.MPackage;
import org.compiere.model.MRequest;
import org.compiere.model.MStatus;
import org.compiere.model.Query;

public class DeliveryUtil {
    public static MRequest getRequestOfPackage(MPackage packageRequest) {
        return (MRequest)new Query(packageRequest.getCtx(), "R_Request", "M_Package_ID = ?", packageRequest.get_TrxName()).setParameters(new Object[]{packageRequest.getM_Package_ID()}).setOnlyActiveRecords(true).first();
    }

    public static void notifyRequestChangeFromPackage(MPackage packageRequest) {
        MRequest request = DeliveryUtil.getRequestOfPackage(packageRequest);
        if (request != null) {
            MStatus requestStatus;
            if (packageRequest.is_ValueChanged("DeliveryPackageStatus") && (requestStatus = DeliveryUtil.getRequestStatusFromPackage(packageRequest)) != null && requestStatus.getR_Status_ID() != 0) {
                request.setR_Status_ID(requestStatus.getR_Status_ID());
            }
            if (packageRequest.is_ValueChanged("CurrentWarehouse_ID")) {
                if (packageRequest.get_ValueAsInt("CurrentWarehouse_ID") != 0) {
                    request.set_ValueOfColumn("CurrentWarehouse_ID", (Object)packageRequest.get_ValueAsInt("CurrentWarehouse_ID"));
                } else {
                    request.set_ValueOfColumn("CurrentWarehouse_ID", null);
                }
            }
            if (packageRequest.is_ValueChanged("Description")) {
                request.setLastResult(packageRequest.getDescription());
            }
            if (packageRequest.is_ValueChanged("DateLastAction")) {
                request.setDateLastAction((Timestamp)packageRequest.get_Value("DateLastAction"));
            }
            if (packageRequest.is_ValueChanged("SalesRep_ID") && packageRequest.getSalesRep_ID() != 0) {
                request.setSalesRep_ID(packageRequest.getSalesRep_ID());
            }
            request.saveEx();
        }
    }

    public static MStatus getRequestStatusFromPackage(MPackage packageRequest) {
        return (MStatus)new Query(packageRequest.getCtx(), "R_Status", "DeliveryPackageStatus = ?", packageRequest.get_TrxName()).setParameters(new Object[]{packageRequest.get_ValueAsString("DeliveryPackageStatus")}).setOrderBy("AD_Client_ID DESC").first();
    }
}

