/*
 * Decompiled with CFR 0.152.
 */
package org.spin.dms.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.SB_InOutGenerateFromOrderLine;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPackage;
import org.compiere.model.MPackageLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDFreight;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.dms.model.MMPackageType;
import org.spin.dms.util.PackageFactory;

public class DeliveryManageServiceUtil {
    public static final String COLUMNNAME_CurrentWarehouse_ID = "CurrentWarehouse_ID";
    public static final String COLUMNNAME_DateLastAction = "DateLastAction";
    public static final String COLUMNNAME_DeliveryPackageStatus = "DeliveryPackageStatus";
    public static final int DeliveryPackageStatus_AD_Reference_ID = 135;
    public static final String DeliveryPackageStatus_Delivered_to_Customer = "D";
    public static final String DeliveryPackageStatus_Ready_to_Deliver = "R";
    public static final String DeliveryPackageStatus_In_Transit = "T";
    public static final String DeliveryPackageStatus_In_Warehouse = "W";
    public static final String DeliveryPackageStatus_On_Hold = "O";
    public static final String DeliveryPackageStatus_Is_Invoiced = "I";
    public static final String DeliveryPackageStatus_Collect_Received = "C";
    public static final String MESSAGE_PackageTypeValidationError = "PackageTypeValidationError";
    public static final String MESSAGE_OrderPackageValidationError = "OrderPackageValidationError";
    public static final String MESSAGE_OrderLinePackageValidationError = "OrderLinePackageValidationError";
    public static final String COLUMNNAME_IsAllocatePackages = "IsAllocatePackages";
    public static final String COLUMNNAME_IsCompleteUnitsPerPallet = "IsCompleteUnitsPerPallet";
    public static final String COLUMNNAME_MinimalUnitsPerPallet = "MinimalUnitsPerPallet";
    public static final String COLUMNNAME_EstimatedPallets = "EstimatedPallets";
    public static final String COLUMNNAME_RemainingQuantityForPallet = "RemainingQuantityForPallet";
    public static final String COLUMNNAME_RemainingPercentageForPallet = "RemainingPercentageForPallet";
    public static final String COLUMNNAME_SuggestedQuantityForPallet = "SuggestedQuantityForPallet";
    public static final String COLUMNNAME_IsValidateCompletePallet = "IsValidateCompletePallet";
    public static final String COLUMNNAME_MinimalEstimatedPallets = "MinimalEstimatedPallets";
    public static final String COLUMNNAME_MinimalSuggestedForPallet = "MinimalSuggestedForPallet";
    public static final String COLUMNNAME_LeftoverPercentageForPallet = "LeftoverPercentageForPallet";
    public static final String COLUMNNAME_LeftoverQuantityForPallet = "LeftoverQuantityForPallet";
    public static final String COLUMNNAME_IsMinimalUnitsPerPallet = "IsMinimalUnitsPerPallet";

    public static void addOrderLineToPackage(MPackage box, MOrderLine orderLine) {
        Optional<MPackageLine> maybePackageLine = box.getLines().stream().filter(packageLine -> packageLine.get_ValueAsInt("C_OrderLine_ID") == orderLine.getC_OrderLine_ID()).findFirst();
        if (maybePackageLine.isPresent()) {
            return;
        }
        MPackageLine packageLine2 = new MPackageLine(box);
        packageLine2.set_ValueOfColumn("C_OrderLine_ID", (Object)orderLine.getC_OrderLine_ID());
        packageLine2.setDescription(orderLine.getDescription());
        packageLine2.setQty(orderLine.getQtyOrdered());
        if (orderLine.getM_Product_ID() > 0) {
            MProduct product = MProduct.get((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID());
            packageLine2.setWidth(new BigDecimal(product.getShelfWidth()));
            packageLine2.setHeight(Optional.ofNullable(product.getShelfHeight()).orElse(Env.ZERO));
            packageLine2.setDepth(new BigDecimal(product.getShelfDepth()));
            BigDecimal totalWeight = orderLine.getQtyOrdered().multiply(Optional.ofNullable(product.getWeight()).orElse(Env.ZERO));
            BigDecimal totalVolume = orderLine.getQtyOrdered().multiply(Optional.ofNullable(product.getVolume()).orElse(Env.ZERO));
            packageLine2.setWeight(totalWeight);
            packageLine2.setVolume(totalVolume);
        }
        packageLine2.saveEx();
    }

    public static void validatePackageBasedOnType(MPackage packageToValidate) {
        if (packageToValidate == null) {
            return;
        }
        if (packageToValidate.get_ValueAsInt("M_PackageType_ID") <= 0) {
            throw new AdempiereException("@M_PackageType_ID@ @IsMandatory@");
        }
        MMPackageType packageType = MMPackageType.getById(packageToValidate.getCtx(), packageToValidate.get_ValueAsInt("M_PackageType_ID"), packageToValidate.get_TrxName());
        if (!DeliveryManageServiceUtil.isValidPackage(packageToValidate)) {
            throw new AdempiereException(Msg.getMsg((Properties)packageToValidate.getCtx(), (String)MESSAGE_PackageTypeValidationError, (Object[])new Object[]{packageToValidate.getDocumentNo(), packageToValidate.getWeight(), packageType.getWeight(), packageToValidate.getVolume(), packageType.getVolume(), packageToValidate.getHeight(), packageType.getHeight(), packageToValidate.getWidth(), packageType.getWidth(), packageToValidate.getDepth(), packageType.getDepth()}));
        }
    }

    public static void validateCompletePalletAllocation(MOrder order) {
        if (order == null) {
            return;
        }
        if (order.isSOTrx()) {
            return;
        }
        if (order.isReturnOrder()) {
            return;
        }
        if (!order.get_ValueAsBoolean(COLUMNNAME_IsAllocatePackages) || !order.get_ValueAsBoolean(COLUMNNAME_IsValidateCompletePallet)) {
            return;
        }
        List<MOrderLine> orderLines = Arrays.asList(order.getLines(true, null));
        StringBuffer missingLines = new StringBuffer();
        orderLines.stream().filter(orderLine -> orderLine.getM_Product_ID() > 0).forEach(orderLine -> {
            BigDecimal suggestedQuantity = Optional.ofNullable((BigDecimal)orderLine.get_Value(COLUMNNAME_SuggestedQuantityForPallet)).orElse(Env.ZERO);
            BigDecimal minimalSuggestedQuantity = Optional.ofNullable((BigDecimal)orderLine.get_Value(COLUMNNAME_MinimalSuggestedForPallet)).orElse(Env.ZERO);
            BigDecimal realQuantity = Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO);
            BigDecimal remainingQuantity = Optional.ofNullable((BigDecimal)orderLine.get_Value(COLUMNNAME_RemainingPercentageForPallet)).orElse(Env.ZERO);
            if (suggestedQuantity.compareTo(realQuantity) != 0 && minimalSuggestedQuantity.compareTo(realQuantity) != 0) {
                if (missingLines.length() > 0) {
                    missingLines.append(Env.NL);
                }
                MProduct product = MProduct.get((Properties)order.getCtx(), (int)orderLine.getM_Product_ID());
                missingLines.append(Msg.getMsg((Properties)order.getCtx(), (String)MESSAGE_OrderLinePackageValidationError, (Object[])new Object[]{orderLine.getLine(), product.getValue() + " - " + product.getName(), suggestedQuantity, realQuantity, remainingQuantity}));
            }
        });
        if (missingLines.length() > 0) {
            throw new AdempiereException("@OrderPackageValidationError@ " + missingLines.toString());
        }
    }

    public static boolean isValidPackage(MPackage packageToValidate) {
        MMPackageType packageType = MMPackageType.getById(packageToValidate.getCtx(), packageToValidate.get_ValueAsInt("M_PackageType_ID"), packageToValidate.get_TrxName());
        return packageType.isValidWeight(packageToValidate.getWeight()) && packageType.isValidVolume(packageToValidate.getVolume()) && packageType.isValidHeigh(packageToValidate.getHeight()) && packageType.isValidWidth(packageToValidate.getWidth()) && packageType.isValidDepth(packageToValidate.getDepth());
    }

    public static void generateShipmentFromFreighOrderOfPackages(MDDFreight freightOrder) {
        ProcessInfo processInformation;
        if (freightOrder == null) {
            return;
        }
        ArrayList orderLineIds = new ArrayList();
        LinkedHashMap selection = new LinkedHashMap();
        freightOrder.getLines().stream().filter(freightOrderLine -> freightOrderLine.getM_Package_ID() > 0).map(freightOrderLine -> (MPackage)freightOrderLine.getM_Package()).forEach(packageToProcess -> packageToProcess.getLines().stream().filter(packageLine -> packageLine.get_ValueAsInt("C_OrderLine_ID") > 0).forEach(packageLine -> {
            orderLineIds.add(packageLine.get_ValueAsInt("C_OrderLine_ID"));
            LinkedHashMap<String, BigDecimal> values = new LinkedHashMap<String, BigDecimal>();
            values.put("IO_QtyToDeliver", packageLine.getQty());
            selection.put(packageLine.get_ValueAsInt("C_OrderLine_ID"), values);
        }));
        if (orderLineIds.size() > 0 && (processInformation = ProcessBuilder.create((Properties)freightOrder.getCtx()).process(Integer.valueOf(SB_InOutGenerateFromOrderLine.getProcessId())).withoutTransactionClose().withRecordId(Integer.valueOf(MOrderLine.Table_ID), Integer.valueOf(0)).withSelectedRecordsIds(MOrderLine.Table_ID, orderLineIds, selection).withParameter("MovementDate", (Object)freightOrder.getDateDoc()).withParameter("DocAction", (Object)"CO").withParameter("ConsolidateDocument", (Object)true).execute(freightOrder.get_TrxName())).isError()) {
            throw new AdempiereException(processInformation.getSummary());
        }
    }

    public static void setAttributesFromDocumentType(MOrder order) {
        MDocType documentType = MDocType.get((Properties)order.getCtx(), (int)order.getC_DocTypeTarget_ID());
        order.set_ValueOfColumn(COLUMNNAME_IsAllocatePackages, (Object)documentType.get_ValueAsBoolean(COLUMNNAME_IsAllocatePackages));
        order.set_ValueOfColumn(COLUMNNAME_IsValidateCompletePallet, (Object)documentType.get_ValueAsBoolean(COLUMNNAME_IsValidateCompletePallet));
    }

    public static List<MPackage> createPackagesFromOrder(MOrder order) {
        if (!order.get_ValueAsBoolean(COLUMNNAME_IsAllocatePackages)) {
            return new ArrayList<MPackage>();
        }
        if (order.getM_Shipper_ID() <= 0) {
            throw new AdempiereException("@M_Shipper_ID@ @IsMandatory@");
        }
        PackageFactory factory = PackageFactory.newInstance().withContext(order.getCtx()).withTransactionName(order.get_TrxName()).withPackageTypeId(order.get_ValueAsInt("M_PackageType_ID"));
        factory.addOrder(order);
        List<MPackage> generatedPackages = factory.createPackages();
        BigDecimal totalPackages = Env.ZERO;
        if (generatedPackages != null) {
            totalPackages = new BigDecimal(generatedPackages.size());
        }
        order.set_ValueOfColumn(COLUMNNAME_EstimatedPallets, (Object)totalPackages);
        order.saveEx();
        return generatedPackages;
    }

    public static void reversePackagesFromOrder(MOrder order) {
        DeliveryManageServiceUtil.getValidPackagesFromOrder(order).forEach(packageToProcess -> {
            packageToProcess.processIt("VO");
            packageToProcess.saveEx();
        });
    }

    public static List<MPackage> getValidPackagesFromOrder(MOrder order) {
        return new Query(order.getCtx(), "M_Package", "M_Package.DocStatus NOT IN('CL', 'RE', 'VO') AND EXISTS(SELECT 1 FROM M_PackageLine pl INNER JOIN C_OrderLine ol ON(ol.C_OrderLine_ID = pl.C_OrderLine_ID) WHERE pl.M_Package_ID = M_Package.M_Package_ID AND ol.C_Order_ID = ?)", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).list();
    }

    public static boolean isValidPackage(MPackage packageToValidate, BigDecimal weightToAdd, BigDecimal volumeToAdd) {
        MMPackageType packageType = MMPackageType.getById(packageToValidate.getCtx(), packageToValidate.get_ValueAsInt("M_PackageType_ID"), packageToValidate.get_TrxName());
        return packageType.isValidWeight(packageToValidate.getWeight().add(weightToAdd)) && packageType.isValidVolume(packageToValidate.getVolume().add(volumeToAdd)) && packageType.isValidHeigh(packageToValidate.getHeight()) && packageType.isValidWidth(packageToValidate.getWidth()) && packageType.isValidDepth(packageToValidate.getDepth());
    }

    public static void calculateCompleteUnitsPerPallet(MOrderLine orderLine) {
        MProduct product = (MProduct)orderLine.getM_Product();
        if (Optional.ofNullable((BigDecimal)orderLine.get_Value(COLUMNNAME_MinimalUnitsPerPallet)).orElse(Env.ZERO).compareTo(Env.ZERO) <= 0) {
            orderLine.set_ValueOfColumn(COLUMNNAME_MinimalUnitsPerPallet, (Object)product.getUnitsPerPallet());
        }
        if (Optional.ofNullable((BigDecimal)orderLine.get_Value(COLUMNNAME_MinimalUnitsPerPallet)).orElse(Env.ZERO).compareTo(Env.ZERO) <= 0) {
            return;
        }
        if (Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO).compareTo(Env.ZERO) <= 0) {
            return;
        }
        if (orderLine.getM_Product_ID() <= 0) {
            return;
        }
        int precision = MUOM.getPrecision((Properties)product.getCtx(), (int)product.getC_UOM_ID());
        BigDecimal minimalUnitsPerPallet = Optional.ofNullable((BigDecimal)orderLine.get_Value(COLUMNNAME_MinimalUnitsPerPallet)).orElse(Env.ZERO);
        BigDecimal quantityOrdered = Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO);
        BigDecimal estimatedPallets = quantityOrdered.divide(minimalUnitsPerPallet, 0, RoundingMode.UP);
        BigDecimal minimalEstimatedPallets = quantityOrdered.divide(minimalUnitsPerPallet, 0, RoundingMode.DOWN);
        BigDecimal estimatedQuantityOrdered = estimatedPallets.multiply(minimalUnitsPerPallet);
        BigDecimal minimalEstimatedQuantityOrdered = minimalEstimatedPallets.multiply(minimalUnitsPerPallet);
        if (minimalEstimatedQuantityOrdered.compareTo(Env.ZERO) <= 0) {
            minimalEstimatedQuantityOrdered = Env.ONE;
        }
        BigDecimal quantityEntered = MUOMConversion.convertProductTo((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID(), (int)orderLine.getC_UOM_ID(), (BigDecimal)estimatedQuantityOrdered);
        BigDecimal minimalQuantityEntered = MUOMConversion.convertProductTo((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID(), (int)orderLine.getC_UOM_ID(), (BigDecimal)minimalEstimatedQuantityOrdered);
        estimatedQuantityOrdered = estimatedQuantityOrdered.setScale(precision, 4);
        minimalEstimatedQuantityOrdered = minimalEstimatedQuantityOrdered.setScale(precision, 4);
        BigDecimal remainingQuantity = estimatedQuantityOrdered.subtract(quantityOrdered);
        BigDecimal leftoverQuantity = quantityOrdered.subtract(minimalEstimatedQuantityOrdered);
        orderLine.set_ValueOfColumn(COLUMNNAME_RemainingQuantityForPallet, (Object)remainingQuantity.setScale(precision, 4));
        orderLine.set_ValueOfColumn(COLUMNNAME_RemainingPercentageForPallet, (Object)remainingQuantity.multiply(Env.ONEHUNDRED).divide(estimatedQuantityOrdered, precision, 4));
        orderLine.set_ValueOfColumn(COLUMNNAME_SuggestedQuantityForPallet, (Object)estimatedQuantityOrdered);
        orderLine.set_ValueOfColumn(COLUMNNAME_EstimatedPallets, (Object)estimatedPallets);
        orderLine.set_ValueOfColumn(COLUMNNAME_LeftoverQuantityForPallet, (Object)leftoverQuantity.setScale(precision, 4));
        orderLine.set_ValueOfColumn(COLUMNNAME_LeftoverPercentageForPallet, (Object)leftoverQuantity.multiply(Env.ONEHUNDRED).divide(minimalEstimatedQuantityOrdered, precision, 4));
        orderLine.set_ValueOfColumn(COLUMNNAME_MinimalSuggestedForPallet, (Object)minimalEstimatedQuantityOrdered);
        orderLine.set_ValueOfColumn(COLUMNNAME_MinimalEstimatedPallets, (Object)minimalEstimatedPallets);
        if (orderLine.get_ValueAsBoolean(COLUMNNAME_IsMinimalUnitsPerPallet)) {
            orderLine.setQtyOrdered(minimalEstimatedQuantityOrdered);
            orderLine.setQtyEntered(minimalQuantityEntered);
        }
        if (orderLine.get_ValueAsBoolean(COLUMNNAME_IsCompleteUnitsPerPallet)) {
            orderLine.setQtyOrdered(estimatedQuantityOrdered);
            orderLine.setQtyEntered(quantityEntered);
        }
        if (Optional.ofNullable(product.getUnitsPerPallet()).orElse(Env.ZERO).compareTo(Env.ZERO) <= 0 && Optional.ofNullable(minimalUnitsPerPallet).orElse(Env.ZERO).compareTo(Env.ZERO) > 0) {
            product.setUnitsPerPallet(minimalUnitsPerPallet);
            product.save(orderLine.get_TrxName());
        }
    }
}

