/*
 * Decompiled with CFR 0.152.
 */
package org.spin.dms.process;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MFreight;
import org.compiere.model.MFreightCategory;
import org.compiere.model.MOrder;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.eevolution.model.MDDFreight;
import org.eevolution.model.MDDFreightLine;
import org.spin.dms.process.CreateFreightOrderFromPurchaseOrderAbstract;

public class CreateFreightOrderFromPurchaseOrder
extends CreateFreightOrderFromPurchaseOrderAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@C_Order_ID@ @NotFound@");
        }
        if (this.getFreightAmt() == null) {
            this.setFreightAmt(Env.ZERO);
        }
        if (this.getDateDoc() == null) {
            this.setDateDoc(TimeUtil.getDay((long)System.currentTimeMillis()));
        }
    }

    protected String doIt() throws Exception {
        MOrder order = new MOrder(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (!order.isProcessed()) {
            throw new AdempiereException("@C_Order_ID@ @Not@ @Processed@");
        }
        AtomicReference<MDDFreight> freightWrapper = new AtomicReference<MDDFreight>();
        if (this.isAddToFreightOrder()) {
            if (this.getFreightId() <= 0) {
                throw new AdempiereException("@DD_Freight_ID@ @IsMandatory@");
            }
            freightWrapper.set(new MDDFreight(this.getCtx(), this.getFreightId(), this.get_TrxName()));
        } else {
            MDDFreight freightOrder = new MDDFreight(this.getCtx(), 0, this.get_TrxName());
            if (this.getDriverId() > 0) {
                freightOrder.setDD_Driver_ID(this.getDriverId());
            }
            if (this.getVehicleId() > 0) {
                freightOrder.setDD_Vehicle_ID(this.getVehicleId());
            }
            freightOrder.setDateDoc(this.getDateDoc());
            if (this.getShipperId() <= 0) {
                this.setShipperId(order.getM_Shipper_ID());
            }
            freightOrder.setM_Shipper_ID(this.getShipperId());
            freightOrder.setDateOrdered(this.getDateDoc());
            if (this.getDocTypeTargetId() > 0) {
                freightOrder.setC_DocType_ID(this.getDocTypeTargetId());
            } else {
                freightOrder.setC_DocType_ID(MDocType.getDocType((String)"FRO", (int)Env.getAD_Org_ID((Properties)this.getCtx())));
            }
            freightOrder.setDocAction(this.getDocAction());
            if (this.isOverwriteFreightCostRule()) {
                freightOrder.setFreightCostRule(this.getFreightCostRule());
            }
            freightOrder.setFreightAmt(this.getFreightAmt());
            freightOrder.saveEx();
            freightWrapper.set(freightOrder);
        }
        AtomicInteger lineNo = new AtomicInteger();
        AtomicInteger lines = new AtomicInteger();
        AtomicReference<BigDecimal> freightAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        Arrays.asList(order.getLines()).forEach(orderLine -> {
            MDDFreightLine freightLine = new MDDFreightLine(this.getCtx(), 0, this.get_TrxName());
            freightLine.setDD_Freight_ID(((MDDFreight)freightWrapper.get()).getDD_Freight_ID());
            freightLine.setLine(lineNo.addAndGet(10));
            freightLine.setWeight((BigDecimal)orderLine.get_Value("Weight"));
            freightLine.setVolume((BigDecimal)orderLine.get_Value("Volume"));
            freightLine.setFreightAmt(orderLine.getFreightAmt());
            if (this.isOverwriteFreightCostRule()) {
                freightLine.setM_FreightCategory_ID(this.getFreightCategoryId());
                MFreight freight = new MFreight(this.getCtx(), this.getFreightCategoryId(), this.get_TrxName());
                freightLine.setM_FreightCategory_ID(freight.getM_FreightCategory_ID());
            } else {
                freightLine.setM_FreightCategory_ID(orderLine.getM_FreightCategory_ID());
            }
            MClientInfo clientInfo = MClientInfo.get((Properties)this.getCtx());
            if (clientInfo.getC_UOM_Weight_ID() <= 0) {
                throw new AdempiereException("@C_UOM_Weight_ID@ @NotFound@ @SeeClientInfoConfig@");
            }
            if (clientInfo.getC_UOM_Volume_ID() <= 0) {
                throw new AdempiereException("@C_UOM_Volume_ID@ @NotFound@ @SeeClientInfoConfig@");
            }
            freightLine.setWeight_UOM_ID(clientInfo.getC_UOM_Weight_ID());
            freightLine.setVolume_UOM_ID(clientInfo.getC_UOM_Volume_ID());
            freightLine.setIsInvoiced(true);
            if (this.getFreightCategoryId() <= 0) {
                this.setFreightCategoryId(orderLine.getM_FreightCategory_ID());
            }
            if (this.getFreightCategoryId() <= 0 && !this.isAddToFreightOrder()) {
                throw new AdempiereException("@M_FreightCategory_ID@ @NotFound@");
            }
            if (this.getFreightCategoryId() > 0) {
                MFreightCategory freightCategory = MFreightCategory.getById((Properties)this.getCtx(), (int)this.getFreightCategoryId(), (String)this.get_TrxName());
                if (freightLine.isInvoiced() && freightCategory.getM_Product_ID() <= 0 && freightCategory.getC_Charge_ID() <= 0) {
                    throw new AdempiereException(freightCategory.getName() + ": @IsInvoiced@ @M_Product_ID@ / @C_Charge_ID@ @NotFound@");
                }
                if (freightCategory.getM_Product_ID() > 0) {
                    freightLine.setM_Product_ID(freightCategory.getM_Product_ID());
                } else {
                    freightLine.setC_Charge_ID(freightCategory.getC_Charge_ID());
                }
            }
            freightLine.saveEx();
            lines.addAndGet(1);
            freightAmount.getAndUpdate(amount -> amount.add(orderLine.getFreightAmt()));
            this.addLog(((MDDFreight)freightWrapper.get()).getDD_Freight_ID(), ((MDDFreight)freightWrapper.get()).getDateDoc(), null, "@Created@");
        });
        if (!this.isOverwriteFreightCostRule()) {
            ((MDDFreight)freightWrapper.get()).setFreightAmt(freightAmount.get());
        }
        ((MDDFreight)freightWrapper.get()).processIt(this.getDocAction());
        ((MDDFreight)freightWrapper.get()).saveEx();
        this.openResult("DD_Freight");
        return "@DD_Freight_ID@ @Created@: " + ((MDDFreight)freightWrapper.get()).getDocumentInfo() + " @Lines@: " + lines.get();
    }
}

