/*
 * Decompiled with CFR 0.152.
 */
package org.spin.dms.model.validator;

import org.compiere.model.I_M_Package;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPackage;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.eevolution.model.I_DD_Freight;
import org.eevolution.model.MDDFreight;
import org.spin.dms.util.DeliveryManageServiceUtil;
import org.spin.dms.util.DeliveryUtil;

public class DeliveryManagementService
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(DeliveryManagementService.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_Package", (ModelValidator)this);
        engine.addDocValidate("DD_Freight", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
        engine.addModelChange("M_Package", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 5) {
            if (entity.get_TableName().equals("M_Package")) {
                MPackage packageToProcess = (MPackage)entity;
                DeliveryUtil.notifyRequestChangeFromPackage(packageToProcess);
            }
        } else if (type == 2 || type == 1) {
            if (entity.get_TableName().equals("C_Order")) {
                if (entity.is_new() || entity.is_ValueChanged("C_DocTypeTarget_ID")) {
                    MOrder order = (MOrder)entity;
                    DeliveryManageServiceUtil.setAttributesFromDocumentType(order);
                }
            } else if (entity.get_TableName().equals("C_OrderLine") && (type == 1 || entity.is_ValueChanged("QtyOrdered") || entity.is_ValueChanged("M_Product_ID") || entity.is_ValueChanged("IsMinimalUnitsPerPallet") || entity.is_ValueChanged("IsCompleteUnitsPerPallet") || entity.is_ValueChanged("MinimalUnitsPerPallet"))) {
                MOrderLine orderLine = (MOrderLine)entity;
                DeliveryManageServiceUtil.calculateCompleteUnitsPerPallet(orderLine);
            }
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        MOrder order;
        if (timing == 11) {
            if (entity.get_Table_ID() == I_M_Package.Table_ID) {
                MPackage packageToProcess = (MPackage)entity;
                DeliveryUtil.notifyRequestChangeFromPackage(packageToProcess);
            }
        } else if (timing == 1) {
            if (entity.get_Table_ID() == I_M_Package.Table_ID) {
                MPackage packageToProcess = (MPackage)entity;
                DeliveryManageServiceUtil.validatePackageBasedOnType(packageToProcess);
            } else if (entity.get_TableName().equals("C_Order")) {
                MOrder order2 = (MOrder)entity;
                DeliveryManageServiceUtil.validateCompletePalletAllocation(order2);
            }
        } else if (timing == 9) {
            MOrder order3;
            if (entity.get_Table_ID() == I_DD_Freight.Table_ID) {
                MDDFreight freightOrder = (MDDFreight)entity;
                DeliveryManageServiceUtil.generateShipmentFromFreighOrderOfPackages(freightOrder);
            } else if (entity.get_TableName().equals("C_Order") && !(order3 = (MOrder)entity).isSOTrx() && !order3.isReturnOrder() && order3.get_ValueAsBoolean("IsAllocatePackages")) {
                DeliveryManageServiceUtil.createPackagesFromOrder(order3);
            }
        } else if ((timing == 10 || timing == 12) && entity.get_TableName().equals("C_Order") && !(order = (MOrder)entity).isSOTrx() && !order.isReturnOrder() && order.get_ValueAsBoolean("IsAllocatePackages")) {
            DeliveryManageServiceUtil.reversePackagesFromOrder(order);
        }
        return null;
    }
}

