/*
 * Decompiled with CFR 0.152.
 */
package org.spin.dms.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.dms.model.X_M_PackageType;

public class MMPackageType
extends X_M_PackageType {
    private static final long serialVersionUID = -1171525387615789574L;
    private static CCache<Integer, MMPackageType> packageTypeCacheIds = new CCache("M_PackageType", 30);
    private static CCache<String, MMPackageType> packageTypeCacheValues = new CCache("M_PackageType", 30);

    public MMPackageType(Properties ctx, int packageTypeId, String trxName) {
        super(ctx, packageTypeId, trxName);
    }

    public MMPackageType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MMPackageType getById(Properties ctx, int packageTypeId, String trxName) {
        if (packageTypeId <= 0) {
            return null;
        }
        MMPackageType definition = (MMPackageType)packageTypeCacheIds.get((Object)packageTypeId);
        if (definition != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MMPackageType)new Query(ctx, "M_PackageType", "M_PackageType_ID=?", trxName).setParameters(new Object[]{packageTypeId}).first();
        if (definition != null && definition.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + definition.getValue();
            packageTypeCacheValues.put((Object)key, (Object)definition);
            packageTypeCacheIds.put((Object)definition.get_ID(), (Object)definition);
        }
        return definition;
    }

    public static MMPackageType getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MMPackageType definition;
        if (value == null) {
            return null;
        }
        if (packageTypeCacheValues.size() == 0) {
            MMPackageType.getAll(ctx, true, trxName);
        }
        if ((definition = (MMPackageType)packageTypeCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value))) != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MMPackageType)new Query(ctx, "M_PackageType", "Value=? AND AD_Client_ID IN(0, ?)", trxName).setParameters(new Object[]{value, clientId}).setOrderBy("AD_Client_ID DESC").first();
        if (definition != null && definition.get_ID() > 0) {
            packageTypeCacheValues.put((Object)key, (Object)definition);
            packageTypeCacheIds.put((Object)definition.get_ID(), (Object)definition);
        }
        return definition;
    }

    public static List<MMPackageType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || packageTypeCacheIds.size() > 0) {
            List definitionList = new Query(Env.getCtx(), "M_PackageType", null, trxName).setClient_ID().setOrderBy("Name").list();
            definitionList.stream().forEach(definition -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + definition.getValue();
                packageTypeCacheIds.put((Object)definition.getM_PackageType_ID(), definition);
                packageTypeCacheValues.put((Object)key, definition);
            });
            return definitionList;
        }
        List<MMPackageType> definitionList = packageTypeCacheIds.entrySet().stream().map(activity -> (MMPackageType)activity.getValue()).collect(Collectors.toList());
        return definitionList;
    }

    public boolean isValidWeight(BigDecimal weight) {
        return Optional.ofNullable(this.getWeight()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0 || Optional.ofNullable(weight).orElse(Env.ZERO).compareTo(Optional.ofNullable(this.getWeight()).orElse(Env.ZERO)) <= 0;
    }

    public boolean isValidVolume(BigDecimal volume) {
        return Optional.ofNullable(this.getVolume()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0 || Optional.ofNullable(volume).orElse(Env.ZERO).compareTo(Optional.ofNullable(this.getVolume()).orElse(Env.ZERO)) <= 0;
    }

    public boolean isValidHeigh(BigDecimal heigh) {
        return Optional.ofNullable(this.getHeight()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0 || Optional.ofNullable(heigh).orElse(Env.ZERO).compareTo(Optional.ofNullable(this.getHeight()).orElse(Env.ZERO)) <= 0;
    }

    public boolean isValidWidth(BigDecimal width) {
        return Optional.ofNullable(this.getWidth()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0 || Optional.ofNullable(width).orElse(Env.ZERO).compareTo(Optional.ofNullable(this.getWidth()).orElse(Env.ZERO)) <= 0;
    }

    public boolean isValidDepth(BigDecimal depth) {
        return Optional.ofNullable(this.getDepth()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0 || Optional.ofNullable(depth).orElse(Env.ZERO).compareTo(Optional.ofNullable(this.getDepth()).orElse(Env.ZERO)) <= 0;
    }

    @Override
    public String toString() {
        return "MMPackageType [getM_PackageType_ID()=" + this.getM_PackageType_ID() + ", getName()=" + this.getName() + ", getUUID()=" + this.getUUID() + ", getValue()=" + this.getValue() + "]";
    }
}

