/*
 * Decompiled with CFR 0.152.
 */
package org.spin.update.setup;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MProcess;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.TimeUtil;
import org.spin.update.process.ApplyUpdates;
import org.spin.update.process.CheckAvailablePackages;
import org.spin.update.process.DownloadUpdates;
import org.spin.update.process.LookingForUpdates;
import org.spin.util.ISetupDefinition;

public class UpdateManagementSetup
implements ISetupDefinition {
    private static final String SETUP_DESCRIPTION = "(*Created from Setup Automatically*)";
    private final Timestamp NEXT_RUN_AVAILABLE_PACKAGES = TimeUtil.addDays((Timestamp)TimeUtil.getDay((long)System.currentTimeMillis()), (int)1);
    private final Timestamp NEXT_RUN_LOOKING_FOR_UPDATES = TimeUtil.addMinutess((Timestamp)this.NEXT_RUN_AVAILABLE_PACKAGES, (int)10);
    private final Timestamp NEXT_RUN_DOWNLOAD_UPDATES = TimeUtil.addMinutess((Timestamp)this.NEXT_RUN_LOOKING_FOR_UPDATES, (int)10);
    private final Timestamp NEXT_RUN_APPLY_UPDATES = TimeUtil.addMinutess((Timestamp)this.NEXT_RUN_DOWNLOAD_UPDATES, (int)30);

    public String doIt(Properties context, String transactionName) {
        this.createAvailablePackages(context, transactionName);
        this.createLookingForUpdate(context, transactionName);
        this.createDownloadUpdates(context, transactionName);
        this.createApplyUpdates(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createAvailablePackages(Properties context, String transactionName) {
        new Query(context, "AD_Scheduler", "AD_Process_ID = ?", transactionName).setParameters(new Object[]{CheckAvailablePackages.getProcessId()}).setClient_ID().list().forEach(scheduler -> scheduler.deleteEx(true));
        MScheduler scheduler2 = new MScheduler(context, 0, transactionName);
        scheduler2.setAD_Org_ID(0);
        scheduler2.setName(CheckAvailablePackages.getProcessName());
        scheduler2.setDescription(SETUP_DESCRIPTION);
        scheduler2.setAD_Process_ID(CheckAvailablePackages.getProcessId());
        scheduler2.setSupervisor_ID(100);
        scheduler2.setIsIgnoreProcessingTime(true);
        scheduler2.setFrequencyType("D");
        scheduler2.setFrequency(1);
        scheduler2.setKeepLogDays(7);
        scheduler2.setDateNextRun(this.NEXT_RUN_AVAILABLE_PACKAGES);
        scheduler2.saveEx();
    }

    private void createLookingForUpdate(Properties context, String transactionName) {
        new Query(context, "AD_Scheduler", "AD_Process_ID = ?", transactionName).setParameters(new Object[]{LookingForUpdates.getProcessId()}).setClient_ID().list().forEach(scheduler -> scheduler.deleteEx(true));
        MScheduler scheduler2 = new MScheduler(context, 0, transactionName);
        scheduler2.setAD_Org_ID(0);
        scheduler2.setName(LookingForUpdates.getProcessName());
        scheduler2.setDescription(SETUP_DESCRIPTION);
        scheduler2.setAD_Process_ID(LookingForUpdates.getProcessId());
        scheduler2.setSupervisor_ID(100);
        scheduler2.setIsIgnoreProcessingTime(true);
        scheduler2.setFrequencyType("D");
        scheduler2.setFrequency(1);
        scheduler2.setKeepLogDays(7);
        scheduler2.setDateNextRun(this.NEXT_RUN_LOOKING_FOR_UPDATES);
        scheduler2.saveEx();
        MProcess process = MProcess.get((Properties)context, (int)LookingForUpdates.getProcessId());
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("IsOnlyAutomaticUpdate")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("Y");
            schedulerParameter.saveEx();
        });
    }

    private void createDownloadUpdates(Properties context, String transactionName) {
        new Query(context, "AD_Scheduler", "AD_Process_ID = ?", transactionName).setParameters(new Object[]{DownloadUpdates.getProcessId()}).setClient_ID().list().forEach(scheduler -> scheduler.deleteEx(true));
        MScheduler scheduler2 = new MScheduler(context, 0, transactionName);
        scheduler2.setAD_Org_ID(0);
        scheduler2.setName(DownloadUpdates.getProcessName());
        scheduler2.setDescription(SETUP_DESCRIPTION);
        scheduler2.setAD_Process_ID(DownloadUpdates.getProcessId());
        scheduler2.setSupervisor_ID(100);
        scheduler2.setIsIgnoreProcessingTime(true);
        scheduler2.setFrequencyType("D");
        scheduler2.setFrequency(1);
        scheduler2.setKeepLogDays(7);
        scheduler2.setDateNextRun(this.NEXT_RUN_DOWNLOAD_UPDATES);
        scheduler2.saveEx();
        MProcess process = MProcess.get((Properties)context, (int)DownloadUpdates.getProcessId());
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("IsOnlyAutomaticUpdate")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("Y");
            schedulerParameter.saveEx();
        });
        List<MClient> clients = Arrays.asList(MClient.getAll((Properties)context));
        Optional<MClient> someClient = clients.stream().sorted(Comparator.comparing(PO::getAD_Client_ID).reversed()).findFirst();
        if (someClient.isPresent()) {
            process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("OverwriteLanguage")).findFirst().ifPresent(parameter -> {
                MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
                schedulerParameter.setAD_Org_ID(0);
                schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
                schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
                schedulerParameter.setParameterDefault(((MClient)someClient.get()).getAD_Language());
                schedulerParameter.saveEx();
            });
        }
    }

    private void createApplyUpdates(Properties context, String transactionName) {
        new Query(context, "AD_Scheduler", "AD_Process_ID = ?", transactionName).setParameters(new Object[]{ApplyUpdates.getProcessId()}).setClient_ID().list().forEach(scheduler -> scheduler.deleteEx(true));
        MScheduler scheduler2 = new MScheduler(context, 0, transactionName);
        scheduler2.setAD_Org_ID(0);
        scheduler2.setName(ApplyUpdates.getProcessName());
        scheduler2.setDescription(SETUP_DESCRIPTION);
        scheduler2.setAD_Process_ID(ApplyUpdates.getProcessId());
        scheduler2.setSupervisor_ID(100);
        scheduler2.setIsIgnoreProcessingTime(true);
        scheduler2.setFrequencyType("D");
        scheduler2.setFrequency(1);
        scheduler2.setKeepLogDays(7);
        scheduler2.setDateNextRun(this.NEXT_RUN_APPLY_UPDATES);
        scheduler2.saveEx();
        MProcess process = MProcess.get((Properties)context, (int)ApplyUpdates.getProcessId());
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("IsOnlyAutomaticUpdate")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("Y");
            schedulerParameter.saveEx();
        });
    }
}

