/*
 * Decompiled with CFR 0.152.
 */
package org.spin.update.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.compiere.model.MMigration;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.base.util.UpdateManager;
import org.spin.client.UpdaterClient;
import org.spin.grpc.util.ListUpdatesResponse;
import org.spin.update.process.LookingForUpdatesAbstract;
import org.spin.update.util.UpdaterService;

public class LookingForUpdates
extends LookingForUpdatesAbstract {
    private static final Logger logger = Logger.getLogger(UpdaterClient.class.getName());
    private AtomicInteger created = new AtomicInteger();

    protected String doIt() throws Exception {
        long start = System.currentTimeMillis();
        StringBuffer whereClause = new StringBuffer();
        ArrayList<String> parameters = new ArrayList<String>();
        if (!Util.isEmpty((String)this.getEntityType())) {
            whereClause.append("EntityType = ?");
            parameters.add(this.getEntityType());
        }
        if (this.isOnlyAutomaticUpdate()) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("IsAutomaticUpdate = 'Y'");
        }
        List entitiesForUpdate = new Query(Env.getCtx(), "AD_EntityType", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("EntityType").list();
        entitiesForUpdate.stream().forEach(entity -> {
            HashMap<String, Boolean> currentMigrationHeaders = new HashMap<String, Boolean>();
            new Query(Env.getCtx(), "AD_Migration", "EntityType = ?" + (!Util.isEmpty((String)this.getReleaseNo()) ? " AND ReleaseNo = '" + this.getReleaseNo() + "'" : ""), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{entity.getEntityType()}).setOrderBy("SeqNo").list().forEach(migration -> currentMigrationHeaders.put(this.getKeyForMigration(migration.getSeqNo(), migration.getEntityType(), migration.getReleaseNo(), migration.getName()), true));
            this.downloadHeaders(currentMigrationHeaders, entity.getEntityType(), entity.getVersion());
        });
        long end = System.currentTimeMillis();
        return "@AD_Migration_ID@ @Created@: " + this.created + " - @WaitingTime@: " + TimeUtil.formatElapsed((long)(end - start));
    }

    private String getKeyForMigration(int sequence, String entityType, String releaseNo, String name) {
        return sequence + "|" + Optional.ofNullable(entityType).orElse("").trim() + "|" + Optional.ofNullable(releaseNo).orElse("").trim() + "|" + Optional.ofNullable(name).orElse("").trim();
    }

    private void downloadHeaders(Map<String, Boolean> currentHeaders, String entityType, String releaseNo) {
        ListUpdatesResponse updatesResponse;
        String pageToken = null;
        do {
            logger.info("####################### Packages #####################");
            updatesResponse = UpdateManager.newInstance().withHost(UpdaterService.getHost()).withPort(UpdaterService.getPort()).withToken(UpdaterService.getToken()).listUpdates(entityType, releaseNo, pageToken);
            updatesResponse.getUpdatesList().stream().filter(migration -> currentHeaders.get(this.getKeyForMigration(migration.getSequence(), migration.getEntityType(), migration.getReleaseNo(), migration.getName())) == null).forEach(migrationHeader -> Trx.run(transactionName -> {
                try {
                    logger.info("Updates: " + migrationHeader);
                    MMigration newMigration = new MMigration(this.getCtx(), 0, transactionName);
                    newMigration.setSeqNo(migrationHeader.getSequence());
                    newMigration.setReleaseNo(migrationHeader.getReleaseNo());
                    newMigration.setName(migrationHeader.getName());
                    newMigration.setEntityType(migrationHeader.getEntityType());
                    if (this.isOnlyAutomaticUpdate()) {
                        newMigration.setStatusCode("H");
                    } else {
                        newMigration.setStatusCode("W");
                    }
                    newMigration.set_ValueOfColumn("StepQuantity", (Object)new BigDecimal(migrationHeader.getStepQuantity()));
                    newMigration.saveEx();
                    newMigration.setUUID(migrationHeader.getUuid());
                    newMigration.setIsDirectLoad(true);
                    newMigration.saveEx();
                    this.created.incrementAndGet();
                    Trx.get((String)transactionName, (boolean)false).commit(true);
                }
                catch (Exception e) {
                    logger.severe("Commit error: " + e.getLocalizedMessage());
                }
            }));
            logger.info("nextpageToken: " + updatesResponse.getNextPageToken());
        } while (!Util.isEmpty((String)(pageToken = updatesResponse.getNextPageToken())));
    }
}

