/*
 * Decompiled with CFR 0.152.
 */
package org.spin.update.process;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.compiere.model.MMigration;
import org.compiere.model.MMigrationData;
import org.compiere.model.MMigrationStep;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.base.util.UpdateManager;
import org.spin.client.UpdaterClient;
import org.spin.grpc.util.ListStepsResponse;
import org.spin.update.process.DownloadUpdatesAbstract;
import org.spin.update.util.UpdaterService;

public class DownloadUpdates
extends DownloadUpdatesAbstract {
    private static final Logger logger = Logger.getLogger(UpdaterClient.class.getName());
    private AtomicInteger migrationsUpdated = new AtomicInteger();
    private AtomicInteger stepsCreated = new AtomicInteger();

    protected String doIt() throws Exception {
        long start = System.currentTimeMillis();
        List migrationHeaderIds = new Query(Env.getCtx(), "AD_Migration", "StatusCode IN(?, ?)", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{"H", "D"}).setOrderBy("SeqNo").getIDsAsList();
        migrationHeaderIds.stream().forEach(migrationId -> {
            AtomicReference pageToken = new AtomicReference();
            AtomicInteger currentSequence = new AtomicInteger(0);
            Trx.run(updateCurrentMigrationTransactionName -> {
                try {
                    MMigration migration = new MMigration(this.getCtx(), migrationId.intValue(), updateCurrentMigrationTransactionName);
                    migration.setStatusCode("D");
                    migration.saveEx(updateCurrentMigrationTransactionName);
                    int currentSequenceFromDB = DB.getSQLValue((String)updateCurrentMigrationTransactionName, (String)"SELECT MAX(s.SeqNo) FROM AD_MigrationStep s WHERE s.AD_Migration_ID = ?", (int)migrationId);
                    logger.info("Current Data Sequence: " + currentSequenceFromDB);
                    if (currentSequenceFromDB > 0) {
                        currentSequence.set(currentSequenceFromDB);
                    }
                    Trx.get((String)updateCurrentMigrationTransactionName, (boolean)false).commit(true);
                }
                catch (Exception e) {
                    logger.severe("Migratin Commit error: " + e.getLocalizedMessage());
                }
            });
            AtomicBoolean isDownloaded = new AtomicBoolean(true);
            Trx.run(migrationTransactionName -> {
                do {
                    logger.info("####################### Packages ##################### Pages: ");
                    MMigration migration = new MMigration(this.getCtx(), migrationId.intValue(), migrationTransactionName);
                    ListStepsResponse stepsResponse = UpdateManager.newInstance().withHost(UpdaterService.getHost()).withPort(UpdaterService.getPort()).withToken(UpdaterService.getToken()).listSteps(migration.get_UUID(), (String)pageToken.get(), currentSequence.get());
                    stepsResponse.getStepsList().forEach(packageValue -> Trx.run(transactionName -> {
                        try {
                            this.stepsCreated.getAndIncrement();
                            logger.info("Steps: " + packageValue);
                            MMigrationStep updateMigrationStep = new MMigrationStep(this.getCtx(), 0, transactionName);
                            updateMigrationStep.setStepType(packageValue.getStepType());
                            updateMigrationStep.setAD_Table_ID(packageValue.getTableId());
                            updateMigrationStep.setRecord_ID(packageValue.getRecordId());
                            updateMigrationStep.setComments(packageValue.getComments());
                            updateMigrationStep.setAD_Migration_ID(migration.getAD_Migration_ID());
                            updateMigrationStep.setSeqNo(packageValue.getSequence());
                            if (packageValue.getStepType().equals("SQL")) {
                                updateMigrationStep.setSQLStatement(packageValue.getSqlStatement());
                                updateMigrationStep.setRollbackStatement(packageValue.getRollbackStatement());
                                if (!Util.isEmpty((String)packageValue.getDatabaseType())) {
                                    updateMigrationStep.setDBType(packageValue.getDatabaseType());
                                } else {
                                    updateMigrationStep.setDBType("ALL");
                                }
                            } else {
                                updateMigrationStep.setAction(packageValue.getAction());
                            }
                            updateMigrationStep.setStatusCode("U");
                            updateMigrationStep.saveEx();
                            updateMigrationStep.setUUID(packageValue.getUuid());
                            updateMigrationStep.setIsDirectLoad(true);
                            updateMigrationStep.saveEx();
                            int migrationStepId = updateMigrationStep.getAD_MigrationStep_ID();
                            if (!packageValue.getStepValuesList().isEmpty()) {
                                packageValue.getStepValuesList().stream().forEach(data -> {
                                    MMigrationData updateMigrationData = new MMigrationData(this.getCtx(), 0, transactionName);
                                    updateMigrationData.setIsBackupNull(data.getIsBackupNull());
                                    updateMigrationData.setIsNewNull(data.getIsNewNull());
                                    updateMigrationData.setIsOldNull(data.getIsOldNull());
                                    updateMigrationData.setAD_Column_ID(data.getColumnId());
                                    updateMigrationData.setNewValue(data.getNewValue());
                                    updateMigrationData.setOldValue(data.getOldValue());
                                    updateMigrationData.setAD_MigrationStep_ID(migrationStepId);
                                    updateMigrationData.saveEx();
                                    updateMigrationData.setUUID(data.getUuid());
                                    updateMigrationData.setIsDirectLoad(true);
                                    updateMigrationData.saveEx();
                                });
                            }
                            Trx.get((String)transactionName, (boolean)false).commit(true);
                        }
                        catch (SQLException e) {
                            logger.severe("Commit error: " + e.getLocalizedMessage());
                            isDownloaded.set(false);
                        }
                    }));
                    logger.info("nextpageToken: " + stepsResponse.getNextPageToken());
                    pageToken.set(stepsResponse.getNextPageToken());
                } while (!Util.isEmpty((String)((String)pageToken.get())));
            });
            Trx.run(updateCurrentMigrationTransactionName -> {
                if (isDownloaded.get()) {
                    try {
                        MMigration migration = new MMigration(this.getCtx(), migrationId.intValue(), updateCurrentMigrationTransactionName);
                        if (!Util.isEmpty((String)this.getOverwriteLanguage())) {
                            DB.executeUpdateEx((String)"UPDATE AD_MigrationData SET NewValue = ? WHERE EXISTS(SELECT 1 FROM AD_MigrationStep ms WHERE ms.AD_MigrationStep_ID = AD_MigrationData.AD_MigrationStep_ID AND ms.AD_Migration_ID = ?) AND EXISTS(SELECT 1 FROM AD_Language l WHERE l.AD_Language = AD_MigrationData.NewValue)", (Object[])new Object[]{this.getOverwriteLanguage(), migration.getAD_Migration_ID()}, (String)updateCurrentMigrationTransactionName);
                        }
                        if (this.isOnlyAutomaticUpdate()) {
                            migration.setStatusCode("U");
                        } else {
                            migration.setStatusCode("R");
                        }
                        migration.saveEx(updateCurrentMigrationTransactionName);
                        Trx.get((String)updateCurrentMigrationTransactionName, (boolean)false).commit(true);
                    }
                    catch (Exception e) {
                        logger.severe("Migratin Commit error: " + e.getLocalizedMessage());
                        try {
                            MMigration migration = new MMigration(this.getCtx(), migrationId.intValue(), updateCurrentMigrationTransactionName);
                            migration.setStatusCode("W");
                            migration.saveEx(updateCurrentMigrationTransactionName);
                            Trx.get((String)updateCurrentMigrationTransactionName, (boolean)false).commit(true);
                        }
                        catch (Exception re) {
                            logger.severe("Migratin Rollback error: " + re.getLocalizedMessage());
                        }
                    }
                }
                this.migrationsUpdated.getAndIncrement();
            });
        });
        long end = System.currentTimeMillis();
        return "@AD_Migration_ID@ @Updated@: " + this.migrationsUpdated + "(" + this.stepsCreated + ") - @WaitingTime@: " + TimeUtil.formatElapsed((long)(end - start));
    }
}

