/*
 * Decompiled with CFR 0.152.
 */
package org.spin.update.process;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.base.util.UpdateManager;
import org.spin.client.UpdaterClient;
import org.spin.grpc.util.ListPackagesResponse;
import org.spin.update.model.MTEntityType;
import org.spin.update.model.MTModification;
import org.spin.update.model.X_T_Modification;
import org.spin.update.process.CheckAvailablePackagesAbstract;
import org.spin.update.util.UpdaterService;

public class CheckAvailablePackages
extends CheckAvailablePackagesAbstract {
    private static final Logger logger = Logger.getLogger(UpdaterClient.class.getName());

    protected String doIt() throws Exception {
        ListPackagesResponse packageResponse;
        long start = System.currentTimeMillis();
        AtomicInteger created = new AtomicInteger(0);
        String pageToken = null;
        new Query(this.getCtx(), "T_EntityType", null, this.get_TrxName()).setClient_ID().getIDsAsList().forEach(packageId -> {
            MTEntityType tempEntityType = new MTEntityType(this.getCtx(), (int)packageId, this.get_TrxName());
            new Query(this.getCtx(), "T_Modification", "EntityType = ?", this.get_TrxName()).setParameters(new Object[]{tempEntityType.getEntityType()}).setClient_ID().getIDsAsList().forEach(modificationId -> {
                X_T_Modification tempModification = new X_T_Modification(this.getCtx(), (int)modificationId, this.get_TrxName());
                tempModification.deleteEx(true);
            });
            tempEntityType.deleteEx(true);
        });
        do {
            logger.info("####################### Packages #####################");
            packageResponse = UpdateManager.newInstance().withHost(UpdaterService.getHost()).withPort(UpdaterService.getPort()).withToken(UpdaterService.getToken()).listAvailablePackages("", "2020-12-01", pageToken);
            packageResponse.getPackagesList().forEach(packageValue -> {
                logger.info("Package: " + packageValue);
                MTEntityType entityForUpdate = new MTEntityType(Env.getCtx(), 0, this.get_TrxName());
                entityForUpdate.setEntityType(packageValue.getEntityType());
                entityForUpdate.setModelPackage(packageValue.getModelPackage());
                entityForUpdate.setName(packageValue.getName());
                entityForUpdate.setDescription(packageValue.getDescription());
                entityForUpdate.setHelp(packageValue.getHelp());
                entityForUpdate.saveEx();
                entityForUpdate.setIsDirectLoad(true);
                entityForUpdate.saveEx();
                entityForUpdate.setUUID(packageValue.getUuid());
                packageValue.getVersionsList().forEach(packageVersion -> {
                    MTModification modification = new MTModification(this.getCtx(), 0, this.get_TrxName());
                    modification.setEntityType(packageValue.getEntityType());
                    modification.setSeqNo(packageVersion.getSequence());
                    modification.setVersion(packageVersion.getVersion());
                    modification.setReleaseMainVersion(packageVersion.getMainVersion());
                    modification.setName(packageVersion.getName());
                    modification.setDescription(packageVersion.getDescription());
                    modification.setHelp(packageVersion.getHelp());
                    modification.saveEx();
                });
                created.getAndIncrement();
            });
            logger.info("nextpageToken: " + packageResponse.getNextPageToken());
        } while (!Util.isEmpty((String)(pageToken = packageResponse.getNextPageToken())));
        long end = System.currentTimeMillis();
        return "@AD_Migration_ID@ @Created@: " + created + " - @WaitingTime@: " + TimeUtil.formatElapsed((long)(end - start));
    }
}

