/*
 * Decompiled with CFR 0.152.
 */
package org.spin.update.process;

import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MEntityType;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Modification;
import org.compiere.util.Env;
import org.spin.update.process.ChangeVersionAbstract;

public class ChangeVersion
extends ChangeVersionAbstract {
    private AtomicInteger updated = new AtomicInteger();

    protected String doIt() throws Exception {
        new Query(this.getCtx(), "AD_Modification", "ReleaseMainVersion = ?", this.get_TrxName()).setParameters(new Object[]{this.getReleaseMainVersion()}).setOnlyActiveRecords(true).getIDsAsList().forEach(modificationId -> {
            X_AD_Modification modification = new X_AD_Modification(this.getCtx(), modificationId.intValue(), this.get_TrxName());
            MEntityType entityType = this.getEntityTypeFromCode(modification.getEntityType());
            if (entityType != null) {
                entityType.setVersion(modification.getVersion());
                entityType.saveEx();
                this.addLog("@EntityType@: (" + entityType.getEntityType() + " - " + entityType.getName() + "), @Version@: (" + modification.get_ValueAsString("ReleaseMainVersion") + ": " + modification.getVersion() + " - " + modification.getName() + ")");
                this.updated.incrementAndGet();
            }
        });
        return "@Updated@: " + this.updated.get();
    }

    private MEntityType getEntityTypeFromCode(String entityType) {
        return (MEntityType)new Query(Env.getCtx(), "AD_EntityType", "EntityType = ?", this.get_TrxName()).setParameters(new Object[]{entityType}).first();
    }
}

