/*
 * Decompiled with CFR 0.152.
 */
package org.spin.update.process;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.compiere.model.I_AD_Migration;
import org.compiere.model.MMigration;
import org.compiere.model.Query;
import org.compiere.process.MigrationApply;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.client.UpdaterClient;
import org.spin.update.process.ApplyUpdatesAbstract;

public class ApplyUpdates
extends ApplyUpdatesAbstract {
    private static final Logger logger = Logger.getLogger(UpdaterClient.class.getName());
    private AtomicInteger applied = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();

    protected String doIt() throws Exception {
        long start = System.currentTimeMillis();
        StringBuffer whereClause = new StringBuffer("StatusCode = ?");
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("U");
        if (this.isOnlyAutomaticUpdate()) {
            whereClause.append(" AND EXISTS(SELECT 1 FROM AD_EntityType et WHERE et.EntityType = AD_Migration.EntityType AND et.IsAutomaticUpdate = 'Y')");
        } else if (!Util.isEmpty((String)this.getEntityType())) {
            whereClause.append(" AND ").append("EntityType").append(" = ?");
            parameters.add(this.getEntityType());
        }
        new Query(Env.getCtx(), "AD_Migration", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("SeqNo").getIDsAsList().forEach(migrationId -> {
            try {
                ProcessInfo info = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(MigrationApply.getProcessId())).withoutTransactionClose().withRecordId(Integer.valueOf(I_AD_Migration.Table_ID), migrationId).withParameter("IsForce", (Object)true).execute(this.get_TrxName());
                this.applied.incrementAndGet();
                logger.info("Migration = " + info.getSummary());
            }
            catch (Exception e) {
                this.errors.incrementAndGet();
                MMigration migration = new MMigration(this.getCtx(), migrationId.intValue(), this.get_TrxName());
                this.addLog("@AD_Migration_ID@ @Failed@: " + migration.getSeqNo() + " - " + migration.getName() + " " + e.getLocalizedMessage());
                this.log.severe("Apply error: " + e.getLocalizedMessage());
            }
        });
        long end = System.currentTimeMillis();
        return "@AD_Migration_ID@ @Updated@: " + this.applied + " @Errors@ " + this.errors + " - @WaitingTime@: " + TimeUtil.formatElapsed((long)(end - start));
    }
}

