/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support.fp;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Util;

public class FiscalSetup {
    private SetupType setupType;
    private String firmwareVersion;

    public FiscalSetup(String command) {
        if (Util.isEmpty((String)command)) {
            throw new AdempiereException("@FiscalCommandType@ @NotFound@");
        }
        if (command.equals("CP")) {
            this.withSetupType(SetupType.CUT_PAPER);
        } else if (command.equals("GS")) {
            this.withSetupType(SetupType.GET_STATUS);
        } else if (command.equals("OP")) {
            this.withSetupType(SetupType.OPEN_DRAWER);
        } else if (command.equals("RP")) {
            this.withSetupType(SetupType.RESET_PRINTER);
        } else if (command.equals("SC")) {
            this.withSetupType(SetupType.SETUP);
        } else if (command.equals("TC")) {
            this.withSetupType(SetupType.SET_TIME);
        } else if (command.equals("RI")) {
            this.withSetupType(SetupType.REVERSE_INVOICE);
        } else if (command.equals("RC")) {
            this.withSetupType(SetupType.REVERSE_CREDIT_MEMO);
        } else if (command.equals("RD")) {
            this.withSetupType(SetupType.REVERSE_DEBIT_MEMO);
        } else if (command.equals("FI")) {
            this.withSetupType(SetupType.FIRMWARE_INFORMATION);
        } else if (command.equals("MS")) {
            this.withSetupType(SetupType.MEMORY_STATUS);
        } else if (command.equals("FS")) {
            this.withSetupType(SetupType.FIRMWARE_SET_VALUES);
        }
    }

    public final SetupType getSetupType() {
        return this.setupType;
    }

    public final FiscalSetup withSetupType(SetupType setupType) {
        this.setupType = setupType;
        return this;
    }

    public final String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public FiscalSetup withFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
        return this;
    }

    public static enum SetupType {
        CUT_PAPER,
        GET_STATUS,
        OPEN_DRAWER,
        RESET_PRINTER,
        SETUP,
        SET_TIME,
        REVERSE_INVOICE,
        REVERSE_CREDIT_MEMO,
        REVERSE_DEBIT_MEMO,
        FIRMWARE_INFORMATION,
        FIRMWARE_SET_VALUES,
        MEMORY_STATUS;

    }
}

