/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support.fp;

import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Util;

public class FiscalReport {
    private ReportType reportType;
    private ReportType historicReportType;
    private Timestamp reportDateFrom;
    private Timestamp reportDateTo;
    private int reportNumberFrom;
    private int reportNumberTo;
    private String taxId;

    public FiscalReport(String command) {
        if (Util.isEmpty((String)command)) {
            throw new AdempiereException("@FiscalCommandType@ @NotFound@");
        }
        if (command.equals("XR")) {
            this.withReportType(ReportType.REPORT_X);
        } else if (command.equals("ZR")) {
            this.withReportType(ReportType.REPORT_Z);
        } else if (command.equals("ZD")) {
            this.withReportType(ReportType.REPORT_Z_DATE_RANGE);
        } else if (command.equals("ZN")) {
            this.withReportType(ReportType.REPORT_Z_NUMBER_RANGE);
        } else if (command.equals("IN")) {
            this.withReportType(ReportType.REPRINT_INVOICE_NUMBER_RANGE);
        } else if (command.equals("ID")) {
            this.withReportType(ReportType.REPRINT_INVOICE_DATE_RANGE);
        } else if (command.equals("CN")) {
            this.withReportType(ReportType.REPRINT_CREDIT_MEMO_NUMBER_RANGE);
        } else if (command.equals("CD")) {
            this.withReportType(ReportType.REPRINT_CREDIT_MEMO_DATE_RANGE);
        } else if (command.equals("DN")) {
            this.withReportType(ReportType.REPRINT_DEBIT_MEMO_NUMBER_RANGE);
        } else if (command.equals("DD")) {
            this.withReportType(ReportType.REPRINT_DEBIT_MEMO_DATE_RANGE);
        } else if (command.equals("TR")) {
            this.withReportType(ReportType.REPRINT_DOCUMENT_TAX_ID);
        } else {
            throw new AdempiereException("@FiscalCommandType@ @NotFound@");
        }
    }

    public final ReportType getReportType() {
        return this.reportType;
    }

    public final FiscalReport withReportType(ReportType reportType) {
        this.reportType = reportType;
        return this;
    }

    public final ReportType getHistoricReportType() {
        return this.historicReportType;
    }

    public final FiscalReport withHistoricReportType(ReportType historicReportType) {
        this.historicReportType = historicReportType;
        return this;
    }

    public final Timestamp getReportDateFrom() {
        return this.reportDateFrom;
    }

    public final FiscalReport withReportDateFrom(Timestamp reportDateFrom) {
        this.reportDateFrom = reportDateFrom;
        return this;
    }

    public final Timestamp getReportDateTo() {
        return this.reportDateTo;
    }

    public final FiscalReport withReportDateTo(Timestamp reportDateTo) {
        this.reportDateTo = reportDateTo;
        return this;
    }

    public final int getReportNumberFrom() {
        return this.reportNumberFrom;
    }

    public final FiscalReport withReportNumberFrom(int reportNumberFrom) {
        this.reportNumberFrom = reportNumberFrom;
        return this;
    }

    public final int getReportNumberTo() {
        return this.reportNumberTo;
    }

    public final FiscalReport withReportNumberTo(int zReportNumberTo) {
        this.reportNumberTo = zReportNumberTo;
        return this;
    }

    public final String getTaxId() {
        return this.taxId;
    }

    public final FiscalReport withTaxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    public static enum ReportType {
        REPORT_X,
        REPORT_Z,
        REPORT_Z_DATE_RANGE,
        REPORT_Z_NUMBER_RANGE,
        REPRINT_INVOICE_DATE_RANGE,
        REPRINT_INVOICE_NUMBER_RANGE,
        REPRINT_CREDIT_MEMO_DATE_RANGE,
        REPRINT_CREDIT_MEMO_NUMBER_RANGE,
        REPRINT_DEBIT_MEMO_DATE_RANGE,
        REPRINT_DEBIT_MEMO_NUMBER_RANGE,
        REPRINT_DOCUMENT_TAX_ID,
        DETAILED,
        SUMMARIZED,
        MONTHLY;

    }
}

