/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support.fp;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MTax;

public class FiscalDocumentTax {
    private String taxValue = null;
    private String taxName = null;
    private BigDecimal taxRate = null;
    private BigDecimal taxAmount = null;
    private BigDecimal taxBaseAmount = null;

    public FiscalDocumentTax(MInvoiceTax documentTax) {
        if (documentTax == null) {
            throw new AdempiereException("@C_InvoiceTax_ID@ @NotFound@");
        }
        this.convertDocument(documentTax);
    }

    private void convertDocument(MInvoiceTax documentTax) {
        MTax tax = MTax.get((Properties)documentTax.getCtx(), (int)documentTax.getC_Tax_ID());
        this.withTaxValue(tax.getTaxIndicator()).withTaxName(tax.getName()).withTaxRate(tax.getRate()).withTaxBaseAmount(documentTax.getTaxBaseAmt()).withTaxAmount(documentTax.getTaxAmt());
    }

    public final String getTaxValue() {
        return this.taxValue;
    }

    public final FiscalDocumentTax withTaxValue(String taxValue) {
        this.taxValue = taxValue;
        return this;
    }

    public final String getTaxName() {
        return this.taxName;
    }

    public final FiscalDocumentTax withTaxName(String taxName) {
        this.taxName = taxName;
        return this;
    }

    public final BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public final FiscalDocumentTax withTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    public final BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public final FiscalDocumentTax withTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    public final BigDecimal getTaxBaseAmount() {
        return this.taxBaseAmount;
    }

    public final FiscalDocumentTax withTaxBaseAmount(BigDecimal taxBaseAmount) {
        this.taxBaseAmount = taxBaseAmount;
        return this;
    }

    public String toString() {
        return "FiscalDocumentTax [taxValue=" + this.taxValue + ", taxName=" + this.taxName + ", taxRate=" + this.taxRate + ", taxAmount=" + this.taxAmount + ", taxBaseAmount=" + this.taxBaseAmount + "]";
    }
}

