/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support.fp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.model.MRefList;
import org.compiere.util.Env;
import org.spin.model.MCPaymentMethod;

public class FiscalDocumentPayment {
    private String referenceNo = null;
    private String description = null;
    private String tenderType = null;
    private String tenderTypeName = null;
    private String paymentMethodValue = null;
    private String paymentMethodName = null;
    private String currencyCode = null;
    private BigDecimal amount = null;
    private BigDecimal convertedAmount = null;
    private Timestamp paymentDate = null;

    public FiscalDocumentPayment(MPayment documentPayment) {
        if (documentPayment == null) {
            throw new AdempiereException("@C_Payment_ID@ @NotFound@");
        }
        this.convertDocument(documentPayment);
    }

    public FiscalDocumentPayment() {
    }

    private void convertDocument(MPayment document) {
        String tenderTypeName = MRefList.getListName((Properties)document.getCtx(), (int)214, (String)document.getTenderType());
        MOrg organization = MOrg.get((Properties)document.getCtx(), (int)document.getAD_Org_ID());
        MOrgInfo organizationInfo = MOrgInfo.get((Properties)document.getCtx(), (int)document.getAD_Org_ID(), (String)document.get_TrxName());
        int currencyId = organizationInfo.get_ValueAsInt("LVE_FiscalCurrency_ID");
        if (currencyId <= 0) {
            throw new AdempiereException("@LVE_FiscalCurrency_ID@ @NotFound@: @AD_Org_ID@ " + organization.getName());
        }
        BigDecimal convertedAmount = document.getPayAmt(true);
        if (currencyId != document.getC_Currency_ID()) {
            BigDecimal conversionRate = Optional.ofNullable(MConversionRate.getRate((int)document.getC_Currency_ID(), (int)currencyId, (Timestamp)document.getDateTrx(), (int)document.getC_ConversionType_ID(), (int)document.getAD_Client_ID(), (int)document.getAD_Org_ID())).orElse(Env.ZERO);
            MCurrency currencyTo = MCurrency.get((Properties)document.getCtx(), (int)currencyId);
            convertedAmount = convertedAmount.multiply(conversionRate).setScale(currencyTo.getStdPrecision(), 4);
        }
        this.withAmount(document.getPayAmt(true)).withConvertedAmount(convertedAmount).withTenderType(document.getTenderType()).withTenderTypeName(tenderTypeName).withDescription(document.getDescription()).withPaymentDate(document.getDateTrx()).withReferenceNo(document.getDocumentNo()).withCurrencyCode(MCurrency.getISO_Code((Properties)document.getCtx(), (int)document.getC_Currency_ID()));
        if (document.get_ValueAsInt("C_PaymentMethod_ID") > 0) {
            MCPaymentMethod paymentMethod = MCPaymentMethod.getById((Properties)document.getCtx(), (int)document.get_ValueAsInt("C_PaymentMethod_ID"), (String)document.get_TrxName());
            this.withPaymentMethodValue(paymentMethod.getValue()).withPaymentMethodName(paymentMethod.getName());
        }
    }

    public final String getReferenceNo() {
        return this.referenceNo;
    }

    public final FiscalDocumentPayment withReferenceNo(String referenceNo) {
        this.referenceNo = referenceNo;
        return this;
    }

    public final String getDescription() {
        return this.description;
    }

    public final FiscalDocumentPayment withDescription(String description) {
        this.description = description;
        return this;
    }

    public final String getCurrencyCode() {
        return this.currencyCode;
    }

    public final FiscalDocumentPayment withCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public final BigDecimal getAmount() {
        return this.amount;
    }

    public final FiscalDocumentPayment withAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public final Timestamp getPaymentDate() {
        return this.paymentDate;
    }

    public final FiscalDocumentPayment withPaymentDate(Timestamp paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    public final String getTenderTypeName() {
        return this.tenderTypeName;
    }

    public final FiscalDocumentPayment withTenderTypeName(String tenderTypeName) {
        this.tenderTypeName = tenderTypeName;
        return this;
    }

    public final BigDecimal getConvertedAmount() {
        return this.convertedAmount;
    }

    public final FiscalDocumentPayment withConvertedAmount(BigDecimal convertedAmount) {
        this.convertedAmount = convertedAmount;
        return this;
    }

    public final String getTenderType() {
        return this.tenderType;
    }

    public final FiscalDocumentPayment withTenderType(String tenderType) {
        this.tenderType = tenderType;
        return this;
    }

    public final String getPaymentMethodValue() {
        return this.paymentMethodValue;
    }

    public final FiscalDocumentPayment withPaymentMethodValue(String paymentMethodValue) {
        this.paymentMethodValue = paymentMethodValue;
        return this;
    }

    public final String getPaymentMethodName() {
        return this.paymentMethodName;
    }

    public final FiscalDocumentPayment withPaymentMethodName(String paymentMethodName) {
        this.paymentMethodName = paymentMethodName;
        return this;
    }

    public String toString() {
        return "FiscalDocumentPayment [referenceNo=" + this.referenceNo + ", description=" + this.description + ", currencyCode=" + this.currencyCode + ", amount=" + this.amount + ", paymentDate=" + this.paymentDate + "]";
    }
}

