/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support.fp;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocation;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.model.X_C_Tax;
import org.compiere.util.Env;

public class FiscalDocumentLine {
    private String documentLineUuid = null;
    private String productValue = null;
    private String productName = null;
    private String productDescription = null;
    private String productBarCode = null;
    private String lineDescription = null;
    private BigDecimal quantity = null;
    private BigDecimal productPriceList = null;
    private BigDecimal productPrice = null;
    private BigDecimal taxRate = null;
    private BigDecimal discount = null;
    private BigDecimal conversionRate = null;
    private MCurrency organizationCurrency = null;
    private MInvoice invoice = null;

    public FiscalDocumentLine(MInvoiceLine documentLine) {
        if (documentLine == null) {
            throw new AdempiereException("@C_InvoiceLine_ID@ @NotFound@");
        }
        this.convertDocument(documentLine);
    }

    private void convertDocument(MInvoiceLine documentLine) {
        int taxCategoryId;
        this.loadOrganizationCurrency(documentLine.getParent());
        String productValue = null;
        String productName = null;
        String productDescription = null;
        String productBarcode = null;
        BigDecimal taxRate = Env.ZERO;
        BigDecimal discount = Env.ZERO;
        MProduct product = null;
        MCharge charge = null;
        if (documentLine.getM_Product_ID() != 0) {
            product = MProduct.get((Properties)documentLine.getCtx(), (int)documentLine.getM_Product_ID());
            productValue = product.getValue();
            productName = product.getName();
            productDescription = product.getDescription();
            productBarcode = product.getUPC();
        } else if (documentLine.getC_Charge_ID() != 0) {
            charge = MCharge.get((Properties)documentLine.getCtx(), (int)documentLine.getC_Charge_ID());
            productName = charge.getName();
            productDescription = charge.getDescription();
        }
        int n = product != null ? product.getC_TaxCategory_ID() : (taxCategoryId = charge != null ? charge.getC_TaxCategory_ID() : 0);
        if (documentLine.getC_Tax_ID() != 0) {
            taxRate = MTax.get((Properties)documentLine.getCtx(), (int)documentLine.getC_Tax_ID()).getRate();
        } else {
            Optional<MTax> optionalTax = Arrays.asList(MTax.getAll((Properties)documentLine.getCtx())).stream().filter(tax -> tax.getC_TaxCategory_ID() == taxCategoryId).sorted(Comparator.comparing(X_C_Tax::isDefault).reversed()).findFirst();
            if (!optionalTax.isPresent()) {
                throw new AdempiereException("@C_Tax_ID@ @NotFound@: " + documentLine);
            }
            taxRate = optionalTax.get().getRate();
        }
        BigDecimal priceActual = Optional.ofNullable(documentLine.getPriceActual()).orElse(Env.ZERO);
        BigDecimal priceList = Optional.ofNullable(documentLine.getPriceList()).orElse(Env.ZERO);
        if (priceActual.compareTo(Env.ZERO) > 0 && priceList.compareTo(Env.ZERO) > 0) {
            discount = documentLine.getPriceList().subtract(documentLine.getPriceActual());
            discount = discount.divide(documentLine.getPriceList(), MathContext.DECIMAL128);
            discount = discount.multiply(Env.ONEHUNDRED);
        }
        this.withDocumentLineUuid(documentLine.getUUID()).withProductValue(productValue).withProductName(productName).withProductDescription(productDescription).withProductBarCode(productBarcode).withProductPrice(this.getConvetedAmount(documentLine.getPriceActual())).withProductPriceList(this.getConvetedAmount(documentLine.getPriceList())).withLineDescription(documentLine.getDescription()).withQuantity(documentLine.getQtyInvoiced()).withTaxRate(taxRate).withDiscount(discount);
    }

    private void loadOrganizationCurrency(MInvoice document) {
        this.invoice = document;
        MOrgInfo organizationInfo = MOrgInfo.get((Properties)document.getCtx(), (int)document.getAD_Org_ID(), (String)document.get_TrxName());
        MLocation location = MLocation.get((Properties)document.getCtx(), (int)organizationInfo.getC_Location_ID(), (String)document.get_TrxName());
        MCountry organizationCountry = MCountry.get((Properties)document.getCtx(), (int)location.getC_Country_ID());
        this.organizationCurrency = MCurrency.get((Properties)document.getCtx(), (int)organizationCountry.getC_Currency_ID());
    }

    private BigDecimal getConvetedAmount(BigDecimal amount) {
        if (this.invoice.getC_Currency_ID() == this.organizationCurrency.getC_Currency_ID() || amount == null || amount.compareTo(Env.ZERO) == 0) {
            return amount;
        }
        if (Optional.ofNullable(this.conversionRate).orElse(Env.ZERO).compareTo(Env.ZERO) <= 0) {
            this.conversionRate = MConversionRate.getRate((int)this.invoice.getC_Currency_ID(), (int)this.organizationCurrency.getC_Currency_ID(), (Timestamp)this.invoice.getDateAcct(), (int)this.invoice.getC_ConversionType_ID(), (int)this.invoice.getAD_Client_ID(), (int)this.invoice.getAD_Org_ID());
            if (this.conversionRate == null || this.conversionRate.compareTo(Env.ZERO) == 0) {
                throw new AdempiereException(MConversionRate.getErrorMessage((Properties)this.invoice.getCtx(), (String)"ErrorConvertingDocumentCurrencyToBaseCurrency", (int)this.invoice.getC_Currency_ID(), (int)this.organizationCurrency.getC_Currency_ID(), (int)this.invoice.getC_ConversionType_ID(), (Timestamp)this.invoice.getDateAcct(), (String)this.invoice.get_TrxName()));
            }
        }
        return amount.multiply(this.conversionRate).setScale(this.organizationCurrency.getStdPrecision(), 4);
    }

    public final FiscalDocumentLine withDocumentLineUuid(String documentLineUuid) {
        this.documentLineUuid = documentLineUuid;
        return this;
    }

    public final FiscalDocumentLine withProductValue(String productValue) {
        this.productValue = productValue;
        return this;
    }

    public final FiscalDocumentLine withProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public final FiscalDocumentLine withProductDescription(String productDescription) {
        this.productDescription = productDescription;
        return this;
    }

    public final FiscalDocumentLine withProductBarCode(String productBarCode) {
        this.productBarCode = productBarCode;
        return this;
    }

    public final FiscalDocumentLine withLineDescription(String lineDescription) {
        this.lineDescription = lineDescription;
        return this;
    }

    public final FiscalDocumentLine withQuantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    public final FiscalDocumentLine withProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
        return this;
    }

    public final FiscalDocumentLine withProductPriceList(BigDecimal productPriceList) {
        this.productPriceList = productPriceList;
        return this;
    }

    public final FiscalDocumentLine withTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    public final FiscalDocumentLine withDiscount(BigDecimal discount) {
        this.discount = discount;
        return this;
    }

    public final String getdocumentLineUuid() {
        return this.documentLineUuid;
    }

    public final String getProductValue() {
        return this.productValue;
    }

    public final String getProductName() {
        return this.productName;
    }

    public final String getProductDescription() {
        return this.productDescription;
    }

    public final String getProductBarCode() {
        return this.productBarCode;
    }

    public final String getLineDescription() {
        return this.lineDescription;
    }

    public final BigDecimal getQuantity() {
        return this.quantity;
    }

    public final BigDecimal getProductPriceList() {
        return this.productPriceList;
    }

    public final BigDecimal getProductPrice() {
        return this.productPrice;
    }

    public final BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public final BigDecimal getDiscount() {
        return this.discount;
    }

    static enum DocumentType {
        INVOICE,
        CREDIT_MEMO,
        DEBIT_MEMO;

    }
}

