/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support.fp;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MProduct;
import org.compiere.model.MRefList;
import org.compiere.model.MRegion;
import org.compiere.model.MSalesRegion;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.support.fp.FiscalDocumentLine;
import org.spin.support.fp.FiscalDocumentPayment;
import org.spin.support.fp.FiscalDocumentTax;

public class FiscalDocument {
    private DocumentType documentType;
    private String documentUuid = null;
    private String documentNo = null;
    private Timestamp documentDate = null;
    private String businessPartnerName = null;
    private String businessPartnerTaxId = null;
    private String businessPartnerDuns = null;
    private String address1 = null;
    private String address2 = null;
    private String address3 = null;
    private String address4 = null;
    private String cityName = null;
    private String regionName = null;
    private String countryName = null;
    private String description = null;
    private String documentNote = null;
    private String reversalDocumentNo = null;
    private Timestamp reversalDocumentDate = null;
    private String reversalFiscalPrinterNo = null;
    private String poReferenceNo = null;
    private String soReferenceNo = null;
    private String salesRepresentativeValue = null;
    private String salesRepresentativeName = null;
    private String paymentTerm = null;
    private String salesRegionValue = null;
    private String salesRegionName = null;
    private BigDecimal totalLines = null;
    private BigDecimal grandTotal = null;
    private String amountInWords = null;
    private String documentTypeName = null;
    private String deliveryAddress = null;
    private String deliveryPhone = null;
    private String warehouseName = null;
    private int productQuantities = 0;
    private String posName = null;
    private boolean discountPrinted = false;
    private BigDecimal conversionRate = null;
    private MCurrency organizationCurrency = null;
    private MInvoice invoice;
    List<FiscalDocumentLine> fiscalDocumentLines;
    List<FiscalDocumentTax> fiscalDocumentTaxes;
    List<FiscalDocumentPayment> fiscalDocumentPayments;
    private SetupType setupType;

    public FiscalDocument(MInvoice document) {
        if (document == null) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
        this.convertDocument(document);
    }

    private void loadOrganizationCurrency(MInvoice document) {
        this.invoice = document;
        MOrg organization = MOrg.get((Properties)document.getCtx(), (int)document.getAD_Org_ID());
        MOrgInfo organizationInfo = MOrgInfo.get((Properties)document.getCtx(), (int)document.getAD_Org_ID(), (String)document.get_TrxName());
        int currencyId = organizationInfo.get_ValueAsInt("LVE_FiscalCurrency_ID");
        if (currencyId <= 0) {
            throw new AdempiereException("@LVE_FiscalCurrency_ID@ @NotFound@: @AD_Org_ID@ " + organization.getName());
        }
        this.organizationCurrency = MCurrency.get((Properties)document.getCtx(), (int)currencyId);
    }

    private void convertDocument(MInvoice document) {
        String amountInWords;
        MPOS pos;
        this.fiscalDocumentLines = new ArrayList<FiscalDocumentLine>();
        this.fiscalDocumentTaxes = new ArrayList<FiscalDocumentTax>();
        this.fiscalDocumentPayments = new ArrayList<FiscalDocumentPayment>();
        this.loadOrganizationCurrency(document);
        MDocType documentType = MDocType.get((Properties)document.getCtx(), (int)document.getC_DocType_ID());
        if (Util.isEmpty((String)documentType.get_ValueAsString("FiscalDocumentType"))) {
            throw new AdempiereException("@FiscalDocumentType@ @NotFound@");
        }
        if (documentType.get_ValueAsString("FiscalDocumentType").equals("01")) {
            this.withDocumentType(DocumentType.INVOICE);
        } else if (documentType.get_ValueAsString("FiscalDocumentType").equals("02")) {
            this.withDocumentType(DocumentType.DEBIT_MEMO);
        } else if (documentType.get_ValueAsString("FiscalDocumentType").equals("03")) {
            MInvoice allocatedDocument;
            this.withDocumentType(DocumentType.CREDIT_MEMO);
            int invoiceToAllocateId = document.get_ValueAsInt("InvoiceToAllocate_ID");
            if (invoiceToAllocateId == 0) {
                invoiceToAllocateId = Arrays.asList(document.getLines()).stream().filter(documentLine -> documentLine.get_ValueAsInt("InvoiceToAllocate_ID") != 0).findFirst().orElseThrow(() -> new AdempiereException("@InvoiceToAllocate_ID@ @NotFound@")).get_ValueAsInt("InvoiceToAllocate_ID");
            }
            if (Util.isEmpty((String)(allocatedDocument = new MInvoice(document.getCtx(), invoiceToAllocateId, document.get_TrxName())).get_ValueAsString("FiscalDocumentNo"))) {
                throw new AdempiereException("@FiscalDocumentNo@ @NotFound@");
            }
            if (allocatedDocument.get_ValueAsInt("FiscalPrinter_ID") == 0) {
                throw new AdempiereException("@FiscalPrinter_ID@ @NotFound@");
            }
            this.withReversalDocumentNo(allocatedDocument.get_ValueAsString("FiscalDocumentNo"));
            this.withReversalDocumentDate(TimeUtil.getDayTime((Timestamp)allocatedDocument.getDateInvoiced(), (Timestamp)allocatedDocument.getUpdated()));
            this.withReversalFiscalPrinterNo(MADAppRegistration.getById((Properties)document.getCtx(), (int)allocatedDocument.get_ValueAsInt("FiscalPrinter_ID"), (String)document.get_TrxName()).getValue());
        }
        MBPartner businessPartner = (MBPartner)document.getC_BPartner();
        MBPartnerLocation businessPartnerLocation = (MBPartnerLocation)document.getC_BPartner_Location();
        MLocation location = (MLocation)businessPartnerLocation.getC_Location();
        MCountry country = MCountry.get((Properties)document.getCtx(), (int)location.getC_Country_ID());
        MRegion region = MRegion.get((Properties)document.getCtx(), (int)location.getC_Region_ID());
        String cityName = location.getCity();
        if (Util.isEmpty((String)cityName) && location.getC_City_ID() != 0) {
            MCity city = MCity.get((Properties)document.getCtx(), (int)location.getC_City_ID());
            cityName = city.getName();
        }
        String sOReference = null;
        if (document.getC_Order_ID() != 0) {
            sOReference = document.getC_Order().getDocumentNo();
        }
        if (document.getC_POS_ID() > 0 && (pos = MPOS.get((Properties)document.getCtx(), (int)document.getC_POS_ID())) != null) {
            this.withPosName(pos.getName());
        }
        this.withDocumentUuid(document.getUUID()).withDocumentNo(document.getDocumentNo()).withDocumentDate(document.getDateInvoiced()).withBusinessPartnerName(businessPartner.getName() + (!Util.isEmpty((String)businessPartner.getName2()) ? " " + businessPartner.getName2() : "")).withBusinessPartnerTaxId(!Util.isEmpty((String)businessPartner.getTaxID()) ? businessPartner.getTaxID() : businessPartner.getValue()).withBusinessPartnerDuns(businessPartner.getDUNS()).withAddress1(location.getAddress1()).withAddress2(location.getAddress2()).withAddress3(location.getAddress3()).withAddress4(location.getAddress4()).withCityName(cityName).withRegionName(region.getName()).withCountryName(country.getName()).withDescription(document.getDescription()).withDocumentNote(documentType.getDocumentNote()).withPoReferenceNo(document.getPOReference()).withSoReferenceNo(sOReference).withDocumentTypeName(documentType.getPrintName()).withTotalLines(this.getConvetedAmount(document.getTotalLines())).withGrandTotal(this.getConvetedAmount(document.getGrandTotal())).withDiscountPrinted(document.isDiscountPrinted());
        if (document.getSalesRep_ID() != 0) {
            MUser salesRepresentative = MUser.get((Properties)document.getCtx(), (int)document.getSalesRep_ID());
            this.withSalesRegionValue(salesRepresentative.getValue()).withSalesRegionName(salesRepresentative.getName());
        }
        if (document.getC_SalesRegion_ID() != 0) {
            MSalesRegion salesRegion = MSalesRegion.getById((Properties)document.getCtx(), (int)document.getC_SalesRegion_ID(), (String)document.get_TrxName());
            this.withSalesRegionValue(salesRegion.getValue()).withSalesRegionName(salesRegion.getName());
        }
        if (document.getC_PaymentTerm_ID() != 0) {
            MPaymentTerm paymentTerm = (MPaymentTerm)document.getC_PaymentTerm();
            this.withPaymentTerm(paymentTerm.getName());
        }
        if (document.getC_Order_ID() != 0) {
            MOrder salesOrder = (MOrder)document.getC_Order();
            MWarehouse warehouse = MWarehouse.get((Properties)document.getCtx(), (int)salesOrder.getM_Warehouse_ID());
            MBPartnerLocation deliveryLocation = (MBPartnerLocation)salesOrder.getC_BPartner_Location();
            this.withWarehouseName(warehouse.getName()).withDeliveryAddress(deliveryLocation.getName());
            if (!Util.isEmpty((String)deliveryLocation.getPhone())) {
                this.withDeliveryPhone(deliveryLocation.getPhone());
            } else if (!Util.isEmpty((String)deliveryLocation.getPhone2())) {
                this.withDeliveryPhone(deliveryLocation.getPhone2());
            }
        }
        if (!Util.isEmpty((String)(amountInWords = Msg.getAmtInWords((Language)Env.getLanguage((Properties)document.getCtx()), (String)DisplayType.getNumberFormat((int)12).format(document.getGrandTotal()))))) {
            this.withAmountInWords(amountInWords);
        }
        if (document.getDocStatus().equals("RE") || document.getDocStatus().equals("VO")) {
            this.withSetupType(SetupType.DOCUMENT_VOID);
        }
        AtomicInteger productQuantities = new AtomicInteger(0);
        Arrays.asList(document.getLines()).forEach(documentLine -> {
            this.fiscalDocumentLines.add(new FiscalDocumentLine((MInvoiceLine)documentLine));
            if (documentLine.getM_Product_ID() > 0) {
                MProduct product = MProduct.get((Properties)document.getCtx(), (int)documentLine.getM_Product_ID());
                int precision = MUOM.getPrecision((Properties)document.getCtx(), (int)product.getC_UOM_ID());
                if (precision == 0) {
                    productQuantities.getAndAdd(Optional.ofNullable(documentLine.getQtyInvoiced()).orElse(Env.ZERO).intValue());
                } else {
                    productQuantities.getAndIncrement();
                }
            }
        });
        this.withProductQuantities(productQuantities.get());
        Arrays.asList(document.getTaxes(true)).forEach(documentTax -> this.fiscalDocumentTaxes.add(new FiscalDocumentTax((MInvoiceTax)documentTax)));
        if (document.getC_POS_ID() > 0) {
            MOrder order = (MOrder)document.getC_Order();
            MPayment.getOfOrder((MOrder)order).forEach(payment -> this.fiscalDocumentPayments.add(new FiscalDocumentPayment((MPayment)payment)));
        } else {
            MTable withholdingTable = MTable.get((Properties)document.getCtx(), (String)"WH_Withholding");
            if (withholdingTable != null) {
                new Query(document.getCtx(), withholdingTable.getTableName(), "ECA40_IsFBTT = 'Y' AND SourceInvoice_ID = ? AND DocStatus IN('CO', 'CL')", document.get_TrxName()).setParameters(new Object[]{document.getC_Invoice_ID()}).list().forEach(withholding -> {
                    String tenderType = "M";
                    BigDecimal amount = Optional.ofNullable((BigDecimal)withholding.get_Value("A_Base_Amount")).orElse(Env.ZERO);
                    int currencyFromId = withholding.get_ValueAsInt("C_Currency_ID");
                    Timestamp documentDate = (Timestamp)withholding.get_Value("DateDoc");
                    String description = withholding.get_ValueAsString("Description");
                    String documentNo = withholding.get_ValueAsString("DocumentNo");
                    String tenderTypeName = MRefList.getListName((Properties)document.getCtx(), (int)214, (String)tenderType);
                    MOrg organization = MOrg.get((Properties)document.getCtx(), (int)document.getAD_Org_ID());
                    MOrgInfo organizationInfo = MOrgInfo.get((Properties)document.getCtx(), (int)document.getAD_Org_ID(), (String)document.get_TrxName());
                    int currencyId = organizationInfo.get_ValueAsInt("LVE_FiscalCurrency_ID");
                    if (currencyId <= 0) {
                        throw new AdempiereException("@LVE_FiscalCurrency_ID@ @NotFound@: @AD_Org_ID@ " + organization.getName());
                    }
                    BigDecimal convertedAmount = amount;
                    if (currencyId != currencyFromId) {
                        BigDecimal conversionRate = Optional.ofNullable(MConversionRate.getRate((int)currencyFromId, (int)currencyId, (Timestamp)documentDate, (int)document.getC_ConversionType_ID(), (int)document.getAD_Client_ID(), (int)document.getAD_Org_ID())).orElse(Env.ZERO);
                        MCurrency currencyTo = MCurrency.get((Properties)document.getCtx(), (int)currencyId);
                        convertedAmount = convertedAmount.multiply(conversionRate).setScale(currencyTo.getStdPrecision(), 4);
                    }
                    FiscalDocumentPayment fiscalDocumentPayment = new FiscalDocumentPayment();
                    fiscalDocumentPayment.withAmount(amount).withConvertedAmount(convertedAmount).withTenderType(tenderType).withTenderTypeName(tenderTypeName).withDescription(description).withPaymentDate(documentDate).withReferenceNo(documentNo).withCurrencyCode(MCurrency.getISO_Code((Properties)document.getCtx(), (int)currencyFromId));
                    this.fiscalDocumentPayments.add(fiscalDocumentPayment);
                });
            }
        }
    }

    private BigDecimal getConvetedAmount(BigDecimal amount) {
        if (this.invoice.getC_Currency_ID() == this.organizationCurrency.getC_Currency_ID() || amount == null || amount.compareTo(Env.ZERO) == 0) {
            return amount;
        }
        if (Optional.ofNullable(this.conversionRate).orElse(Env.ZERO).compareTo(Env.ZERO) <= 0) {
            this.conversionRate = MConversionRate.getRate((int)this.invoice.getC_Currency_ID(), (int)this.organizationCurrency.getC_Currency_ID(), (Timestamp)this.invoice.getDateAcct(), (int)this.invoice.getC_ConversionType_ID(), (int)this.invoice.getAD_Client_ID(), (int)this.invoice.getAD_Org_ID());
            if (this.conversionRate == null || this.conversionRate.compareTo(Env.ZERO) == 0) {
                throw new AdempiereException(MConversionRate.getErrorMessage((Properties)this.invoice.getCtx(), (String)"ErrorConvertingDocumentCurrencyToBaseCurrency", (int)this.invoice.getC_Currency_ID(), (int)this.organizationCurrency.getC_Currency_ID(), (int)this.invoice.getC_ConversionType_ID(), (Timestamp)this.invoice.getDateAcct(), (String)this.invoice.get_TrxName()));
            }
        }
        return amount.multiply(this.conversionRate).setScale(this.organizationCurrency.getStdPrecision(), 4);
    }

    public final SetupType getSetupType() {
        return this.setupType;
    }

    public final FiscalDocument withSetupType(SetupType setupType) {
        this.setupType = setupType;
        return this;
    }

    public final FiscalDocument withDocumentType(DocumentType documentType) {
        this.documentType = documentType;
        return this;
    }

    public final FiscalDocument withDocumentUuid(String documentUuid) {
        this.documentUuid = documentUuid;
        return this;
    }

    public final FiscalDocument withBusinessPartnerName(String businessPartnerName) {
        this.businessPartnerName = businessPartnerName;
        return this;
    }

    public final FiscalDocument withBusinessPartnerTaxId(String businessPartnerTaxId) {
        this.businessPartnerTaxId = businessPartnerTaxId;
        return this;
    }

    public final FiscalDocument withAddress1(String address1) {
        this.address1 = address1;
        return this;
    }

    public final FiscalDocument withAddress2(String address2) {
        this.address2 = address2;
        return this;
    }

    public final FiscalDocument withAddress3(String address3) {
        this.address3 = address3;
        return this;
    }

    public final FiscalDocument withAddress4(String address4) {
        this.address4 = address4;
        return this;
    }

    public final FiscalDocument withCityName(String cityName) {
        this.cityName = cityName;
        return this;
    }

    public final FiscalDocument withRegionName(String regionName) {
        this.regionName = regionName;
        return this;
    }

    public final FiscalDocument withCountryName(String countryName) {
        this.countryName = countryName;
        return this;
    }

    public final FiscalDocument withDescription(String description) {
        this.description = description;
        return this;
    }

    public final FiscalDocument withDocumentNote(String documentNote) {
        this.documentNote = documentNote;
        return this;
    }

    public final FiscalDocument withReversalDocumentNo(String reversalDocumentNo) {
        this.reversalDocumentNo = reversalDocumentNo;
        return this;
    }

    public final FiscalDocument withReversalDocumentDate(Timestamp reversalDocumentDate) {
        this.reversalDocumentDate = reversalDocumentDate;
        return this;
    }

    public final FiscalDocument withReversalFiscalPrinterNo(String reversalFiscalPrinterNo) {
        this.reversalFiscalPrinterNo = reversalFiscalPrinterNo;
        return this;
    }

    public final FiscalDocument withPoReferenceNo(String poReferenceNo) {
        this.poReferenceNo = poReferenceNo;
        return this;
    }

    public final FiscalDocument withSoReferenceNo(String soReferenceNo) {
        this.soReferenceNo = soReferenceNo;
        return this;
    }

    public final DocumentType getDocumentType() {
        return this.documentType;
    }

    public final String getDocumentUuid() {
        return this.documentUuid;
    }

    public final String getBusinessPartnerName() {
        return this.businessPartnerName;
    }

    public final String getBusinessPartnerTaxId() {
        return this.businessPartnerTaxId;
    }

    public final String getAddress1() {
        return this.address1;
    }

    public final String getAddress2() {
        return this.address2;
    }

    public final String getAddress3() {
        return this.address3;
    }

    public final String getAddress4() {
        return this.address4;
    }

    public final String getCityName() {
        return this.cityName;
    }

    public final String getRegionName() {
        return this.regionName;
    }

    public final String getCountryName() {
        return this.countryName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getDocumentNote() {
        return this.documentNote;
    }

    public final String getReversalDocumentNo() {
        return this.reversalDocumentNo;
    }

    public final Timestamp getReversalDocumentDate() {
        return this.reversalDocumentDate;
    }

    public final String getReversalFiscalPrinterNo() {
        return this.reversalFiscalPrinterNo;
    }

    public final String getPoReferenceNo() {
        return this.poReferenceNo;
    }

    public final String getSoReferenceNo() {
        return this.soReferenceNo;
    }

    public final String getSalesRepresentativeValue() {
        return this.salesRepresentativeValue;
    }

    public final FiscalDocument withSalesRepresentativeValue(String salesRepresentativeValue) {
        this.salesRepresentativeValue = salesRepresentativeValue;
        return this;
    }

    public final String getSalesRepresentativeName() {
        return this.salesRepresentativeName;
    }

    public final FiscalDocument withSalesRepresentativeName(String salesRepresentativeName) {
        this.salesRepresentativeName = salesRepresentativeName;
        return this;
    }

    public final String getPaymentTerm() {
        return this.paymentTerm;
    }

    public final FiscalDocument withPaymentTerm(String paymentTerm) {
        this.paymentTerm = paymentTerm;
        return this;
    }

    public final String getSalesRegionValue() {
        return this.salesRegionValue;
    }

    public final FiscalDocument withSalesRegionValue(String salesRegionValue) {
        this.salesRegionValue = salesRegionValue;
        return this;
    }

    public final String getSalesRegionName() {
        return this.salesRegionName;
    }

    public final FiscalDocument withSalesRegionName(String salesRegionName) {
        this.salesRegionName = salesRegionName;
        return this;
    }

    public final BigDecimal getTotalLines() {
        return this.totalLines;
    }

    public final FiscalDocument withTotalLines(BigDecimal totalLines) {
        this.totalLines = totalLines;
        return this;
    }

    public final BigDecimal getGrandTotal() {
        return this.grandTotal;
    }

    public final FiscalDocument withGrandTotal(BigDecimal grandTotal) {
        this.grandTotal = grandTotal;
        return this;
    }

    public final String getAmountInWords() {
        return this.amountInWords;
    }

    public final FiscalDocument withAmountInWords(String amountInWords) {
        this.amountInWords = amountInWords;
        return this;
    }

    public final String getDocumentTypeName() {
        return this.documentTypeName;
    }

    public final FiscalDocument withDocumentTypeName(String documentTypeName) {
        this.documentTypeName = documentTypeName;
        return this;
    }

    public final String getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public final FiscalDocument withDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    public final String getDeliveryPhone() {
        return this.deliveryPhone;
    }

    public final FiscalDocument withDeliveryPhone(String deliveryPhone) {
        this.deliveryPhone = deliveryPhone;
        return this;
    }

    public final String getWarehouseName() {
        return this.warehouseName;
    }

    public final FiscalDocument withWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
        return this;
    }

    public final List<FiscalDocumentLine> getFiscalDocumentLines() {
        return this.fiscalDocumentLines;
    }

    public final List<FiscalDocumentTax> getFiscalDocumentTaxes() {
        return this.fiscalDocumentTaxes;
    }

    public final List<FiscalDocumentPayment> getFiscalDocumentPayments() {
        return this.fiscalDocumentPayments;
    }

    public final String getDocumentNo() {
        return this.documentNo;
    }

    public final FiscalDocument withDocumentNo(String documentNo) {
        this.documentNo = documentNo;
        return this;
    }

    public final Timestamp getDocumentDate() {
        return this.documentDate;
    }

    public final FiscalDocument withDocumentDate(Timestamp documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    public final String getBusinessPartnerDuns() {
        return this.businessPartnerDuns;
    }

    public final FiscalDocument withBusinessPartnerDuns(String businessPartnerDuns) {
        this.businessPartnerDuns = businessPartnerDuns;
        return this;
    }

    public final int getProductQuantities() {
        return this.productQuantities;
    }

    public final FiscalDocument withProductQuantities(int productQuantities) {
        this.productQuantities = productQuantities;
        return this;
    }

    public final String getPosName() {
        return this.posName;
    }

    public final FiscalDocument withPosName(String posName) {
        this.posName = posName;
        return this;
    }

    public final boolean isDiscountPrinted() {
        return this.discountPrinted;
    }

    public final FiscalDocument withDiscountPrinted(boolean discountPrinted) {
        this.discountPrinted = discountPrinted;
        return this;
    }

    public String toString() {
        return "FiscalDocument [documentUuid=" + this.documentUuid + ", businessPartnerName=" + this.businessPartnerName + ", businessPartnerTaxId=" + this.businessPartnerTaxId + "]";
    }

    public static enum SetupType {
        DOCUMENT_VOID;

    }

    public static enum DocumentType {
        INVOICE,
        CREDIT_MEMO,
        DEBIT_MEMO;

    }
}

