/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.fp.util.event.PrinterEvent;
import org.spin.fp.util.event.PrinterEventListener;
import org.spin.model.MADAppRegistration;
import org.spin.model.MFPLog;
import org.spin.support.fp.FiscalDocument;
import org.spin.support.fp.FiscalDocumentResult;
import org.spin.support.fp.FiscalReport;
import org.spin.support.fp.FiscalSetup;
import org.spin.support.fp.IFiscalPrinter;
import org.spin.support.fp.IFiscalPrinterResponse;
import org.spin.support.fp.NonFiscalDocument;
import org.spin.tools.kafka.util.KafkaLoader;
import org.spin.tools.kafka.util.MapDeserializer;
import org.spin.util.text.DataUtils;

public class FiscalPrintKafkaAPI
implements IFiscalPrinter,
PrinterEventListener {
    private int registrationId = 0;
    private CLogger log = CLogger.getCLogger(FiscalPrintKafkaAPI.class);
    private int port;
    private String printerName = null;
    private String printerResponseName = null;
    private String portName = null;
    private String host = null;
    private int intents = 0;
    private final String PRINTER_NAME = "printer_name";
    private final String PRINTER_RESPONSE_NAME = "printer_response_name";
    private final String PORT_NAME = "port_name";
    private final String INTENTS = "intents";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private String applicationType = null;

    public String testConnection() {
        this.printFiscalReport(new FiscalReport("XR"));
        return "Ok";
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.applicationType = registration.getApplicationType();
        this.port = registration.getPort();
        this.host = registration.getHost();
        MOrg client = MOrg.get((Properties)Env.getCtx(), (int)registration.getAD_Org_ID());
        this.printerName = client.getValue() + "-" + registration.getValue();
        this.portName = registration.getParameterValue("port_name");
        String intentsAsString = registration.getParameterValue("intents");
        String queueName = registration.getParameterValue("printer_name");
        this.printerResponseName = registration.getParameterValue("printer_response_name");
        if (!Util.isEmpty((String)queueName)) {
            this.printerName = queueName;
        }
        if (this.printerResponseName == null) {
            this.printerResponseName = this.printerName + "-response";
        }
        if (intentsAsString != null) {
            try {
                this.intents = Integer.parseInt(intentsAsString);
            }
            catch (Exception e) {
                this.log.severe("No intents value");
            }
        }
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    private String getValidPrinterName() {
        return Optional.ofNullable(this.printerName).orElse("").replaceAll("[^-0-9A-Za-z]", "").toLowerCase();
    }

    private Map<String, Object> getInvoice(FiscalDocument fiscalDocument) {
        HashMap<String, Object> document = new HashMap<String, Object>();
        if (fiscalDocument.getDocumentType().equals((Object)FiscalDocument.DocumentType.INVOICE)) {
            document.put("document_type", "invoice");
        } else if (fiscalDocument.getDocumentType().equals((Object)FiscalDocument.DocumentType.CREDIT_MEMO)) {
            document.put("document_type", "credit_memo");
            if (!Util.isEmpty((String)fiscalDocument.getReversalDocumentNo())) {
                document.put("reversal_document_no", fiscalDocument.getReversalDocumentNo());
            }
            if (!Util.isEmpty((String)fiscalDocument.getReversalFiscalPrinterNo())) {
                document.put("reversal_fiscal_printer_no", fiscalDocument.getReversalFiscalPrinterNo());
            }
            if (fiscalDocument.getReversalDocumentDate() != null) {
                document.put("reversal_document_date", DATE_FORMAT.format(fiscalDocument.getReversalDocumentDate()));
            }
        } else if (fiscalDocument.getDocumentType().equals((Object)FiscalDocument.DocumentType.DEBIT_MEMO)) {
            document.put("document_type", "debit_memo");
        }
        if (!Util.isEmpty((String)fiscalDocument.getDocumentNo())) {
            document.put("document_no", fiscalDocument.getDocumentNo());
        }
        if (fiscalDocument.getDocumentDate() != null) {
            document.put("document_date", DATE_FORMAT.format(fiscalDocument.getDocumentDate()));
        }
        if (!Util.isEmpty((String)fiscalDocument.getAddress1())) {
            document.put("address_1", fiscalDocument.getAddress1());
        }
        if (!Util.isEmpty((String)fiscalDocument.getAddress2())) {
            document.put("address_2", fiscalDocument.getAddress2());
        }
        if (!Util.isEmpty((String)fiscalDocument.getAddress3())) {
            document.put("address_3", fiscalDocument.getAddress3());
        }
        if (!Util.isEmpty((String)fiscalDocument.getAddress4())) {
            document.put("address_4", fiscalDocument.getAddress4());
        }
        if (!Util.isEmpty((String)fiscalDocument.getBusinessPartnerName())) {
            document.put("business_partner_name", fiscalDocument.getBusinessPartnerName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getBusinessPartnerTaxId())) {
            document.put("business_partner_tax_id", fiscalDocument.getBusinessPartnerTaxId());
        }
        if (!Util.isEmpty((String)fiscalDocument.getBusinessPartnerDuns())) {
            document.put("business_partner_duns", fiscalDocument.getBusinessPartnerDuns());
        }
        if (!Util.isEmpty((String)fiscalDocument.getCityName())) {
            document.put("city_name", fiscalDocument.getCityName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getCountryName())) {
            document.put("country_name", fiscalDocument.getCountryName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getRegionName())) {
            document.put("region_name", fiscalDocument.getRegionName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDescription())) {
            document.put("description", fiscalDocument.getDescription());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDocumentNote())) {
            document.put("document_note", fiscalDocument.getDocumentNote());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDocumentUuid())) {
            document.put("document_uuid", fiscalDocument.getDocumentUuid());
        }
        if (!Util.isEmpty((String)fiscalDocument.getPoReferenceNo())) {
            document.put("po_reference_no", fiscalDocument.getPoReferenceNo());
        }
        if (!Util.isEmpty((String)fiscalDocument.getSoReferenceNo())) {
            document.put("so_reference_no", fiscalDocument.getSoReferenceNo());
        }
        if (!Util.isEmpty((String)fiscalDocument.getReversalDocumentNo())) {
            document.put("reversal_document_no", fiscalDocument.getReversalDocumentNo());
        }
        if (!Util.isEmpty((String)fiscalDocument.getReversalFiscalPrinterNo())) {
            document.put("reversal_fiscal_printer_no", fiscalDocument.getReversalFiscalPrinterNo());
        }
        if (fiscalDocument.getReversalDocumentDate() != null) {
            document.put("reversal_document_date", DATE_FORMAT.format(fiscalDocument.getReversalDocumentDate()));
        }
        if (!Util.isEmpty((String)fiscalDocument.getSalesRepresentativeValue())) {
            document.put("sales_representative_value", fiscalDocument.getSalesRepresentativeValue());
        }
        if (!Util.isEmpty((String)fiscalDocument.getSalesRepresentativeName())) {
            document.put("sales_representative_name", fiscalDocument.getSalesRepresentativeName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getSalesRegionValue())) {
            document.put("sales_region_value", fiscalDocument.getSalesRegionValue());
        }
        if (!Util.isEmpty((String)fiscalDocument.getSalesRegionName())) {
            document.put("sales_region_name", fiscalDocument.getSalesRegionName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getPaymentTerm())) {
            document.put("payment_term", fiscalDocument.getPaymentTerm());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDocumentTypeName())) {
            document.put("document_type_name", fiscalDocument.getDocumentTypeName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDeliveryAddress())) {
            document.put("delivery_address", fiscalDocument.getDeliveryAddress());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDeliveryPhone())) {
            document.put("delivery_phone", fiscalDocument.getDeliveryPhone());
        }
        if (!Util.isEmpty((String)fiscalDocument.getWarehouseName())) {
            document.put("warehouse_name", fiscalDocument.getWarehouseName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getAmountInWords())) {
            document.put("amount_in_words", fiscalDocument.getAmountInWords());
        }
        if (fiscalDocument.getTotalLines() != null) {
            document.put("total_lines", fiscalDocument.getTotalLines().doubleValue());
        }
        if (fiscalDocument.getGrandTotal() != null) {
            document.put("grand_total", fiscalDocument.getGrandTotal().doubleValue());
        }
        if (!Util.isEmpty((String)fiscalDocument.getPosName())) {
            document.put("pos_name", fiscalDocument.getPosName());
        }
        document.put("discount_printed", fiscalDocument.isDiscountPrinted());
        document.put("products_quantities", fiscalDocument.getProductQuantities());
        return document;
    }

    private List<Map<String, Object>> getInvoiceLines(FiscalDocument fiscalDocument) {
        ArrayList<Map<String, Object>> lines = new ArrayList<Map<String, Object>>();
        fiscalDocument.getFiscalDocumentLines().forEach(fiscalDocumentLine -> {
            HashMap<String, Object> documentLine = new HashMap<String, Object>();
            if (!Util.isEmpty((String)fiscalDocumentLine.getProductValue())) {
                documentLine.put("product_value", fiscalDocumentLine.getProductValue());
            }
            if (!Util.isEmpty((String)fiscalDocumentLine.getProductName())) {
                documentLine.put("product_name", fiscalDocumentLine.getProductName());
            }
            if (!Util.isEmpty((String)fiscalDocumentLine.getProductDescription())) {
                documentLine.put("product_description", fiscalDocumentLine.getProductDescription());
            }
            if (!Util.isEmpty((String)fiscalDocumentLine.getProductBarCode())) {
                documentLine.put("product_barcode", fiscalDocumentLine.getProductBarCode());
            }
            if (!Util.isEmpty((String)fiscalDocumentLine.getLineDescription())) {
                documentLine.put("line_description", fiscalDocumentLine.getLineDescription());
            }
            if (fiscalDocumentLine.getDiscount() != null) {
                documentLine.put("discount", fiscalDocumentLine.getDiscount().doubleValue());
            }
            documentLine.put("product_price", Optional.ofNullable(fiscalDocumentLine.getProductPrice()).orElse(Env.ZERO).doubleValue());
            documentLine.put("product_price_list", Optional.ofNullable(fiscalDocumentLine.getProductPriceList()).orElse(Env.ZERO).doubleValue());
            if (fiscalDocumentLine.getTaxRate() != null) {
                documentLine.put("tax_rate", fiscalDocumentLine.getTaxRate().doubleValue());
            }
            if (fiscalDocumentLine.getQuantity() != null) {
                documentLine.put("quantity", fiscalDocumentLine.getQuantity().doubleValue());
            }
            lines.add(documentLine);
        });
        return lines;
    }

    private List<Map<String, Object>> getInvoiceTaxes(FiscalDocument fiscalDocument) {
        ArrayList<Map<String, Object>> lines = new ArrayList<Map<String, Object>>();
        fiscalDocument.getFiscalDocumentTaxes().forEach(fiscalDocumentTax -> {
            HashMap<String, Object> documentLine = new HashMap<String, Object>();
            if (!Util.isEmpty((String)fiscalDocumentTax.getTaxValue())) {
                documentLine.put("tax_value", fiscalDocumentTax.getTaxValue());
            }
            if (!Util.isEmpty((String)fiscalDocumentTax.getTaxName())) {
                documentLine.put("tax_name", fiscalDocumentTax.getTaxName());
            }
            if (fiscalDocumentTax.getTaxRate() != null) {
                documentLine.put("tax_rate", fiscalDocumentTax.getTaxRate().doubleValue());
            }
            if (fiscalDocumentTax.getTaxBaseAmount() != null) {
                documentLine.put("tax_base_amount", fiscalDocumentTax.getTaxBaseAmount().doubleValue());
            }
            if (fiscalDocumentTax.getTaxAmount() != null) {
                documentLine.put("tax_amount", fiscalDocumentTax.getTaxAmount().doubleValue());
            }
            lines.add(documentLine);
        });
        return lines;
    }

    private List<Map<String, Object>> getInvoicePayments(FiscalDocument fiscalDocument) {
        ArrayList<Map<String, Object>> lines = new ArrayList<Map<String, Object>>();
        fiscalDocument.getFiscalDocumentPayments().forEach(payment -> {
            HashMap<String, Object> documentLine = new HashMap<String, Object>();
            if (!Util.isEmpty((String)payment.getReferenceNo())) {
                documentLine.put("reference_no", payment.getReferenceNo());
            }
            documentLine.put("payment_date", DATE_FORMAT.format(payment.getPaymentDate()));
            if (!Util.isEmpty((String)payment.getDescription())) {
                documentLine.put("description", payment.getDescription());
            }
            if (!Util.isEmpty((String)payment.getCurrencyCode())) {
                documentLine.put("currency_code", payment.getCurrencyCode());
            }
            if (!Util.isEmpty((String)payment.getTenderType())) {
                documentLine.put("tender_type_value", payment.getTenderType());
            }
            if (!Util.isEmpty((String)payment.getTenderTypeName())) {
                documentLine.put("tender_type_name", payment.getTenderTypeName());
            }
            if (!Util.isEmpty((String)payment.getPaymentMethodValue())) {
                documentLine.put("payment_method_value", payment.getPaymentMethodValue());
            }
            if (!Util.isEmpty((String)payment.getPaymentMethodName())) {
                documentLine.put("payment_method_name", payment.getPaymentMethodName());
            }
            documentLine.put("amount", Optional.ofNullable(payment.getAmount()).orElse(Env.ZERO).doubleValue());
            documentLine.put("converted_amount", Optional.ofNullable(payment.getConvertedAmount()).orElse(Env.ZERO).doubleValue());
            lines.add(documentLine);
        });
        return lines;
    }

    @Override
    public void printFiscalDocument(FiscalDocument fiscalDocument) {
        this.log.fine("Fiscal Document: " + fiscalDocument);
        try {
            KafkaProducer producer = KafkaLoader.getInstance().getProducer(this.host + ":" + this.port, this.getValidPrinterName());
            HashMap<String, Object> document = new HashMap<String, Object>();
            document.put("printer_name", this.printerName);
            if (!Util.isEmpty((String)this.portName)) {
                document.put("port_name", this.portName);
            }
            document.put("invoice", this.getInvoice(fiscalDocument));
            document.put("lines", this.getInvoiceLines(fiscalDocument));
            document.put("taxes", this.getInvoiceTaxes(fiscalDocument));
            document.put("payments", this.getInvoicePayments(fiscalDocument));
            ProducerRecord record = new ProducerRecord(this.getValidPrinterName(), (Object)"fiscal_printer_document", document);
            producer.send(record);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    @Override
    public void printNonDocument(NonFiscalDocument nonFiscalDocument) {
        this.log.fine("Non Fiscal Document: " + nonFiscalDocument);
    }

    @Override
    public void printFiscalReport(FiscalReport fiscalReport) {
        this.log.fine("Fiscal Report: " + fiscalReport);
        try {
            KafkaProducer producer = KafkaLoader.getInstance().getProducer(this.host + ":" + this.port, this.getValidPrinterName());
            HashMap<String, Object> report = new HashMap<String, Object>();
            report.put("printer_name", this.printerName);
            if (!Util.isEmpty((String)this.portName)) {
                report.put("port_name", this.portName);
            }
            if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_X)) {
                report.put("document_type", "x_report");
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z)) {
                report.put("document_type", "z_report");
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z_DATE_RANGE)) {
                report.put("document_type", "z_report_date_range");
                report.put("z_report_date_from", DATE_FORMAT.format(fiscalReport.getReportDateFrom()));
                report.put("z_report_date_to", DATE_FORMAT.format(fiscalReport.getReportDateTo()));
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z_NUMBER_RANGE)) {
                report.put("document_type", "z_report_number_range");
                report.put("z_report_number_from", fiscalReport.getReportNumberFrom());
                report.put("z_report_number_to", fiscalReport.getReportNumberTo());
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPRINT_INVOICE_DATE_RANGE)) {
                report.put("document_type", "reprint_invoice_report_date_range");
                report.put("reprint_invoice_report_date_from", DATE_FORMAT.format(fiscalReport.getReportDateFrom()));
                report.put("reprint_invoice_report_date_to", DATE_FORMAT.format(fiscalReport.getReportDateTo()));
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPRINT_INVOICE_NUMBER_RANGE)) {
                report.put("document_type", "reprint_invoice_report_number_range");
                report.put("reprint_invoice_report_number_from", fiscalReport.getReportNumberFrom());
                report.put("reprint_invoice_report_number_to", fiscalReport.getReportNumberTo());
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPRINT_DEBIT_MEMO_DATE_RANGE)) {
                report.put("document_type", "reprint_debit_memo_report_date_range");
                report.put("reprint_debit_memo_report_date_from", DATE_FORMAT.format(fiscalReport.getReportDateFrom()));
                report.put("reprint_debit_memo_report_date_to", DATE_FORMAT.format(fiscalReport.getReportDateTo()));
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPRINT_DEBIT_MEMO_NUMBER_RANGE)) {
                report.put("document_type", "reprint_debit_memo_report_number_range");
                report.put("reprint_debit_memo_report_number_from", fiscalReport.getReportNumberFrom());
                report.put("reprint_debit_memo_report_number_to", fiscalReport.getReportNumberTo());
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPRINT_CREDIT_MEMO_DATE_RANGE)) {
                report.put("document_type", "reprint_credit_memo_report_date_range");
                report.put("reprint_credit_memo_report_date_from", DATE_FORMAT.format(fiscalReport.getReportDateFrom()));
                report.put("reprint_credit_memo_report_date_to", DATE_FORMAT.format(fiscalReport.getReportDateTo()));
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPRINT_CREDIT_MEMO_NUMBER_RANGE)) {
                report.put("document_type", "reprint_credit_memo_report_number_range");
                report.put("reprint_credit_memo_report_number_from", fiscalReport.getReportNumberFrom());
                report.put("reprint_credit_memo_report_number_to", fiscalReport.getReportNumberTo());
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPRINT_DOCUMENT_TAX_ID)) {
                report.put("document_type", "report_reprint_document_by_taxid");
                report.put("report_reprint_document_taxid", fiscalReport.getTaxId());
            }
            if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z_DATE_RANGE) || fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z_NUMBER_RANGE)) {
                if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.DETAILED)) {
                    report.put("historic_document_type", "historic_document_type_detailed");
                } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.MONTHLY)) {
                    report.put("historic_document_type", "historic_document_type_monthly");
                } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.SUMMARIZED)) {
                    report.put("historic_document_type", "historic_document_type_summarized");
                }
            }
            ProducerRecord record = new ProducerRecord(this.getValidPrinterName(), (Object)"fiscal_printer_report", report);
            producer.send(record);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    @Override
    public void setupFiscalPrint(FiscalSetup setupCommand) {
        this.log.fine("Fiscal setup: " + setupCommand);
        try {
            KafkaProducer producer = KafkaLoader.getInstance().getProducer(this.host + ":" + this.port, this.getValidPrinterName());
            HashMap<String, String> setup = new HashMap<String, String>();
            setup.put("printer_name", this.printerName);
            if (!Util.isEmpty((String)this.portName)) {
                setup.put("port_name", this.portName);
            }
            if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.CUT_PAPER)) {
                setup.put("type", "cut_paper");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.GET_STATUS)) {
                setup.put("type", "get_status");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.OPEN_DRAWER)) {
                setup.put("type", "open_drawer");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.RESET_PRINTER)) {
                setup.put("type", "reset_printer");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.SET_TIME)) {
                setup.put("type", "set_time");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.REVERSE_INVOICE)) {
                setup.put("type", "reverse_invoice");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.REVERSE_CREDIT_MEMO)) {
                setup.put("type", "reverse_credit_memo");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.REVERSE_DEBIT_MEMO)) {
                setup.put("type", "reverse_debit_memo");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.FIRMWARE_INFORMATION)) {
                setup.put("type", "firmware_information");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.MEMORY_STATUS)) {
                setup.put("type", "memory_status");
            } else if (setupCommand.getSetupType().equals((Object)FiscalSetup.SetupType.FIRMWARE_SET_VALUES)) {
                setup.put("type", "firmware_set_values");
                setup.put("firmware_version", setupCommand.getFirmwareVersion());
            }
            ProducerRecord record = new ProducerRecord(this.getValidPrinterName(), (Object)"fiscal_printer_setup", setup);
            producer.send(record);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    @Override
    public void messageReceived(PrinterEvent ev) {
        FiscalDocumentResult document;
        if (ev == null) {
            return;
        }
        if (ev.getEventType() == 1 && (document = ev.getDocument()).getDocumentUuid() != null && document.getDocumentNo() != null) {
            this.saveDocumentResult(document, ev.getFiscalPrinterResponse());
        }
    }

    private void saveDocumentResult(FiscalDocumentResult document, IFiscalPrinterResponse response) {
        Trx.run(transactionName -> {
            if (!(Util.isEmpty((String)document.getDocumentUuid()) || document.getIsError() || Util.isEmpty((String)document.getDocumentNo()))) {
                MInvoice invoice = (MInvoice)new Query(Env.getCtx(), "C_Invoice", "UUID = ?", transactionName).setParameters(new Object[]{document.getDocumentUuid()}).setClient_ID().first();
                if (invoice != null) {
                    try {
                        invoice.set_ValueOfColumn("FiscalDocumentNo", (Object)document.getDocumentNo());
                        invoice.set_ValueOfColumn("PrintFiscalDocument", (Object)"Y");
                        invoice.set_ValueOfColumn("FiscalClosingNo", (Object)document.getClosingNo());
                        if (document.getPrintDate() != null) {
                            invoice.set_ValueOfColumn("FiscalPrintDate", (Object)document.getPrintDate());
                        }
                        invoice.setDocumentNo(document.getDocumentNo());
                        invoice.saveEx();
                        this.log.info("Document is Printed: " + response);
                    }
                    catch (Exception e) {
                        this.log.severe("Print document error: " + e.getLocalizedMessage());
                        MFPLog.addToLog(Env.getCtx(), response, e.getLocalizedMessage(), transactionName);
                    }
                    try {
                        if (invoice.get_ValueAsInt("FiscalPrinter_ID") > 0) {
                            String printerSerialNo = document.getFiscalPrinterSerialNo();
                            if (Util.isEmpty((String)printerSerialNo)) {
                                MADAppRegistration registeredApplication = MADAppRegistration.getById((Properties)Env.getCtx(), (int)invoice.get_ValueAsInt("FiscalPrinter_ID"), (String)transactionName);
                                printerSerialNo = Optional.ofNullable(registeredApplication.getValue()).orElse("");
                            }
                            if (printerSerialNo.length() > 4) {
                                printerSerialNo = printerSerialNo.substring(printerSerialNo.length() - 4);
                            }
                            String completefiscalDocumentNo = DataUtils.leftPadding((String)printerSerialNo, (int)4, (String)"0") + "-" + document.getDocumentNo();
                            invoice.setDocumentNo(completefiscalDocumentNo);
                            invoice.saveEx();
                        }
                    }
                    catch (Exception e) {
                        this.log.severe("Saving document no error: " + e.getLocalizedMessage());
                        MFPLog.addToLog(Env.getCtx(), document, e.getLocalizedMessage(), transactionName);
                    }
                }
            } else if (document.getIsError()) {
                this.log.severe(this.getPrettyError(response) + "Printer error: (Printer error flag)");
                MFPLog.addToLog(Env.getCtx(), document, this.getPrettyError(response) + "Printer error: (Printer error flag)", transactionName);
            } else if (Util.isEmpty((String)response.getDocumentNo())) {
                this.log.severe(this.getPrettyError(response) + "Printer error: (Last Document No not found)");
                MFPLog.addToLog(Env.getCtx(), document, this.getPrettyError(response) + "Printer error: (Last Document No not found)", transactionName);
            } else {
                this.log.severe(this.getPrettyError(response) + "Document UUID Not found");
                MFPLog.addToLog(Env.getCtx(), document, this.getPrettyError(response) + "Document UUID Not found", transactionName);
            }
        });
    }

    private String getPrettyError(IFiscalPrinterResponse response) {
        if (!Optional.ofNullable(response).isPresent()) {
            return "";
        }
        Timestamp printDate = null;
        if (response.getPrintDate() != null) {
            printDate = response.getPrintDate();
        }
        return "Document Uuid: " + response.getDocumentUuid() + "\nFiscal Printer No: " + response.getFiscalPrinterSerialNo() + "\nPrinter Name: " + response.getPrinterName() + "\nLast Document No: " + response.getDocumentNo() + "\n" + (Optional.ofNullable(printDate).isPresent() ? "Print Date: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(printDate) + "\n" : "") + "Result: " + response.getErrorMessage() + "\n";
    }

    private String getPrinterResponseName(MADAppRegistration fiscalPrinter) {
        MOrg client = MOrg.get((Properties)Env.getCtx(), (int)fiscalPrinter.getAD_Org_ID());
        this.printerName = client.getValue() + "-" + fiscalPrinter.getValue();
        String queueName = fiscalPrinter.getParameterValue("printer_name");
        this.printerResponseName = fiscalPrinter.getParameterValue("printer_response_name");
        if (!Util.isEmpty((String)queueName)) {
            this.printerName = queueName;
        }
        if (this.printerResponseName == null) {
            this.printerResponseName = this.printerName + "-response";
        }
        return this.printerResponseName;
    }

    @Override
    public String read(Properties context, String transactionName, boolean allQueues) throws Exception {
        ArrayList<String> queues = new ArrayList<String>();
        if (allQueues) {
            new Query(context, "AD_AppRegistration", "ApplicationType=?", transactionName).setParameters(new Object[]{this.applicationType}).setOrderBy("Value").getIDsAsList().forEach(fiscalPrinterId -> {
                MADAppRegistration fiscalPrinter = MADAppRegistration.getById((Properties)context, (int)fiscalPrinterId, (String)transactionName);
                String responseName = this.getPrinterResponseName(fiscalPrinter);
                queues.add(responseName);
            });
        } else {
            queues.add(this.printerResponseName);
        }
        if (this.intents == 0) {
            this.intents = 5;
        }
        String completeUrl = this.host + ":" + this.port;
        String errorMessage = Msg.parseTranslation((Properties)Env.getCtx(), (String)"@Error@");
        String errorSummary = Msg.parseTranslation((Properties)Env.getCtx(), (String)"@SaveError@");
        long startTime = System.currentTimeMillis();
        AtomicInteger errors = new AtomicInteger();
        AtomicInteger readed = new AtomicInteger();
        Properties config = new Properties();
        config.put("client.id", InetAddress.getLocalHost().getHostName());
        config.put("group.id", "foo");
        config.put("bootstrap.servers", completeUrl);
        config.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        config.put("value.deserializer", MapDeserializer.class.getName());
        config.put("default.api.timeout.ms", (Object)5000);
        KafkaConsumer consumer = new KafkaConsumer(config);
        consumer.subscribe(queues);
        ConsumerRecords records = consumer.poll(Duration.ofSeconds(10L));
        records.forEach(record -> {
            try {
                if (((String)record.key()).equals("fiscal_printer_document")) {
                    Map values = (Map)record.value();
                    FiscalDocumentResult result = FiscalDocumentResult.newInstance().withDocumentUuid((String)values.get("document_uuid")).withDocumentNo((String)values.get("document_no")).withClosingNo((String)values.get("closing_no")).withDocumentType(FiscalDocumentResult.DocumentType.INVOICE);
                    String documentType = (String)values.get("document_type");
                    if (documentType != null) {
                        if (documentType.equals("credit_memo")) {
                            result.withDocumentType(FiscalDocumentResult.DocumentType.CREDIT_MEMO);
                        } else if (documentType.equals("debit_memo")) {
                            result.withDocumentType(FiscalDocumentResult.DocumentType.DEBIT_MEMO);
                        } else if (documentType.equals("non_fiscal_document")) {
                            result.withDocumentType(FiscalDocumentResult.DocumentType.NON_FISCAL_DOCUMENT);
                        }
                    }
                    if (values.get("fiscal_printer_serial_no") != null) {
                        result.withFiscalPrinterSerialNo((String)values.get("fiscal_printer_serial_no"));
                    }
                    this.messageReceived(new PrinterEvent(this, result));
                    readed.addAndGet(1);
                }
            }
            catch (Exception e) {
                errors.addAndGet(1);
                this.addLog(errorMessage, errorSummary, e.getLocalizedMessage(), true);
            }
        });
        consumer.commitSync();
        consumer.unsubscribe();
        consumer.close(Duration.ofSeconds(1L));
        long endTime = System.currentTimeMillis();
        SimpleDateFormat format = DisplayType.getDateFormat((int)16);
        String message = Msg.parseTranslation((Properties)Env.getCtx(), (String)("@Records@: " + readed.get() + " @Errors@: " + errors.get() + " @StartTime@: " + format.format(new Timestamp(startTime)) + " @EndTime@: " + format.format(new Timestamp(startTime)) + " @Duration@" + TimeUtil.formatElapsed((long)(startTime - endTime))));
        this.addLog(Msg.getMsg((Properties)Env.getCtx(), (String)"Process"), Msg.getMsg((Properties)Env.getCtx(), (String)"Summary"), message, false);
        return message;
    }

    private void addLog(String header, String summary, String textMessage, boolean isError) {
    }
}

