/*
 * Decompiled with CFR 0.152.
 */
package org.spin.support;

import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.grpc.util.Document;
import org.spin.grpc.util.DocumentLine;
import org.spin.grpc.util.DocumentPayment;
import org.spin.grpc.util.DocumentTax;
import org.spin.model.MADAppRegistration;
import org.spin.net.grpc.util.FiscalPrintSender;
import org.spin.support.fp.FiscalDocument;
import org.spin.support.fp.FiscalReport;
import org.spin.support.fp.FiscalSetup;
import org.spin.support.fp.IFiscalPrinter;
import org.spin.support.fp.NonFiscalDocument;

public class FiscalPrintGrpcAPI
implements IFiscalPrinter {
    private int registrationId = 0;
    private CLogger log = CLogger.getCLogger(FiscalPrintGrpcAPI.class);
    private FiscalPrintSender service;
    private int port;
    private String printerName = null;
    private String portName = null;
    private String host = null;
    private final String PRINTER_NAME = "PrinterName";
    private final String PORT_NAME = "PortName";
    private long timeout = 0L;
    private String errorMessage = null;

    private void openService() {
        this.service = new FiscalPrintSender(this.host, this.port, this.timeout, this.printerName);
    }

    public String testConnection() {
        this.openService();
        this.service.printDocument(Document.newBuilder().setDocumentType(Document.DocumentType.SETUP).setSetupType(Document.SetupType.GET_STATUS).setPrinterName(this.printerName).setPortName(this.portName).build());
        this.service.run();
        if (this.errorMessage != null && this.errorMessage.contains("@Error@")) {
            throw new AdempiereException(this.errorMessage);
        }
        return this.errorMessage;
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.port = registration.getPort();
        this.host = registration.getHost();
        this.printerName = registration.getParameterValue("PrinterName");
        this.portName = registration.getParameterValue("PortName");
        this.timeout = registration.getTimeout();
        this.errorMessage = null;
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void printFiscalDocument(FiscalDocument fiscalDocument) {
        this.log.fine("Fiscal Document: " + fiscalDocument);
        this.openService();
        Document.Builder documentBuilder = Document.newBuilder();
        documentBuilder.setPrinterName(this.printerName);
        if (!Util.isEmpty((String)this.portName)) {
            documentBuilder.setPortName(this.portName);
        }
        if (fiscalDocument.getDocumentType().equals((Object)FiscalDocument.DocumentType.INVOICE)) {
            documentBuilder.setDocumentType(Document.DocumentType.INVOICE);
        } else if (fiscalDocument.getDocumentType().equals((Object)FiscalDocument.DocumentType.CREDIT_MEMO)) {
            documentBuilder.setDocumentType(Document.DocumentType.CREDIT_MEMO);
            if (!Util.isEmpty((String)fiscalDocument.getReversalDocumentNo())) {
                documentBuilder.setReversalDocumentNo(fiscalDocument.getReversalDocumentNo());
            }
            if (!Util.isEmpty((String)fiscalDocument.getReversalFiscalPrinterNo())) {
                documentBuilder.setReversalFiscalPrinterNo(fiscalDocument.getReversalFiscalPrinterNo());
            }
            if (fiscalDocument.getReversalDocumentDate() != null) {
                documentBuilder.setReversalDocumentDate(fiscalDocument.getReversalDocumentDate().getTime());
            }
        } else if (fiscalDocument.getDocumentType().equals((Object)FiscalDocument.DocumentType.DEBIT_MEMO)) {
            documentBuilder.setDocumentType(Document.DocumentType.DEBIT_MEMO);
        }
        if (!Util.isEmpty((String)fiscalDocument.getDocumentNo())) {
            documentBuilder.setDocumentNo(fiscalDocument.getDocumentNo());
        }
        if (fiscalDocument.getDocumentDate() != null) {
            documentBuilder.setDocumentDate(fiscalDocument.getDocumentDate().getTime());
        }
        if (!Util.isEmpty((String)fiscalDocument.getAddress1())) {
            documentBuilder.setAddress1(fiscalDocument.getAddress1());
        }
        if (!Util.isEmpty((String)fiscalDocument.getAddress2())) {
            documentBuilder.setAddress2(fiscalDocument.getAddress2());
        }
        if (!Util.isEmpty((String)fiscalDocument.getAddress3())) {
            documentBuilder.setAddress3(fiscalDocument.getAddress3());
        }
        if (!Util.isEmpty((String)fiscalDocument.getAddress4())) {
            documentBuilder.setAddress4(fiscalDocument.getAddress4());
        }
        if (!Util.isEmpty((String)fiscalDocument.getBusinessPartnerName())) {
            documentBuilder.setBusinessPartnerName(fiscalDocument.getBusinessPartnerName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getBusinessPartnerTaxId())) {
            documentBuilder.setBusinessPartnerTaxId(fiscalDocument.getBusinessPartnerTaxId());
        }
        if (!Util.isEmpty((String)fiscalDocument.getBusinessPartnerDuns())) {
            documentBuilder.setBusinessPartnerDuns(fiscalDocument.getBusinessPartnerDuns());
        }
        if (!Util.isEmpty((String)fiscalDocument.getCityName())) {
            documentBuilder.setCityName(fiscalDocument.getCityName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getCountryName())) {
            documentBuilder.setCountryName(fiscalDocument.getCountryName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getRegionName())) {
            documentBuilder.setRegionName(fiscalDocument.getRegionName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDescription())) {
            documentBuilder.setDescription(fiscalDocument.getDescription());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDocumentNote())) {
            documentBuilder.setDocumentNote(fiscalDocument.getDocumentNote());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDocumentUuid())) {
            documentBuilder.setDocumentUuid(fiscalDocument.getDocumentUuid());
        }
        if (!Util.isEmpty((String)fiscalDocument.getPoReferenceNo())) {
            documentBuilder.setPoReferenceNo(fiscalDocument.getPoReferenceNo());
        }
        if (!Util.isEmpty((String)fiscalDocument.getSoReferenceNo())) {
            documentBuilder.setSoReferenceNo(fiscalDocument.getSoReferenceNo());
        }
        if (!Util.isEmpty((String)fiscalDocument.getReversalDocumentNo())) {
            documentBuilder.setReversalDocumentNo(fiscalDocument.getReversalDocumentNo());
        }
        if (!Util.isEmpty((String)fiscalDocument.getReversalFiscalPrinterNo())) {
            documentBuilder.setReversalFiscalPrinterNo(fiscalDocument.getReversalFiscalPrinterNo());
        }
        if (fiscalDocument.getReversalDocumentDate() != null) {
            documentBuilder.setReversalDocumentDate(fiscalDocument.getReversalDocumentDate().getTime());
        }
        if (!Util.isEmpty((String)fiscalDocument.getSalesRepresentativeValue())) {
            documentBuilder.setSalesRepresentativeValue(fiscalDocument.getSalesRepresentativeValue());
        }
        if (!Util.isEmpty((String)fiscalDocument.getSalesRepresentativeName())) {
            documentBuilder.setSalesRepresentativeName(fiscalDocument.getSalesRepresentativeName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getSalesRegionValue())) {
            documentBuilder.setSalesRegionValue(fiscalDocument.getSalesRegionValue());
        }
        if (!Util.isEmpty((String)fiscalDocument.getSalesRegionName())) {
            documentBuilder.setSalesRegionName(fiscalDocument.getSalesRegionName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getPaymentTerm())) {
            documentBuilder.setPaymentTerm(fiscalDocument.getPaymentTerm());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDocumentTypeName())) {
            documentBuilder.setDocumentTypeName(fiscalDocument.getDocumentTypeName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDeliveryAddress())) {
            documentBuilder.setDeliveryAddress(fiscalDocument.getDeliveryAddress());
        }
        if (!Util.isEmpty((String)fiscalDocument.getDeliveryPhone())) {
            documentBuilder.setDeliveryPhone(fiscalDocument.getDeliveryPhone());
        }
        if (!Util.isEmpty((String)fiscalDocument.getWarehouseName())) {
            documentBuilder.setWarehouseName(fiscalDocument.getWarehouseName());
        }
        if (!Util.isEmpty((String)fiscalDocument.getAmountInWords())) {
            documentBuilder.setAmountInWords(fiscalDocument.getAmountInWords());
        }
        if (fiscalDocument.getTotalLines() != null) {
            documentBuilder.setTotalLines(fiscalDocument.getTotalLines().doubleValue());
        }
        if (fiscalDocument.getGrandTotal() != null) {
            documentBuilder.setGrandTotal(fiscalDocument.getGrandTotal().doubleValue());
        }
        if (!Util.isEmpty((String)fiscalDocument.getPosName())) {
            documentBuilder.setPosName(fiscalDocument.getPosName());
        }
        documentBuilder.setDiscountPrinted(fiscalDocument.isDiscountPrinted());
        documentBuilder.setProductsQuantities(fiscalDocument.getProductQuantities());
        fiscalDocument.getFiscalDocumentLines().forEach(fiscalDocumentLine -> {
            DocumentLine.Builder documentLineBuilder = DocumentLine.newBuilder();
            if (!Util.isEmpty((String)fiscalDocumentLine.getProductValue())) {
                documentLineBuilder.setProductValue(fiscalDocumentLine.getProductValue());
            }
            if (!Util.isEmpty((String)fiscalDocumentLine.getProductName())) {
                documentLineBuilder.setProductName(fiscalDocumentLine.getProductName());
            }
            if (!Util.isEmpty((String)fiscalDocumentLine.getProductDescription())) {
                documentLineBuilder.setProductDescription(fiscalDocumentLine.getProductDescription());
            }
            if (!Util.isEmpty((String)fiscalDocumentLine.getProductBarCode())) {
                documentLineBuilder.setProductBarCode(fiscalDocumentLine.getProductBarCode());
            }
            if (!Util.isEmpty((String)fiscalDocumentLine.getLineDescription())) {
                documentLineBuilder.setLineDescription(fiscalDocumentLine.getLineDescription());
            }
            if (fiscalDocumentLine.getDiscount() != null) {
                documentLineBuilder.setDiscount(fiscalDocumentLine.getDiscount().doubleValue());
            }
            documentLineBuilder.setProductPrice(Optional.ofNullable(fiscalDocumentLine.getProductPrice()).orElse(Env.ZERO).doubleValue());
            documentLineBuilder.setProductPriceList(Optional.ofNullable(fiscalDocumentLine.getProductPriceList()).orElse(Env.ZERO).doubleValue());
            if (fiscalDocumentLine.getTaxRate() != null) {
                documentLineBuilder.setTaxRate(fiscalDocumentLine.getTaxRate().doubleValue());
            }
            if (fiscalDocumentLine.getQuantity() != null) {
                documentLineBuilder.setQuantity(fiscalDocumentLine.getQuantity().doubleValue());
            }
            documentBuilder.addDocumentLines(documentLineBuilder);
        });
        fiscalDocument.getFiscalDocumentTaxes().forEach(fiscalDocumentTax -> {
            DocumentTax.Builder documentTaxBuilder = DocumentTax.newBuilder();
            if (!Util.isEmpty((String)fiscalDocumentTax.getTaxValue())) {
                documentTaxBuilder.setTaxValue(fiscalDocumentTax.getTaxValue());
            }
            if (!Util.isEmpty((String)fiscalDocumentTax.getTaxName())) {
                documentTaxBuilder.setTaxName(fiscalDocumentTax.getTaxName());
            }
            if (fiscalDocumentTax.getTaxRate() != null) {
                documentTaxBuilder.setTaxRate(fiscalDocumentTax.getTaxRate().doubleValue());
            }
            if (fiscalDocumentTax.getTaxBaseAmount() != null) {
                documentTaxBuilder.setTaxBaseAmount(fiscalDocumentTax.getTaxBaseAmount().doubleValue());
            }
            if (fiscalDocumentTax.getTaxAmount() != null) {
                documentTaxBuilder.setTaxAmount(fiscalDocumentTax.getTaxAmount().doubleValue());
            }
            documentBuilder.addDocumentTaxes(documentTaxBuilder);
        });
        fiscalDocument.getFiscalDocumentPayments().forEach(payment -> {
            DocumentPayment.Builder documentPayment = DocumentPayment.newBuilder();
            if (!Util.isEmpty((String)payment.getReferenceNo())) {
                documentPayment.setReferenceNo(payment.getReferenceNo());
            }
            documentPayment.setPaymentDate(payment.getPaymentDate().getTime());
            if (!Util.isEmpty((String)payment.getDescription())) {
                documentPayment.setDescription(payment.getDescription());
            }
            if (!Util.isEmpty((String)payment.getCurrencyCode())) {
                documentPayment.setCurrencyCode(payment.getCurrencyCode());
            }
            if (!Util.isEmpty((String)payment.getTenderType())) {
                documentPayment.setTenderType(payment.getTenderType());
            }
            if (!Util.isEmpty((String)payment.getTenderTypeName())) {
                documentPayment.setTenderTypeName(payment.getTenderTypeName());
            }
            documentPayment.setAmount(Optional.ofNullable(payment.getAmount()).orElse(Env.ZERO).doubleValue());
            documentPayment.setConvertedAmount(Optional.ofNullable(payment.getConvertedAmount()).orElse(Env.ZERO).doubleValue());
            documentBuilder.addDocumentPayments(documentPayment);
        });
        try {
            this.service.printDocumentNoWait(documentBuilder.build());
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    @Override
    public void printNonDocument(NonFiscalDocument nonFiscalDocument) {
        this.log.fine("Non Fiscal Document: " + nonFiscalDocument);
    }

    @Override
    public void printFiscalReport(FiscalReport fiscalReport) {
        this.log.fine("Fiscal Report: " + fiscalReport);
        this.openService();
        Document.Builder documentBuilder = Document.newBuilder();
        documentBuilder.setPrinterName(this.printerName);
        if (!Util.isEmpty((String)this.portName)) {
            documentBuilder.setPortName(this.portName);
        }
        if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_X)) {
            documentBuilder.setDocumentType(Document.DocumentType.REPORT_X);
        } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z)) {
            documentBuilder.setDocumentType(Document.DocumentType.REPORT_Z);
        } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z_DATE_RANGE)) {
            documentBuilder.setDocumentType(Document.DocumentType.REPORT_Z_DATE_RANGE).setZReportDateFrom(fiscalReport.getReportDateFrom().getTime()).setZReportDateTo(fiscalReport.getReportDateTo().getTime());
        } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z_NUMBER_RANGE)) {
            documentBuilder.setDocumentType(Document.DocumentType.REPORT_Z_NUMBER_RANGE).setZReportNumberFrom(fiscalReport.getReportNumberFrom()).setZReportNumberTo(fiscalReport.getReportNumberTo());
        }
        if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z_DATE_RANGE) || fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.REPORT_Z_NUMBER_RANGE)) {
            if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.DETAILED)) {
                documentBuilder.setHistoricDocumentType(Document.DocumentType.DETAILED);
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.MONTHLY)) {
                documentBuilder.setHistoricDocumentType(Document.DocumentType.MONTHLY);
            } else if (fiscalReport.getReportType().equals((Object)FiscalReport.ReportType.SUMMARIZED)) {
                documentBuilder.setHistoricDocumentType(Document.DocumentType.SUMMARIZED);
            }
        }
        this.service.printDocument(documentBuilder.build());
        this.service.run();
        if (this.errorMessage != null && this.errorMessage.contains("@Error@")) {
            throw new AdempiereException(this.errorMessage);
        }
    }

    @Override
    public void setupFiscalPrint(FiscalSetup setup) {
        this.log.fine("Fiscal setup: " + setup);
        this.openService();
        Document.Builder documentBuilder = Document.newBuilder();
        documentBuilder.setPrinterName(this.printerName);
        if (!Util.isEmpty((String)this.portName)) {
            documentBuilder.setPortName(this.portName);
        }
        if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.CUT_PAPER)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.CUT_PAPER);
        } else if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.GET_STATUS)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.GET_STATUS);
        } else if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.OPEN_DRAWER)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.OPEN_DRAWER);
        } else if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.RESET_PRINTER)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.RESET_PRINTER);
        } else if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.SET_TIME)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.SET_TIME);
        } else if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.REVERSE_INVOICE)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.REVERSE_INVOICE);
        } else if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.REVERSE_CREDIT_MEMO)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.REVERSE_CREDIT_MEMO);
        } else if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.REVERSE_DEBIT_MEMO)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.REVERSE_DEBIT_MEMO);
        } else if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.FIRMWARE_INFORMATION)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.FIRMWARE_INFORMATION);
        } else if (setup.getSetupType().equals((Object)FiscalSetup.SetupType.MEMORY_STATUS)) {
            documentBuilder.setDocumentType(Document.DocumentType.SETUP);
            documentBuilder.setSetupType(Document.SetupType.MEMORY_STATUS);
        }
        this.service.printDocument(documentBuilder.build());
        this.service.run();
        if (this.errorMessage != null && this.errorMessage.contains("@Error@")) {
            throw new AdempiereException(this.errorMessage);
        }
    }
}

