/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.pos.AdempierePOSException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.process.InvoiceFiscalPrint;
import org.spin.process.SB_InvoiceGenerateFromOrderLineAndPrintAbstract;

public class SB_InvoiceGenerateFromOrderLineAndPrint
extends SB_InvoiceGenerateFromOrderLineAndPrintAbstract {
    private MInvoice invoice = null;
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;
    protected List<MOrderLine> m_records = null;
    protected LinkedHashMap<Integer, LinkedHashMap<String, Object>> m_values = null;
    protected List<MOrder> ordersToInvoice = null;
    protected List<MInvoice> m_invoices = null;
    StringBuffer resultMsg = new StringBuffer();
    private List<Integer> invoicesIds = new ArrayList<Integer>();

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getDateInvoiced() == null) {
            this.setDateInvoiced(Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date"));
            if (this.getDateInvoiced() == null) {
                this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            }
        }
        if (this.getDocAction() == null) {
            this.setDocAction("CO");
        } else if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("PR");
        }
    }

    protected String doIt() throws Exception {
        StringBuffer orderClause = new StringBuffer();
        this.m_invoices = new ArrayList<MInvoice>();
        if (!this.isConsolidateDocument()) {
            orderClause.append("C_BPartner_ID, C_Order_ID, line");
        } else {
            orderClause.append("C_BPartner_ID");
        }
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=?  AND T_Selection.T_Selection_ID=c_orderLine.C_OrderLine_ID)";
        this.m_records = new Query(this.getCtx(), "C_OrderLine", whereClause, this.get_TrxName()).setParameters(new Object[]{this.getAD_PInstance_ID()}).setOrderBy(orderClause.toString()).setClient_ID().list();
        this.ordersToInvoice = new ArrayList<MOrder>();
        for (MOrderLine orderLine : this.m_records) {
            Boolean isadded = false;
            for (MOrder order : this.ordersToInvoice) {
                if (order.getC_Order_ID() != orderLine.getC_Order_ID()) continue;
                isadded = true;
                break;
            }
            if (isadded.booleanValue()) continue;
            this.ordersToInvoice.add(orderLine.getParent());
        }
        StringBuffer msg = new StringBuffer();
        for (MOrder order : this.ordersToInvoice) {
            if (msg.length() > 0) {
                msg.append(", ");
            }
            msg.append(this.generate(order));
        }
        this.sendToPrint(this.invoicesIds);
        return msg.toString();
    }

    private String generate(MOrder order) {
        try {
            MInOutLine shipLine;
            int j;
            MInOutLine[] shipLines;
            MInOut ship;
            int i;
            MInOut[] shipments;
            if (!this.isConsolidateDocument() || this.invoice != null && this.invoice.getC_BPartner_Location_ID() != order.getBill_Location_ID()) {
                this.completeInvoice();
            }
            boolean completeOrder = "O".equals(order.getInvoiceRule());
            boolean doInvoice = false;
            if ("S".equals(order.getInvoiceRule())) {
                this.m_bp = new MBPartner(this.getCtx(), order.getBill_BPartner_ID(), null);
                if (this.m_bp.getC_InvoiceSchedule_ID() == 0) {
                    this.log.warning("BPartner has no Schedule - set to After Delivery");
                    order.setInvoiceRule("D");
                    order.saveEx();
                } else {
                    MInvoiceSchedule is = MInvoiceSchedule.get((Properties)this.getCtx(), (int)this.m_bp.getC_InvoiceSchedule_ID(), (String)this.get_TrxName());
                    if (is.canInvoice(order.getDateOrdered(), order.getGrandTotal())) {
                        doInvoice = true;
                    } else {
                        return "";
                    }
                }
            }
            if (doInvoice || "D".equals(order.getInvoiceRule())) {
                shipments = order.getShipments();
                for (i = 0; i < shipments.length; ++i) {
                    ship = shipments[i];
                    if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
                    shipLines = ship.getLines(false);
                    for (j = 0; j < shipLines.length; ++j) {
                        shipLine = shipLines[j];
                        if (!order.isOrderLine(shipLine.getC_OrderLine_ID()) || !this.getSelectionKeys().contains(shipLine.getC_OrderLine_ID()) || shipLine.isInvoiced()) continue;
                        this.createLine(order, ship, shipLine);
                    }
                    this.m_line += 1000;
                }
            } else {
                MOrderLine[] oLines = order.getLines(true, null);
                for (i = 0; i < oLines.length; ++i) {
                    boolean fullyDelivered;
                    BigDecimal toInvoice;
                    MOrderLine oLine = oLines[i];
                    if (!this.getSelectionKeys().contains(oLine.getC_OrderLine_ID()) || (toInvoice = oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced())).compareTo(Env.ZERO) == 0 && oLine.getM_Product_ID() != 0) continue;
                    boolean bl = fullyDelivered = oLine.getQtyOrdered().compareTo(oLine.getQtyDelivered()) == 0;
                    if (completeOrder && !fullyDelivered) {
                        this.log.fine("Failed CompleteOrder - " + oLine);
                        this.addLog(Msg.getMsg((Properties)this.getCtx(), (String)"GenerateInvoiceFromInOut.InvoiceRule.NotSupported") + oLine);
                        completeOrder = false;
                        break;
                    }
                    if ("I".equals(order.getInvoiceRule())) {
                        this.log.fine("Immediate - ToInvoice=" + toInvoice + " - " + oLine);
                        BigDecimal qtyEntered = toInvoice;
                        if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                            qtyEntered = toInvoice.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4);
                        }
                        this.createLine(order, oLine, toInvoice, qtyEntered);
                        continue;
                    }
                    this.log.fine("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine);
                    this.addLog("Failed: " + order.getInvoiceRule() + " - ToInvoice=" + toInvoice + " - " + oLine);
                }
                if ("I".equals(order.getInvoiceRule())) {
                    this.m_line += 1000;
                }
            }
            if (completeOrder && "O".equals(order.getInvoiceRule())) {
                shipments = order.getShipments();
                for (i = 0; i < shipments.length; ++i) {
                    ship = shipments[i];
                    if (!ship.isComplete() || ship.getDocStatus().equals("RE")) continue;
                    shipLines = ship.getLines(false);
                    for (j = 0; j < shipLines.length; ++j) {
                        shipLine = shipLines[j];
                        if (!order.isOrderLine(shipLine.getC_OrderLine_ID()) || shipLine.isInvoiced()) continue;
                        this.createLine(order, ship, shipLine);
                    }
                    this.m_line += 1000;
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.completeInvoice();
        return "@C_Order_ID@: " + order.getDocumentNo() + "[@C_Invoice_ID@ @Created@: " + this.m_created + "]";
    }

    private void sendToPrint(List<Integer> invoicesIds) {
        if (this.getParameterAsInt("FiscalPrinter_ID") > 0) {
            int fiscalPrinterId = this.getParameterAsInt("FiscalPrinter_ID");
            invoicesIds.stream().map(invoiceId -> new MInvoice(this.getCtx(), invoiceId.intValue(), this.get_TrxName())).forEach(invoice -> {
                ProcessInfo processInfo;
                MDocType documentType = MDocType.get((Properties)invoice.getCtx(), (int)invoice.getC_DocTypeTarget_ID());
                if (documentType.get_ValueAsBoolean("IsPrintedOnFiscalPrinter") && !documentType.get_ValueAsBoolean("IsPrintAfterComplete") && (processInfo = ProcessBuilder.create((Properties)invoice.getCtx()).process(Integer.valueOf(InvoiceFiscalPrint.getProcessId())).withParameter("FiscalPrinter_ID", (Object)fiscalPrinterId).withRecordId(Integer.valueOf(MInvoice.Table_ID), Integer.valueOf(invoice.getC_Invoice_ID())).execute(invoice.get_TrxName())).isError()) {
                    throw new AdempierePOSException(processInfo.getSummary());
                }
            });
        }
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qtyInvoiced, BigDecimal qtyEntered) {
        if (this.invoice == null) {
            this.invoice = new MInvoice(order, 0, this.getDateInvoiced());
            if (this.getOrgTrxId() != 0) {
                this.invoice.setAD_Org_ID(this.getOrgTrxId());
            }
            if (this.getDocTypeId() != 0) {
                this.invoice.setC_DocType_ID(this.getDocTypeId());
            }
            this.invoice.saveEx();
        }
        MInvoiceLine line = new MInvoiceLine(this.invoice);
        line.setOrderLine(orderLine);
        line.setQtyInvoiced(qtyInvoiced);
        line.setQtyEntered(qtyEntered);
        line.setLine(this.m_line + orderLine.getLine());
        line.saveEx();
        this.log.fine(line.toString());
    }

    private void createLine(MOrder order, MInOut ship, MInOutLine sLine) {
        if (this.invoice == null) {
            this.invoice = new MInvoice(order, 0, this.getDateInvoiced());
            if (this.getOrgTrxId() != 0) {
                this.invoice.setAD_Org_ID(this.getOrgTrxId());
            }
            if (this.getDocTypeId() != 0) {
                this.invoice.setC_DocType_ID(this.getDocTypeId());
            }
            this.invoice.saveEx();
        }
        if (this.isAddInvoiceReferenceLine() && (this.m_ship == null || this.m_ship.getM_InOut_ID() != ship.getM_InOut_ID())) {
            MDocType dt = MDocType.get((Properties)this.getCtx(), (int)ship.getC_DocType_ID());
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != ship.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get((Properties)this.getCtx(), (int)order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat((int)15, (Language)Language.getLanguage((String)AD_Language));
            String reference = dt.getPrintName(this.m_bp.getAD_Language()) + ": " + ship.getDocumentNo() + " - " + format.format(ship.getMovementDate());
            this.m_ship = ship;
            MInvoiceLine line = new MInvoiceLine(this.invoice);
            line.setIsDescription(true);
            line.setDescription(reference);
            line.setLine(this.m_line + sLine.getLine() - 2);
            line.saveEx();
            if (order.getBill_Location_ID() != ship.getC_BPartner_Location_ID()) {
                MLocation addr = MLocation.getBPLocation((Properties)this.getCtx(), (int)ship.getC_BPartner_Location_ID(), null);
                line = new MInvoiceLine(this.invoice);
                line.setIsDescription(true);
                line.setDescription(addr.toString());
                line.setLine(this.m_line + sLine.getLine() - 1);
                line.saveEx();
            }
        }
        MInvoiceLine line = new MInvoiceLine(this.invoice);
        line.setShipLine(sLine);
        if (sLine.sameOrderLineUOM()) {
            line.setQtyEntered(sLine.getQtyEntered());
        } else {
            line.setQtyEntered(sLine.getMovementQty());
        }
        line.setQtyInvoiced(sLine.getMovementQty());
        line.setLine(this.m_line + sLine.getLine());
        if (!sLine.isToBeInvoiced()) {
            line.setPriceEntered(Env.ZERO);
            line.setPriceActual(Env.ZERO);
            line.setPriceLimit(Env.ZERO);
            line.setPriceList(Env.ZERO);
            line.setLineNetAmt(Env.ZERO);
            line.setIsDescription(true);
        }
        line.saveEx();
        sLine.setIsInvoiced(true);
        sLine.saveEx();
        this.log.fine(line.toString());
    }

    private void completeInvoice() {
        if (this.invoice != null) {
            if (!this.invoice.processIt(this.getDocAction())) {
                this.log.warning("completeInvoice - failed: " + this.invoice);
                this.addLog(Msg.getMsg((Properties)this.getCtx(), (String)"GenerateInvoiceFromInOut.completeInvoice.Failed") + this.invoice);
            }
            this.invoice.saveEx();
            this.invoicesIds.add(this.invoice.getC_Invoice_ID());
            this.addLog(this.invoice.getC_Invoice_ID(), this.invoice.getDateInvoiced(), null, this.invoice.getDocumentNo());
            this.m_invoices.add(this.invoice);
            ++this.m_created;
        }
        this.invoice = null;
        this.m_ship = null;
        this.m_line = 0;
    }
}

