/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.process.PrintFiscalReportAbstract;
import org.spin.support.fp.FiscalReport;
import org.spin.support.fp.IFiscalPrinter;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class PrintFiscalReport
extends PrintFiscalReportAbstract {
    protected String doIt() throws Exception {
        if (this.getFiscalPrinterId() == 0) {
            throw new AdempiereException("@FiscalPrinter_ID@ @NotFound@");
        }
        MADAppRegistration registeredApplication = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getFiscalPrinterId(), (String)this.get_TrxName());
        IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
        if (supportedApplication != null && IFiscalPrinter.class.isAssignableFrom(supportedApplication.getClass())) {
            IFiscalPrinter fiscalPrinter = (IFiscalPrinter)supportedApplication;
            FiscalReport fiscalReport = new FiscalReport(this.getFiscalCommandType());
            if (this.getFiscalCommandType().equals("ZD") || this.getFiscalCommandType().equals("ID") || this.getFiscalCommandType().equals("DD") || this.getFiscalCommandType().equals("CD")) {
                if (this.getDateDoc() == null || this.getDateDocTo() == null) {
                    throw new AdempiereException("@DateDoc@ @IsMandatory@");
                }
                fiscalReport.withReportDateFrom(this.getDateDoc()).withReportDateTo(this.getDateDocTo());
            } else if (this.getFiscalCommandType().equals("ZN") || this.getFiscalCommandType().equals("IN") || this.getFiscalCommandType().equals("DN") || this.getFiscalCommandType().equals("CN")) {
                if (this.getDocumentNo() <= 0 || this.getDocumentNoTo() <= 0) {
                    throw new AdempiereException("@DocumentNo@ @IsMandatory@");
                }
                fiscalReport.withReportNumberFrom(this.getDocumentNo()).withReportNumberTo(this.getDocumentNoTo());
            } else if (this.getFiscalCommandType().equals("TR")) {
                if (this.getBPartnerId() <= 0) {
                    throw new AdempiereException("@C_BPartner_ID@ @IsMandatory@");
                }
                MBPartner customer = new MBPartner(this.getCtx(), this.getBPartnerId(), this.get_TrxName());
                String taxId = customer.getTaxID();
                if (Util.isEmpty((String)taxId)) {
                    taxId = customer.getValue();
                }
                fiscalReport.withTaxId(taxId);
            }
            if (this.getFiscalCommandType().equals("ZN") || this.getFiscalCommandType().equals("ZD")) {
                if (this.getFiscalReportType().equals("D")) {
                    fiscalReport.withHistoricReportType(FiscalReport.ReportType.DETAILED);
                } else if (this.getFiscalReportType().equals("M")) {
                    fiscalReport.withHistoricReportType(FiscalReport.ReportType.MONTHLY);
                } else if (this.getFiscalReportType().equals("S")) {
                    fiscalReport.withHistoricReportType(FiscalReport.ReportType.SUMMARIZED);
                }
            }
            fiscalPrinter.printFiscalReport(fiscalReport);
        }
        return "Ok";
    }
}

