/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.util.Env;
import org.spin.model.MADAppRegistration;
import org.spin.process.InvoiceFiscalPrintAbstract;
import org.spin.support.fp.FiscalDocument;
import org.spin.support.fp.IFiscalPrinter;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class InvoiceFiscalPrint
extends InvoiceFiscalPrintAbstract {
    protected String doIt() throws Exception {
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
        MInvoice invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        MDocType documentType = MDocType.get((Properties)this.getCtx(), (int)invoice.getC_DocType_ID());
        if (!documentType.get_ValueAsBoolean("IsPrintedOnFiscalPrinter")) {
            return "Ok";
        }
        if (invoice.get_ValueAsBoolean("PrintFiscalDocument")) {
            return "@C_Invoice_ID@ " + invoice.getDocumentNo() + " @Printed@";
        }
        if (invoice.getDocStatus().equals("RE") || invoice.getDocStatus().equals("VO")) {
            return "@C_Invoice_ID@ " + invoice.getDocumentNo() + " @Voided@";
        }
        if (this.getFiscalPrinterId() == 0) {
            this.setFiscalPrinterId(invoice.get_ValueAsInt("FiscalPrinter_ID"));
        } else if (invoice.get_ValueAsInt("FiscalPrinter_ID") <= 0) {
            invoice.set_ValueOfColumn("FiscalPrinter_ID", (Object)this.getFiscalPrinterId());
            invoice.saveEx();
        }
        if (this.getFiscalPrinterId() == 0) {
            throw new AdempiereException("@FiscalPrinter_ID@ @NotFound@");
        }
        MADAppRegistration registeredApplication = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getFiscalPrinterId(), (String)this.get_TrxName());
        IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(registeredApplication);
        if (supportedApplication != null && IFiscalPrinter.class.isAssignableFrom(supportedApplication.getClass())) {
            IFiscalPrinter fiscalPrinter = (IFiscalPrinter)supportedApplication;
            FiscalDocument fiscalDocument = new FiscalDocument(invoice);
            fiscalPrinter.printFiscalDocument(fiscalDocument);
        }
        return "Ok";
    }
}

