/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.AdempierePOSException;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_M_RMA;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.process.GenerateInvoiceFromSalesOrdersAndPrintAbstract;
import org.spin.process.InvoiceFiscalPrint;

public class GenerateInvoiceFromSalesOrdersAndPrint
extends GenerateInvoiceFromSalesOrdersAndPrintAbstract {
    private StringBuffer generatedDocuments = new StringBuffer();

    protected String doIt() throws Exception {
        boolean isOldRMA = this.getSelectionAsBoolean((Integer)this.getSelectionKeys().stream().findFirst().get(), "DT_IsShowRMA");
        int processId = 134;
        int tableId = I_C_Order.Table_ID;
        if (isOldRMA) {
            processId = 52002;
            tableId = I_M_RMA.Table_ID;
        }
        ProcessInfo processInfo = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(processId)).withParameter("DateInvoiced", (Object)this.getDateInvoiced()).withParameter("DocAction", (Object)this.getDocAction()).withParameter("ConsolidateDocument", (Object)this.isConsolidateDocument()).withParameter("C_DocTypeTarget_ID", (Object)this.getDocTypeId()).withSelectedRecordsIds(tableId, this.getSelectionKeys()).withoutTransactionClose().execute(this.get_TrxName());
        ArrayList<PO> documents = new ArrayList<PO>();
        if (processInfo != null) {
            if (processInfo.isError()) {
                throw new AdempiereException(processInfo.getSummary());
            }
            if (processInfo.getIDs() != null) {
                PO.getInstances((Integer)I_C_Invoice.Table_ID, Arrays.stream(processInfo.getIDs()).boxed().collect(Collectors.toList()), (String)this.get_TrxName()).forEach(invoice -> {
                    documents.add((PO)invoice);
                    this.addToMessage(((MInvoice)invoice).getDocumentNo());
                });
                this.sendToPrint(documents, true);
            }
        }
        return "@Created@ " + documents.size() + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void sendToPrint(List<PO> invoices, boolean askToPrint) {
        if (this.getParameterAsInt("FiscalPrinter_ID") > 0) {
            int fiscalPrinterId = this.getParameterAsInt("FiscalPrinter_ID");
            invoices.stream().map(entity -> (MInvoice)entity).forEach(invoice -> {
                ProcessInfo processInfo;
                MDocType documentType = MDocType.get((Properties)invoice.getCtx(), (int)invoice.getC_DocTypeTarget_ID());
                if (documentType.get_ValueAsBoolean("IsPrintedOnFiscalPrinter") && !documentType.get_ValueAsBoolean("IsPrintAfterComplete") && (processInfo = ProcessBuilder.create((Properties)invoice.getCtx()).process(Integer.valueOf(InvoiceFiscalPrint.getProcessId())).withParameter("FiscalPrinter_ID", (Object)fiscalPrinterId).withRecordId(Integer.valueOf(MInvoice.Table_ID), Integer.valueOf(invoice.getC_Invoice_ID())).execute(invoice.get_TrxName())).isError()) {
                    throw new AdempierePOSException(processInfo.getSummary());
                }
            });
        } else {
            this.printDocument(invoices, true);
        }
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }
}

