/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.MInvoice;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.model.MADAppRegistration;
import org.spin.process.FiscalDocumentAuthorizationAbstract;
import org.spin.process.InvoiceFiscalPrint;
import org.spin.util.text.DataUtils;

public class FiscalDocumentAuthorization
extends FiscalDocumentAuthorizationAbstract {
    private final String RE_PRINT = "R";
    private final String VOID = "V";
    private final String COMPLETE_DOCUMENT_WITHOUT_PRINTING = "C";
    private final String SET_FISCAL_DOCUMENT_INFO = "S";

    protected String doIt() throws Exception {
        MADAppRegistration registeredApplication;
        String customMessage = null;
        MInvoice invoice = new MInvoice(this.getCtx(), this.getInvoiceId(), this.get_TrxName());
        if (this.getFiscalPrinterId() <= 0) {
            this.setFiscalPrinterId(invoice.get_ValueAsInt("FiscalPrinter_ID"));
        }
        if (this.getAuthorizationType().equals("R")) {
            if (invoice.get_ValueAsBoolean("PrintFiscalDocument") && invoice.getDocStatus().equals("CO")) {
                registeredApplication = MADAppRegistration.getById((Properties)Env.getCtx(), (int)invoice.get_ValueAsInt("FiscalPrinter_ID"), (String)this.get_TrxName());
                invoice.set_ValueOfColumn("FiscalPrinter_ID", (Object)this.getFiscalPrinterId());
                invoice.set_ValueOfColumn("PrintFiscalDocument", (Object)"N");
                invoice.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@FiscalPrinter_ID@ (@OldValue@): ") + registeredApplication.getName());
                invoice.saveEx();
                ProcessInfo info = ProcessBuilder.create((Properties)invoice.getCtx()).process(Integer.valueOf(InvoiceFiscalPrint.getProcessId())).withRecordId(Integer.valueOf(I_C_Invoice.Table_ID), Integer.valueOf(invoice.getC_Invoice_ID())).withoutTransactionClose().execute(invoice.get_TrxName());
                if (info.isError()) {
                    customMessage = info.getSummary();
                }
            } else {
                throw new AdempiereException("@C_Invoice_ID@ " + invoice.getDocumentNo() + " @Invalid@");
            }
            customMessage = "@C_Invoice_ID@: " + invoice.getDocumentNo() + " @Updated@";
        }
        if (this.getAuthorizationType().equals("S")) {
            String printerSerialNo;
            if (invoice.getDocStatus().equals("CO")) {
                if (!Util.isEmpty((String)invoice.get_ValueAsString("FiscalDocumentNo"))) {
                    StringBuffer messageToTranslate = new StringBuffer();
                    messageToTranslate.append("@FiscalPrinter_ID@ (@Updated@) @OldValue@: ").append(Env.NL).append("@FiscalDocumentNo@: " + invoice.get_ValueAsString("FiscalDocumentNo"));
                    if (invoice.get_ValueAsInt("FiscalPrinter_ID") > 0) {
                        MADAppRegistration registeredApplication2 = MADAppRegistration.getById((Properties)Env.getCtx(), (int)invoice.get_ValueAsInt("FiscalPrinter_ID"), (String)this.get_TrxName());
                        messageToTranslate.append(Env.NL).append("@FiscalPrinter_ID@: " + registeredApplication2.getValue() + " - " + registeredApplication2.getName());
                    }
                    invoice.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)messageToTranslate.toString()));
                }
                invoice.set_ValueOfColumn("FiscalPrinter_ID", (Object)this.getFiscalPrinterId());
                invoice.set_ValueOfColumn("PrintFiscalDocument", (Object)"Y");
                invoice.set_ValueOfColumn("FiscalDocumentNo", (Object)this.getFiscalDocumentNo());
                invoice.set_ValueOfColumn("FiscalPrintDate", (Object)this.getFiscalPrintDate());
                registeredApplication = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getFiscalPrinterId(), (String)this.get_TrxName());
                printerSerialNo = Optional.ofNullable(registeredApplication.getValue()).orElse("");
                if (printerSerialNo.length() > 4) {
                    printerSerialNo = printerSerialNo.substring(printerSerialNo.length() - 4);
                }
            } else {
                throw new AdempiereException("@C_Invoice_ID@ " + invoice.getDocumentNo() + " @Invalid@");
            }
            String completefiscalDocumentNo = DataUtils.leftPadding((String)printerSerialNo, (int)4, (String)"0") + "-" + this.getFiscalDocumentNo();
            invoice.setDocumentNo(completefiscalDocumentNo);
            customMessage = "@C_Invoice_ID@: " + invoice.getDocumentNo() + " @Updated@";
        } else if (this.getAuthorizationType().equals("V")) {
            invoice.set_ValueOfColumn("IsVoidedFiscalPrint", (Object)true);
            invoice.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)"@IsVoidedFiscalPrint@"));
            invoice.saveEx();
            if (!invoice.processIt("RC")) {
                throw new AdempiereException("@Error@: " + invoice.getProcessMsg());
            }
            invoice.saveEx();
        } else if (this.getAuthorizationType().equals("C")) {
            if (this.getFiscalPrinterId() <= 0) {
                throw new AdempiereException("@FiscalPrinter_ID@ @NotFound@");
            }
            if (!(invoice.getDocStatus().equals("DR") || invoice.getDocStatus().equals("IP") || invoice.getDocStatus().equals("IN") || invoice.getDocStatus().equals("NA"))) {
                throw new AdempiereException("@C_Invoice_ID@ " + invoice.getDocumentNo() + " @Invalid@");
            }
            invoice.setDocStatus("IP");
            invoice.set_ValueOfColumn("FiscalPrinter_ID", (Object)this.getFiscalPrinterId());
            invoice.saveEx();
            if (!invoice.processIt("CO")) {
                throw new AdempiereException("@Error@: " + invoice.getProcessMsg());
            }
            customMessage = "@C_Invoice_ID@: " + invoice.getDocumentNo() + " @Completed@";
        } else {
            throw new AdempiereException("@ActionNotSupported@");
        }
        invoice.saveEx();
        this.addLog(this.getInvoiceId(), invoice.getDateInvoiced(), invoice.getGrandTotal(), invoice.getDocumentNo());
        return customMessage;
    }
}

