/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model.validator;

import java.util.Properties;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPOS;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.process.InvoiceFiscalPrint;

public class FiscalPrinter
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(FiscalPrinter.class);
    private int clientId = 0;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_Invoice", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (type == 1 || type == 2) {
            MInvoice invoice;
            log.fine(" TYPE_BEFORE_NEW || TYPE_BEFORE_CHANGE");
            if (po.get_TableName().equals("C_Invoice") && (invoice = (MInvoice)po).is_ValueChanged("C_DocTypeTarget_ID") && invoice.isSOTrx()) {
                MDocType documentType = MDocType.get((Properties)invoice.getCtx(), (int)invoice.getC_DocTypeTarget_ID());
                invoice.set_ValueOfColumn("IsPrintedOnFiscalPrinter", (Object)documentType.get_ValueAsBoolean("IsPrintedOnFiscalPrinter"));
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing == 5 || timing == 2) {
            MInvoice invoice;
            log.fine(" TIMING_BEFORE_REVERSECORRECT || TIMING_BEFORE_VOID");
            if (po.get_TableName().equals("C_Invoice") && (invoice = (MInvoice)po).get_ValueAsInt("FiscalPrinter_ID") != 0 && !invoice.get_ValueAsBoolean("IsVoidedFiscalPrint")) {
                return Msg.parseTranslation((Properties)Env.getCtx(), (String)"@C_Invoice_ID@ @IsPrinted@");
            }
        } else if (timing == 7) {
            MInvoice invoice;
            log.fine(" TIMING_AFTER_COMPLETE");
            if (po.get_TableName().equals("C_Invoice") && !(invoice = (MInvoice)po).isReversal() && invoice.isSOTrx()) {
                MPOS posConfiguration;
                int fiscalPrinterId;
                MDocType documentType;
                int posId = invoice.getC_POS_ID();
                if (posId == 0 && invoice.getC_Order_ID() != 0) {
                    posId = invoice.getC_Order().getC_POS_ID();
                }
                if (posId != 0 && (documentType = MDocType.get((Properties)invoice.getCtx(), (int)invoice.getC_DocTypeTarget_ID())).get_ValueAsBoolean("IsPrintedOnFiscalPrinter") && (fiscalPrinterId = (posConfiguration = MPOS.get((Properties)invoice.getCtx(), (int)posId)).get_ValueAsInt("FiscalPrinter_ID")) != 0) {
                    invoice.set_ValueOfColumn("FiscalPrinter_ID", (Object)fiscalPrinterId);
                    invoice.setC_POS_ID(posId);
                    invoice.saveEx();
                }
            }
        } else if (timing == 9) {
            ProcessInfo info;
            MDocType documentType;
            MInvoice invoice;
            log.fine(" TIMING_AFTER_COMPLETE");
            if (po.get_TableName().equals("C_Invoice") && !(invoice = (MInvoice)po).isReversal() && invoice.isSOTrx() && (documentType = MDocType.get((Properties)invoice.getCtx(), (int)invoice.getC_DocTypeTarget_ID())).get_ValueAsBoolean("IsPrintedOnFiscalPrinter") && documentType.get_ValueAsBoolean("IsPrintAfterComplete") && (info = ProcessBuilder.create((Properties)invoice.getCtx()).process(Integer.valueOf(InvoiceFiscalPrint.getProcessId())).withRecordId(Integer.valueOf(I_C_Invoice.Table_ID), Integer.valueOf(invoice.getC_Invoice_ID())).withoutTransactionClose().execute(invoice.get_TrxName())).isError()) {
                return info.getSummary();
            }
        }
        return null;
    }
}

