/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.spin.grpc.util.PrinterResponse;
import org.spin.model.X_FP_Log;
import org.spin.support.fp.IFiscalPrinterResponse;

public class MFPLog
extends X_FP_Log {
    private static final long serialVersionUID = -6567259664214576293L;

    public MFPLog(Properties ctx, int FP_Log_ID, String trxName) {
        super(ctx, FP_Log_ID, trxName);
    }

    public MFPLog(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFPLog addToLog(Properties context, PrinterResponse fiscalPrinterResponse, String additionalError, String transactionName) {
        if (!Optional.ofNullable(fiscalPrinterResponse).isPresent()) {
            return null;
        }
        MFPLog log = new MFPLog(context, 0, transactionName);
        Optional.ofNullable(fiscalPrinterResponse.getDocumentUuid()).ifPresent(documentUuid -> log.setFiscalDocumentUUID((String)documentUuid));
        Optional.ofNullable(fiscalPrinterResponse.getFiscalPrinterNo()).ifPresent(fiscalPrinterCode -> log.setFiscalPrinterCode((String)fiscalPrinterCode));
        Optional.ofNullable(fiscalPrinterResponse.getLastInvoiceNo()).ifPresent(lastInvoiceNo -> log.setLastFiscalInvoiceNo((String)lastInvoiceNo));
        Optional.ofNullable(fiscalPrinterResponse.getLastCreditMemoNo()).ifPresent(lastCreditMemoNo -> log.setLastFiscalCreditMemoNo((String)lastCreditMemoNo));
        Optional.ofNullable(fiscalPrinterResponse.getPrinterName()).ifPresent(printerName -> log.setFiscalPrinterName((String)printerName));
        Optional.ofNullable(fiscalPrinterResponse.getResult()).ifPresent(result -> log.addFiscalPrinterResult((String)result));
        Optional.ofNullable(additionalError).ifPresent(result -> log.addFiscalPrinterResult((String)result));
        log.setIsError(fiscalPrinterResponse.getIsError());
        if (fiscalPrinterResponse.getPrintDate() > 0L) {
            log.setFiscalPrintDate(new Timestamp(fiscalPrinterResponse.getPrintDate()));
        }
        log.saveEx();
        return log;
    }

    public static MFPLog addToLog(Properties context, IFiscalPrinterResponse fiscalPrinterResponse, String additionalError, String transactionName) {
        if (!Optional.ofNullable(fiscalPrinterResponse).isPresent()) {
            return null;
        }
        MFPLog log = new MFPLog(context, 0, transactionName);
        Optional.ofNullable(fiscalPrinterResponse.getDocumentUuid()).ifPresent(documentUuid -> log.setFiscalDocumentUUID((String)documentUuid));
        Optional.ofNullable(fiscalPrinterResponse.getFiscalPrinterSerialNo()).ifPresent(fiscalPrinterCode -> log.setFiscalPrinterCode((String)fiscalPrinterCode));
        Optional.ofNullable(fiscalPrinterResponse.getDocumentNo()).ifPresent(lastInvoiceNo -> log.setLastFiscalInvoiceNo((String)lastInvoiceNo));
        Optional.ofNullable(fiscalPrinterResponse.getDocumentNo()).ifPresent(lastCreditMemoNo -> log.setLastFiscalCreditMemoNo((String)lastCreditMemoNo));
        Optional.ofNullable(fiscalPrinterResponse.getPrinterName()).ifPresent(printerName -> log.setFiscalPrinterName((String)printerName));
        Optional.ofNullable(fiscalPrinterResponse.getErrorMessage()).ifPresent(result -> log.addFiscalPrinterResult((String)result));
        Optional.ofNullable(additionalError).ifPresent(result -> log.addFiscalPrinterResult((String)result));
        log.setIsError(fiscalPrinterResponse.getIsError());
        if (fiscalPrinterResponse.getPrintDate() != null) {
            log.setFiscalPrintDate(fiscalPrinterResponse.getPrintDate());
        }
        log.saveEx();
        return log;
    }

    public void addFiscalPrinterResult(String result) {
        String currentResult = this.getFiscalPrinterResult();
        if (currentResult == null) {
            this.setFiscalPrinterResult(result);
        } else {
            this.setFiscalPrinterResult(currentResult + " | " + result);
        }
    }

    @Override
    public String toString() {
        return "MFPLog [getFiscalDocumentNo()=" + this.getFiscalDocumentNo() + ", getFiscalDocumentUUID()=" + this.getFiscalDocumentUUID() + ", getFiscalPrintDate()=" + this.getFiscalPrintDate() + ", getFiscalPrinterName()=" + this.getFiscalPrinterName() + ", getFiscalPrinterResult()=" + this.getFiscalPrinterResult() + ", getFP_Log_ID()=" + this.getFP_Log_ID() + ", getUUID()=" + this.getUUID() + "]";
    }
}

