/*
 * Decompiled with CFR 0.152.
 */
package org.spin.fp.setup;

import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MProcess;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.Query;
import org.compiere.util.TimeUtil;
import org.spin.process.ReadFiscalPrinter;
import org.spin.util.ISetupDefinition;

public class FiscalPrinterReader
implements ISetupDefinition {
    private static final String SETUP_DESCRIPTION = "(*Created from Setup Automatically*)";

    public String doIt(Properties context, String transactionName) {
        this.createSchedule(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createSchedule(Properties context, String transactionName) {
        new Query(context, "AD_Scheduler", "AD_Process_ID = ?", transactionName).setParameters(new Object[]{ReadFiscalPrinter.getProcessId()}).setClient_ID().list().forEach(scheduler -> scheduler.deleteEx(true));
        MScheduler scheduler2 = new MScheduler(context, 0, transactionName);
        scheduler2.setAD_Org_ID(0);
        scheduler2.setName(ReadFiscalPrinter.getProcessName());
        scheduler2.setDescription(SETUP_DESCRIPTION);
        scheduler2.setAD_Process_ID(ReadFiscalPrinter.getProcessId());
        scheduler2.setSupervisor_ID(100);
        scheduler2.setFrequencyType("M");
        scheduler2.setFrequency(5);
        scheduler2.setKeepLogDays(7);
        scheduler2.setDateNextRun(TimeUtil.addMinutess((Timestamp)TimeUtil.getDay((long)System.currentTimeMillis()), (int)scheduler2.getFrequency()));
        scheduler2.saveEx();
        MProcess process = MProcess.get((Properties)context, (int)ReadFiscalPrinter.getProcessId());
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("FiscalPrinter_ID")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("Fill it Please");
            schedulerParameter.saveEx();
        });
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("IsReadAllQueues")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("'Y'");
            schedulerParameter.saveEx();
        });
    }
}

