/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$KEY$;
import kafka.log.IndexSearchType$VALUE$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.Logging;
import kafka.utils.Logging$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\u0012%\u0001%B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\no\u0001\u0011\t\u0011)A\u0005qyB\u0011b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001Q\"\t\u0013\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0005\"B%\u0001\t\u0003Q\u0005b\u0002)\u0001\u0001\u0004%I!\u0015\u0005\b+\u0002\u0001\r\u0011\"\u0003W\u0011\u0019a\u0006\u0001)Q\u0005%\")\u0011\r\u0001C!E\")1\r\u0001C!I\")Q\r\u0001C\u0005M\")\u0011\u000f\u0001C\u0005e\")Q\u000f\u0001C\u0001#\")a\u000f\u0001C\u0005#\")q\u000f\u0001C\u0001q\")!\u0010\u0001C!w\")a\u0010\u0001C\u0001\u007f\"I\u00111\u0002\u0001\u0012\u0002\u0013\u0005\u0011Q\u0002\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011Q\t\u0001\u0005B\u00055\u0002\u0002DA$\u0001A\u0005\u0019\u0011!A\u0005\n\t\u001c\u0005\"DA%\u0001A\u0005\u0019\u0011!A\u0005\n\u0005-c\b\u0003\b\u0002N\u0001\u0001\n1!A\u0001\n\u0013\ty%a\u0015\b\u000f\u0005UC\u0005#\u0001\u0002X\u001911\u0005\nE\u0001\u00033Ba!S\u000f\u0005\u0002\u00055\u0004\"CA8;\t\u0007I\u0011IA9\u0011!\tI)\bQ\u0001\n\u0005M\u0004\"CAF;E\u0005I\u0011AAG\u0011%\t\t*HI\u0001\n\u0003\tiAA\u0005US6,\u0017J\u001c3fq*\u0011QEJ\u0001\u0004Y><'\"A\u0014\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u000b\t\u0003W1j\u0011\u0001J\u0005\u0003[\u0011\u0012Q\"\u00112tiJ\f7\r^%oI\u0016D\u0018!B0gS2,\u0007C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\tIwNC\u00015\u0003\u0011Q\u0017M^1\n\u0005Y\n$\u0001\u0002$jY\u0016\f!BY1tK>3gm]3u!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0011auN\\4\n\u0005]b\u0013\u0001D7bq&sG-\u001a=TSj,\u0007CA\u001dB\u0013\t\u0011%HA\u0002J]RL!a\u0010\u0017\u0002\u0011]\u0014\u0018\u000e^1cY\u0016\u0004\"!\u000f$\n\u0005\u001dS$a\u0002\"p_2,\u0017M\\\u0005\u0003\t2\na\u0001P5oSRtD#B&M\u001b:{\u0005CA\u0016\u0001\u0011\u0015qS\u00011\u00010\u0011\u00159T\u00011\u00019\u0011\u001dyT\u0001%AA\u0002\u0001Cq\u0001R\u0003\u0011\u0002\u0003\u0007Q)\u0001\u0006`Y\u0006\u001cH/\u00128uef,\u0012A\u0015\t\u0003WMK!\u0001\u0016\u0013\u0003\u001fQKW.Z:uC6\u0004xJ\u001a4tKR\fab\u00187bgR,e\u000e\u001e:z?\u0012*\u0017\u000f\u0006\u0002X5B\u0011\u0011\bW\u0005\u00033j\u0012A!\u00168ji\"91lBA\u0001\u0002\u0004\u0011\u0016a\u0001=%c\u0005Yq\f\\1ti\u0016sGO]=!Q\tAa\f\u0005\u0002:?&\u0011\u0001M\u000f\u0002\tm>d\u0017\r^5mK\u0006IQM\u001c;ssNK'0Z\u000b\u0002\u0001\u00061\u0011n\u001d$vY2,\u0012!R\u0001\ni&lWm\u001d;b[B$2\u0001O4p\u0011\u0015A7\u00021\u0001j\u0003\u0019\u0011WO\u001a4feB\u0011!.\\\u0007\u0002W*\u0011AnM\u0001\u0004]&|\u0017B\u00018l\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006a.\u0001\r\u0001Q\u0001\u0002]\u0006q!/\u001a7bi&4Xm\u00144gg\u0016$Hc\u0001!ti\")\u0001\u000e\u0004a\u0001S\")\u0001\u000f\u0004a\u0001\u0001\u0006IA.Y:u\u000b:$(/_\u0001\u0017Y\u0006\u001cH/\u00128uef4%o\\7J]\u0012,\u0007PR5mK\u0006)QM\u001c;ssR\u0011!+\u001f\u0005\u0006a>\u0001\r\u0001Q\u0001\u000ba\u0006\u00148/Z#oiJLHc\u0001*}{\")\u0001\u000e\u0005a\u0001S\")\u0001\u000f\u0005a\u0001\u0001\u0006YQ.Y=cK\u0006\u0003\b/\u001a8e)\u001d9\u0016\u0011AA\u0002\u0003\u000fAQ!Z\tA\u0002aBa!!\u0002\u0012\u0001\u0004A\u0014AB8gMN,G\u000f\u0003\u0005\u0002\nE\u0001\n\u00111\u0001F\u00035\u00198.\u001b9Gk2d7\t[3dW\u0006)R.Y=cK\u0006\u0003\b/\u001a8eI\u0011,g-Y;mi\u0012\u001aTCAA\bU\r)\u0015\u0011C\u0016\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0004\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\"\u0005]!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061An\\8lkB$2AUA\u0014\u0011\u0019\tIc\u0005a\u0001q\u0005yA/\u0019:hKR$\u0016.\\3ti\u0006l\u0007/\u0001\u0005ueVt7-\u0019;f)\u00059\u0016A\u0003;sk:\u001c\u0017\r^3U_R\u0019q+a\r\t\r\u0005\u0015Q\u00031\u00019\u0003\u0019\u0011Xm]5{KR\u0019Q)!\u000f\t\r\u0005mb\u00031\u0001A\u0003\u001dqWm^*ju\u0016\f\u0011\u0003\u001e:v]\u000e\fG/\u001a+p\u000b:$(/[3t)\r9\u0016\u0011\t\u0005\u0007\u0003\u0007:\u0002\u0019\u0001!\u0002\u000f\u0015tGO]5fg\u0006Y1/\u00198jif\u001c\u0005.Z2l\u0003I\u0019X\u000f]3sI5\f\u00070\u00138eKb\u001c\u0016N_3\u0002!M,\b/\u001a:%E\u0006\u001cXm\u00144gg\u0016$X#\u0001\u001d\u0002\u0019M,\b/\u001a:%e\u0016\u001c\u0018N_3\u0015\u0007\u0015\u000b\t\u0006\u0003\u0004\u0002<m\u0001\r\u0001Q\u0005\u0004\u0003ka\u0013!\u0003+j[\u0016Le\u000eZ3y!\tYSdE\u0003\u001e\u00037\n\t\u0007E\u0002:\u0003;J1!a\u0018;\u0005\u0019\te.\u001f*fMB!\u00111MA5\u001b\t\t)GC\u0002\u0002h\u0019\nQ!\u001e;jYNLA!a\u001b\u0002f\t9Aj\\4hS:<GCAA,\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003g\u0002B!!\u001e\u0002\u0004:!\u0011qOA@!\r\tIHO\u0007\u0003\u0003wR1!! )\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0011\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\t))a\"\u0003\rM#(/\u001b8h\u0015\r\t\tIO\u0001\fY><w-\u001a:OC6,\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001fS3\u0001QA\t\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class TimeIndex
extends AbstractIndex {
    private volatile TimestampOffset _lastEntry = this.lastEntryFromIndexFile();

    public static boolean $lessinit$greater$default$4() {
        return true;
    }

    public static int $lessinit$greater$default$3() {
        return -1;
    }

    public static String loggerName() {
        return TimeIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$ fatal_this = TimeIndex$.MODULE$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var3_3 = null;
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(fatal_this, msgWithLogIdent_msg), (Throwable)function02.apply());
            return;
        }
    }

    public static void fatal(Function0<String> function0) {
        TimeIndex$ fatal_this = TimeIndex$.MODULE$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var2_2 = null;
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), Logging.msgWithLogIdent$(fatal_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$ error_this = TimeIndex$.MODULE$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var3_3 = null;
            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg), (Throwable)function02.apply());
            return;
        }
    }

    public static void error(Function0<String> function0) {
        TimeIndex$ error_this = TimeIndex$.MODULE$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var2_2 = null;
            error_this.logger().underlying().error(Logging.msgWithLogIdent$(error_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$ warn_this = TimeIndex$.MODULE$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var3_3 = null;
            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg), (Throwable)function02.apply());
            return;
        }
    }

    public static void warn(Function0<String> function0) {
        TimeIndex$ warn_this = TimeIndex$.MODULE$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var2_2 = null;
            warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$ info_this = TimeIndex$.MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var3_3 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg), (Throwable)function02.apply());
            return;
        }
    }

    public static void info(Function0<String> function0) {
        TimeIndex$ info_this = TimeIndex$.MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var2_2 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$ debug_this = TimeIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var3_3 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg), (Throwable)function02.apply());
            return;
        }
    }

    public static void debug(Function0<String> function0) {
        TimeIndex$ debug_this = TimeIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var2_2 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(TimeIndex$.MODULE$);
    }

    public static boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(TimeIndex$.MODULE$);
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$ trace_this = TimeIndex$.MODULE$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var3_3 = null;
            trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg), (Throwable)function02.apply());
            return;
        }
    }

    public static void trace(Function0<String> function0) {
        TimeIndex$ trace_this = TimeIndex$.MODULE$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            String msgWithLogIdent_msg = (String)function0.apply();
            Object var2_2 = null;
            trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg));
            return;
        }
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    private /* synthetic */ boolean super$resize(int newSize) {
        return super.resize(newSize);
    }

    private TimestampOffset _lastEntry() {
        return this._lastEntry;
    }

    private void _lastEntry_$eq(TimestampOffset x$1) {
        this._lastEntry = x$1;
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return this._lastEntry();
    }

    private TimestampOffset lastEntryFromIndexFile() {
        TimestampOffset timestampOffset;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            timestampOffset = TimeIndex.$anonfun$lastEntryFromIndexFile$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return timestampOffset;
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(48).append("Attempt to fetch the ").append(n).append("th entry from  time index ").append(this.file().getAbsolutePath()).append(" ").toString()).append(new StringBuilder(16).append("which has size ").append(this._entries()).append(".").toString()).toString());
            }
            return this.parseEntry(this.mmap(), n);
        });
    }

    @Override
    public TimestampOffset parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            TimeIndex.$anonfun$maybeAppend$1(this, skipFullCheck, offset, timestamp);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetTimestamp, IndexSearchType$KEY$.MODULE$);
            if (slot == -1) {
                return new TimestampOffset(-1L, this.super$baseOffset());
            }
            return this.parseEntry(idx, slot);
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            TimeIndex.$anonfun$truncateTo$1(this, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public boolean resize(int newSize) {
        boolean bl;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            bl = TimeIndex.$anonfun$resize$1(this, newSize);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    private void truncateToEntries(int entries) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            TimeIndex.$anonfun$truncateToEntries$1(this, entries);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    @Override
    public void sanityCheck() {
        long lastTimestamp = this.lastEntry().timestamp();
        long lastOffset = this.lastEntry().offset();
        if (this._entries() != 0 && lastTimestamp < this.timestamp(this.mmap(), 0)) {
            throw new CorruptIndexException(new StringBuilder(0).append(new StringBuilder(49).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").toString()).append(new StringBuilder(80).append("non-zero size but the last timestamp is ").append(lastTimestamp).append(" which is less than the first timestamp ").toString()).append(String.valueOf(BoxesRunTime.boxToLong((long)this.timestamp(this.mmap(), 0)))).toString());
        }
        if (this._entries() != 0 && lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder(0).append(new StringBuilder(49).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").toString()).append(new StringBuilder(74).append("non-zero size but the last offset is ").append(lastOffset).append(" which is less than the first offset ").append(super.baseOffset()).toString()).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder(0).append(new StringBuilder(42).append("Time index file ").append(this.file().getAbsolutePath()).append(" is corrupt, found ").append(this.length()).append(" bytes ").toString()).append(new StringBuilder(45).append("which is neither positive nor a multiple of ").append(this.entrySize()).append(".").toString()).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$new$1(TimeIndex $this) {
        return new StringBuilder(0).append(new StringBuilder(55).append("Loaded index file ").append($this.file().getAbsolutePath()).append(" with maxEntries = ").append($this.maxEntries()).append(", maxIndexSize = ").append($this.super$maxIndexSize()).append(",").toString()).append(new StringBuilder(44).append(" entries = ").append($this._entries()).append(", lastOffset = ").append($this._lastEntry()).append(", file position = ").append($this.mmap().position()).toString()).toString();
    }

    public static final /* synthetic */ TimestampOffset $anonfun$lastEntryFromIndexFile$1(TimeIndex $this) {
        int n = $this._entries();
        switch (n) {
            case 0: {
                return new TimestampOffset(-1L, $this.super$baseOffset());
            }
        }
        return $this.parseEntry($this.mmap(), n - 1);
    }

    public static final /* synthetic */ String $anonfun$maybeAppend$3(TimeIndex $this, long timestamp$1, long offset$1) {
        return new StringBuilder(28).append("Adding index entry ").append(timestamp$1).append(" => ").append(offset$1).append(" to ").append($this.file().getAbsolutePath()).append(".").toString();
    }

    public static final /* synthetic */ void $anonfun$maybeAppend$1(TimeIndex $this, boolean skipFullCheck$1, long offset$1, long timestamp$1) {
        if (!skipFullCheck$1) {
            Predef$.MODULE$.require(!$this.isFull(), (Function0 & Serializable)() -> new StringBuilder(49).append("Attempt to append to a full time index (size = ").append($this._entries()).append(").").toString());
        }
        if ($this._entries() != 0 && offset$1 < $this.lastEntry().offset()) {
            throw new InvalidOffsetException(new StringBuilder(0).append(new StringBuilder(54).append("Attempt to append an offset (").append(offset$1).append(") to slot ").append($this._entries()).append(" no larger than").toString()).append(new StringBuilder(33).append(" the last offset appended (").append($this.lastEntry().offset()).append(") to ").append($this.file().getAbsolutePath()).append(".").toString()).toString());
        }
        if ($this._entries() != 0 && timestamp$1 < $this.lastEntry().timestamp()) {
            throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(51).append("Attempt to append a timestamp (").append(timestamp$1).append(") to slot ").append($this._entries()).append(" no larger").toString()).append(new StringBuilder(41).append(" than the last timestamp appended (").append($this.lastEntry().timestamp()).append(") to ").append($this.file().getAbsolutePath()).append(".").toString()).toString());
        }
        if (timestamp$1 > $this.lastEntry().timestamp()) {
            TimeIndex$ trace_this = TimeIndex$.MODULE$;
            if (trace_this.logger().underlying().isTraceEnabled()) {
                String msgWithLogIdent_msg = TimeIndex.$anonfun$maybeAppend$3($this, timestamp$1, offset$1);
                Object var7_5 = null;
                trace_this.logger().underlying().trace(Logging.msgWithLogIdent$(trace_this, msgWithLogIdent_msg));
            }
            Object var6_4 = null;
            $this.mmap().putLong(timestamp$1);
            $this.mmap().putInt($this.relativeOffset(offset$1));
            $this._entries_$eq($this._entries() + 1);
            $this._lastEntry_$eq(new TimestampOffset(timestamp$1, offset$1));
            Predef$.MODULE$.require($this._entries() * $this.entrySize() == $this.mmap().position(), (Function0 & Serializable)() -> new StringBuilder(40).append($this._entries()).append(" entries but file position in index is ").append($this.mmap().position()).append(".").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$truncateTo$1(TimeIndex $this, long offset$2) {
        ByteBuffer idx = $this.mmap().duplicate();
        int slot = $this.largestLowerBoundSlotFor(idx, offset$2, IndexSearchType$VALUE$.MODULE$);
        int newEntries = slot < 0 ? 0 : ((long)$this.relativeOffset(idx, slot) == offset$2 - $this.super$baseOffset() ? slot : slot + 1);
        $this.truncateToEntries(newEntries);
    }

    public static final /* synthetic */ boolean $anonfun$resize$1(TimeIndex $this, int newSize$1) {
        if ($this.super$resize(newSize$1)) {
            $this._lastEntry_$eq($this.lastEntryFromIndexFile());
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$truncateToEntries$2(TimeIndex $this, int entries$1) {
        return new StringBuilder(69).append("Truncated index ").append($this.file().getAbsolutePath()).append(" to ").append(entries$1).append(" entries; position is now ").append($this.mmap().position()).append(" and last entry is now ").append($this._lastEntry()).toString();
    }

    public static final /* synthetic */ void $anonfun$truncateToEntries$1(TimeIndex $this, int entries$1) {
        $this._entries_$eq(entries$1);
        $this.mmap().position($this._entries() * $this.entrySize());
        $this._lastEntry_$eq($this.lastEntryFromIndexFile());
        TimeIndex$ debug_this = TimeIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = TimeIndex.$anonfun$truncateToEntries$2($this, entries$1);
            Object var3_3 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        TimeIndex$ debug_this = TimeIndex$.MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = TimeIndex.$anonfun$new$1(this);
            Object var7_6 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
            return;
        }
    }
}

