/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.controller.ControllerContext;
import kafka.controller.ElectionResult;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Election$ {
    public static final Election$ MODULE$ = new Election$();

    private ElectionResult leaderForOffline(TopicPartition partition, Option<LeaderAndIsr> leaderAndIsrOpt, boolean uncleanLeaderElectionEnabled, ControllerContext controllerContext) {
        ElectionResult electionResult;
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        if (leaderAndIsrOpt instanceof Some) {
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Some)leaderAndIsrOpt).value();
            List<Object> isr = leaderAndIsr.isr();
            Option newLeaderAndIsrOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet(), uncleanLeaderElectionEnabled, controllerContext).map((Function1 & Serializable)leader -> Election$.$anonfun$leaderForOffline$2(isr, controllerContext, partition, leaderAndIsr, BoxesRunTime.unboxToInt((Object)leader)));
            electionResult = new ElectionResult(partition, (Option<LeaderAndIsr>)newLeaderAndIsrOpt, (Seq<Object>)liveReplicas);
        } else if (None$.MODULE$.equals(leaderAndIsrOpt)) {
            electionResult = new ElectionResult(partition, (Option<LeaderAndIsr>)None$.MODULE$, (Seq<Object>)liveReplicas);
        } else {
            throw new MatchError(leaderAndIsrOpt);
        }
        return electionResult;
    }

    public Seq<ElectionResult> leaderForOffline(ControllerContext controllerContext, Seq<Tuple3<TopicPartition, Option<LeaderAndIsr>, Object>> partitionsWithUncleanLeaderElectionState) {
        return (Seq)partitionsWithUncleanLeaderElectionState.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            Option leaderAndIsrOpt = (Option)x0$1._2();
            boolean uncleanLeaderElectionEnabled = BoxesRunTime.unboxToBoolean((Object)x0$1._3());
            ElectionResult electionResult = MODULE$.leaderForOffline(partition, (Option<LeaderAndIsr>)leaderAndIsrOpt, uncleanLeaderElectionEnabled, controllerContext);
            return electionResult;
        });
    }

    private ElectionResult leaderForReassign(TopicPartition partition, LeaderAndIsr leaderAndIsr, ControllerContext controllerContext) {
        Seq<Object> targetReplicas = controllerContext.partitionFullReplicaAssignment(partition).targetReplicas();
        Seq liveReplicas = (Seq)targetReplicas.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        List<Object> isr = leaderAndIsr.isr();
        Option newLeaderAndIsrOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(targetReplicas, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet()).map((Function1 & Serializable)leader -> leaderAndIsr.newLeader(BoxesRunTime.unboxToInt((Object)leader)));
        return new ElectionResult(partition, (Option<LeaderAndIsr>)newLeaderAndIsrOpt, targetReplicas);
    }

    public Seq<ElectionResult> leaderForReassign(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs) {
        return (Seq)leaderAndIsrs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            ElectionResult electionResult = MODULE$.leaderForReassign(partition, leaderAndIsr, controllerContext);
            return electionResult;
        });
    }

    private ElectionResult leaderForPreferredReplica(TopicPartition partition, LeaderAndIsr leaderAndIsr, ControllerContext controllerContext) {
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, controllerContext.isReplicaOnline$default$3()));
        List<Object> isr = leaderAndIsr.isr();
        Option newLeaderAndIsrOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveReplicas.toSet()).map((Function1 & Serializable)leader -> leaderAndIsr.newLeader(BoxesRunTime.unboxToInt((Object)leader)));
        return new ElectionResult(partition, (Option<LeaderAndIsr>)newLeaderAndIsrOpt, assignment);
    }

    public Seq<ElectionResult> leaderForPreferredReplica(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs) {
        return (Seq)leaderAndIsrs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            ElectionResult electionResult = MODULE$.leaderForPreferredReplica(partition, leaderAndIsr, controllerContext);
            return electionResult;
        });
    }

    private ElectionResult leaderForControlledShutdown(TopicPartition partition, LeaderAndIsr leaderAndIsr, Set<Object> shuttingDownBrokerIds, ControllerContext controllerContext) {
        Seq<Object> assignment = controllerContext.partitionReplicaAssignment(partition);
        Seq liveOrShuttingDownReplicas = (Seq)assignment.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> controllerContext.isReplicaOnline(replica, partition, true));
        List<Object> isr = leaderAndIsr.isr();
        Option<Object> leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, (Seq<Object>)isr, (Set<Object>)liveOrShuttingDownReplicas.toSet(), shuttingDownBrokerIds);
        List newIsr = isr.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> !shuttingDownBrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)replica)));
        Option newLeaderAndIsrOpt = leaderOpt.map((Function1 & Serializable)leader -> leaderAndIsr.newLeaderAndIsr(BoxesRunTime.unboxToInt((Object)leader), (List<Object>)newIsr));
        return new ElectionResult(partition, (Option<LeaderAndIsr>)newLeaderAndIsrOpt, (Seq<Object>)liveOrShuttingDownReplicas);
    }

    public Seq<ElectionResult> leaderForControlledShutdown(ControllerContext controllerContext, Seq<Tuple2<TopicPartition, LeaderAndIsr>> leaderAndIsrs) {
        Set shuttingDownBrokerIds = controllerContext.shuttingDownBrokerIds().toSet();
        return (Seq)leaderAndIsrs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$1._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
            ElectionResult electionResult = MODULE$.leaderForControlledShutdown(partition, leaderAndIsr, (Set<Object>)shuttingDownBrokerIds, controllerContext);
            return electionResult;
        });
    }

    public static final /* synthetic */ LeaderAndIsr $anonfun$leaderForOffline$2(List isr$1, ControllerContext controllerContext$1, TopicPartition partition$1, LeaderAndIsr leaderAndIsr$1, int leader) {
        List newIsr = isr$1.contains((Object)BoxesRunTime.boxToInteger((int)leader)) ? isr$1.filter((Function1)(JFunction1.mcZI.sp & Serializable)replica -> controllerContext$1.isReplicaOnline(replica, partition$1, controllerContext$1.isReplicaOnline$default$3())) : (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader}));
        return leaderAndIsr$1.newLeaderAndIsr(leader, (List<Object>)newIsr);
    }

    private Election$() {
    }
}

