/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util.exp;

import java.io.File;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocation;
import org.compiere.model.MOrgInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.util.ExportFormatCSV;

public class PaezImpuestoMunicipal_TXT
extends ExportFormatCSV {
    private static CLogger log = CLogger.getCLogger(PaezImpuestoMunicipal_TXT.class);
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String CRLF = "\r\n";

    public PaezImpuestoMunicipal_TXT(Properties ctx, ReportEngine reportEngine) {
        super(ctx, reportEngine);
    }

    public String getExtension() {
        return "txt";
    }

    public String getName() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"FileIMPaezTXT");
    }

    public boolean exportToFile(File file) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        return this.createTXTFile(this.convertFile(file), this.getReportEngine());
    }

    private boolean createTXTFile(Writer writer, ReportEngine engine) {
        try {
            int startAt = 0;
            PrintData printData = engine != null ? engine.getPrintData() : this.getPrintData();
            MPrintFormat printFormat = engine != null ? engine.getPrintFormat() : this.getPrintFormat();
            List<MPrintFormatItem> printFormatItems = Arrays.asList(printFormat.getItems());
            boolean firstLine = true;
            for (int row = startAt; row < printData.getRowCount(); ++row) {
                StringBuffer buffer = new StringBuffer();
                if (row != -1) {
                    printData.setRowIndex(row);
                }
                AtomicBoolean isFirstColumn = new AtomicBoolean(true);
                printFormatItems.stream().filter(printFormatItem -> printFormatItem.isPrinted()).forEach(printFormatItem -> {
                    String columnName = Optional.ofNullable(printFormatItem.getColumnName()).orElse("");
                    Object valueOfItem = printData.getNode(new Integer(printFormatItem.getAD_Column_ID()));
                    String data = "";
                    if (valueOfItem == null) {
                        if (printFormatItem.getPrintFormatType().equals("T") && !Util.isEmpty((String)printFormatItem.getPrintName())) {
                            data = printFormatItem.getPrintName() + (!Util.isEmpty((String)printFormatItem.getPrintNameSuffix()) ? printFormatItem.getPrintNameSuffix() : "");
                        }
                    } else if (valueOfItem instanceof PrintDataElement) {
                        PrintDataElement dataElement = (PrintDataElement)valueOfItem;
                        if (dataElement.isPKey()) {
                            data = dataElement.getValueAsString();
                        } else {
                            if (!Util.isEmpty((String)printFormatItem.getFormatPattern())) {
                                dataElement.setM_formatPattern(printFormatItem.getFormatPattern());
                            }
                            if (!Util.isEmpty((String)(data = dataElement.getValueDisplay(this.getLanguage())))) {
                                if (DisplayType.isNumeric((int)dataElement.getDisplayType())) {
                                    data = columnName.equals("WithholdingRate") ? data.replace(".", ",") + "%" : data.replace(".", ",");
                                } else if (DisplayType.isText((int)dataElement.getDisplayType())) {
                                    if ((columnName.equals("TaxID") || columnName.equals("OrgValue")) && (data = data.trim()).length() > 4) {
                                        data = data.substring(0, 1) + "-" + data.substring(1, data.length() - 1) + "-" + data.substring(data.length() - 1);
                                    }
                                } else if (DisplayType.isLookup((int)dataElement.getDisplayType())) {
                                    if (columnName.equals("C_Invoice_ID")) {
                                        String value = dataElement.getValueKey();
                                        if (!Util.isEmpty((String)value)) {
                                            MInvoice invoice;
                                            String transactionName = null;
                                            if (engine.getProcessInfo() != null) {
                                                transactionName = engine.getProcessInfo().getTransactionName();
                                            }
                                            if (printFormatItem.getName().equals("TipoContribuyente")) {
                                                MInvoice invoice2 = this.getInvoice(value, transactionName);
                                                if (invoice2 != null) {
                                                    MOrgInfo organizationInfo = MOrgInfo.get((Properties)this.getCtx(), (int)invoice2.getAD_Org_ID(), null);
                                                    MLocation invoiceLocation = MLocation.get((Properties)this.getCtx(), (int)invoice2.getC_BPartner_Location_ID(), (String)transactionName);
                                                    MLocation organizationLocation = MLocation.get((Properties)this.getCtx(), (int)organizationInfo.getC_Location_ID(), (String)transactionName);
                                                    data = invoiceLocation.getC_City_ID() == organizationLocation.getC_City_ID() ? "D" : "T";
                                                }
                                            } else if (printFormatItem.getName().equals("CodigoAgente")) {
                                                MInvoice invoice3 = this.getInvoice(value, transactionName);
                                                if (invoice3 != null) {
                                                    MOrgInfo organizationInfo = MOrgInfo.get((Properties)this.getCtx(), (int)invoice3.getAD_Org_ID(), null);
                                                    String businessPartnerCode = null;
                                                    if (organizationInfo.get_ValueAsInt("WH_BPartner_ID") > 0) {
                                                        MBPartner businessPartner = new MBPartner(this.getCtx(), organizationInfo.get_ValueAsInt("WH_BPartner_ID"), transactionName);
                                                        businessPartnerCode = businessPartner.get_ValueAsString("LVE_CommercialActivityLicense");
                                                    }
                                                    data = String.format("%1$5s", Optional.ofNullable(businessPartnerCode).orElse("")).replace(" ", "0");
                                                }
                                            } else if (printFormatItem.getName().equals("CodigoProveedor")) {
                                                MInvoice invoice4 = this.getInvoice(value, transactionName);
                                                if (invoice4 != null) {
                                                    MBPartner businessPartner = new MBPartner(this.getCtx(), invoice4.getC_BPartner_ID(), transactionName);
                                                    String businessPartnerCode = Optional.ofNullable(businessPartner.get_ValueAsString("LVE_CommercialActivityLicense")).orElse("");
                                                    data = String.format("%1$5s", businessPartnerCode).replace(" ", "0");
                                                }
                                            } else if (printFormatItem.getName().equals("NombreProveedor") && (invoice = this.getInvoice(value, transactionName)) != null) {
                                                data = invoice.getC_BPartner().getName();
                                            }
                                        }
                                    } else {
                                        data = data.replace(".", ",");
                                    }
                                }
                            }
                        }
                    } else {
                        log.log(Level.SEVERE, "Element not PrintData(Element) " + valueOfItem.getClass());
                    }
                    if (Util.isEmpty((String)data)) {
                        data = "0";
                    }
                    if (isFirstColumn.get()) {
                        isFirstColumn.set(false);
                    } else {
                        buffer.append('\t');
                    }
                    this.createCSVvalue(buffer, data);
                });
                if (firstLine) {
                    firstLine = false;
                } else if (buffer.length() > 0) {
                    writer.write(CRLF);
                }
                writer.write(buffer.toString());
            }
            writer.flush();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", (Throwable)e);
        }
        return true;
    }

    private MInvoice getInvoice(String value, String transactionName) {
        if (!Util.isEmpty((String)value)) {
            int invoiceId = 0;
            try {
                invoiceId = Integer.parseInt(value);
            }
            catch (Exception e) {
                log.warning(e.getLocalizedMessage());
            }
            if (invoiceId > 0) {
                return new MInvoice(this.getCtx(), invoiceId, transactionName);
            }
        }
        return null;
    }

    private void createCSVvalue(StringBuffer sb, String content) {
        if (content == null || content.length() == 0) {
            return;
        }
        sb.append(content);
    }
}

