/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util.exp;

import java.io.File;
import java.io.Writer;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MColumn;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.util.AbstractExportFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportFormatXML_ISLR
extends AbstractExportFormat {
    private static CLogger log = CLogger.getCLogger(ExportFormatXML_ISLR.class);

    public ExportFormatXML_ISLR(Properties ctx, ReportEngine reportEngine) {
        this.setCtx(ctx);
        this.setReportEngine(reportEngine);
    }

    public String getExtension() {
        return "xml";
    }

    public String getName() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"FileISLRXML");
    }

    public boolean exportToFile(File file) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        return this.createXML(this.convertFile(file));
    }

    public boolean createXML(Writer writer) {
        if (writer == null) {
            return false;
        }
        try {
            this.createXML(new StreamResult(writer));
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", (Throwable)e);
            return false;
        }
    }

    public Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        PrintData printData = this.getPrintData();
        MPrintFormat printFormat = this.getPrintFormat();
        Element root = document.createElement(printFormat.getName());
        int orgPrintFormatItemId = 0;
        int periodPrintFormatItemId = 0;
        for (int row = 0; row < printData.getRowCount(); ++row) {
            printData.setRowIndex(row);
            if (row == 0) {
                String orgPrintName = "";
                String orgTaxId = "";
                String periodPrintName = "";
                String period = "";
                for (int col = 0; col < printFormat.getItemCount(); ++col) {
                    MColumn column;
                    MPrintFormatItem item = printFormat.getItem(col);
                    if (item.getAD_Column_ID() == 0 || (column = MColumn.get((Properties)this.getCtx(), (int)item.getAD_Column_ID())) == null) continue;
                    if (column.getColumnName().equals("OrgValue") && orgPrintFormatItemId == 0) {
                        orgPrintFormatItemId = item.getAD_PrintFormatItem_ID();
                        orgPrintName = item.getPrintName();
                        Object orgValue = printData.getNode(new Integer(item.getAD_Column_ID()));
                        if (orgValue == null || !(orgValue instanceof PrintDataElement)) continue;
                        PrintDataElement orgDataElement = (PrintDataElement)orgValue;
                        orgTaxId = orgDataElement.getValueDisplay(this.getLanguage());
                        continue;
                    }
                    if (!column.getColumnName().equals("DateAcct") || periodPrintFormatItemId != 0) continue;
                    periodPrintFormatItemId = item.getAD_PrintFormatItem_ID();
                    periodPrintName = item.getPrintName();
                    Object periodValue = printData.getNode(new Integer(item.getAD_Column_ID()));
                    if (periodValue == null || !(periodValue instanceof PrintDataElement)) continue;
                    PrintDataElement periodDataElement = (PrintDataElement)periodValue;
                    period = periodDataElement.getValueDisplay(this.getLanguage());
                }
                if (Util.isEmpty((String)orgPrintName)) {
                    orgPrintName = "RifAgente";
                }
                if (Util.isEmpty((String)orgTaxId)) {
                    orgTaxId = "";
                }
                if (Util.isEmpty((String)periodPrintName)) {
                    periodPrintName = "Periodo";
                }
                if (Util.isEmpty((String)period)) {
                    period = "";
                }
                root.setAttribute(periodPrintName, period);
                root.setAttribute(orgPrintName, orgTaxId);
                document.appendChild(root);
            }
            Element withholdingElement = document.createElement(printFormat.getDescription());
            root.appendChild(withholdingElement);
            int orgPrintId = orgPrintFormatItemId;
            int periodPrintId = periodPrintFormatItemId;
            Arrays.asList(printFormat.getItems()).stream().filter(printFormatItem -> printFormatItem.isPrinted() && printFormatItem.getAD_PrintFormatItem_ID() != orgPrintId && printFormatItem.getAD_PrintFormatItem_ID() != periodPrintId).forEach(printFormatItem -> {
                Object valueOfItem = printData.getNode(new Integer(printFormatItem.getAD_Column_ID()));
                String data = "";
                if (valueOfItem == null) {
                    if (printFormatItem.getPrintFormatType().equals("T") && !Util.isEmpty((String)printFormatItem.getPrintName())) {
                        data = printFormatItem.getPrintName() + (!Util.isEmpty((String)printFormatItem.getPrintNameSuffix()) ? printFormatItem.getPrintNameSuffix() : "");
                    }
                } else if (valueOfItem instanceof PrintDataElement) {
                    PrintDataElement dataElement = (PrintDataElement)valueOfItem;
                    if (dataElement.isPKey()) {
                        data = dataElement.getValueAsString();
                    } else {
                        if (!Util.isEmpty((String)printFormatItem.getFormatPattern())) {
                            dataElement.setM_formatPattern(printFormatItem.getFormatPattern());
                        }
                        if (!Util.isEmpty((String)(data = dataElement.getValueDisplay(this.getLanguage())))) {
                            if (DisplayType.isNumeric((int)dataElement.getDisplayType())) {
                                data = data.replaceAll(",", ".");
                            } else if (DisplayType.isText((int)dataElement.getDisplayType()) && (printFormatItem.getColumnName().equals("InvoiceNo") || printFormatItem.getColumnName().equals("AffectedDocumentNo") || printFormatItem.getColumnName().equals("ControlNo")) && (data = data.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()*#/><-]", "").replaceAll(" ", "")).length() > 10) {
                                data = data.substring(data.length() - 10, data.length());
                            }
                        }
                    }
                } else {
                    log.log(Level.SEVERE, "Element not PrintData(Element) " + valueOfItem.getClass());
                }
                Element withholdingDetail = document.createElement(printFormatItem.getPrintName());
                withholdingDetail.appendChild(document.createTextNode(data));
                withholdingElement.appendChild(withholdingDetail);
            });
        }
        return document;
    }

    public boolean createXML(StreamResult result) {
        try {
            DOMSource source = new DOMSource(this.getDocument());
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(StreamResult)", (Throwable)e);
            return false;
        }
        return true;
    }
}

