/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util.exp;

import java.io.File;
import java.io.Writer;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.compiere.print.MPrintFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.util.ExportFormatCSV;

public class ExportFormatTXT_IVA
extends ExportFormatCSV {
    private static CLogger log = CLogger.getCLogger(ExportFormatTXT_IVA.class);
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String CRLF = "\r\n";

    public ExportFormatTXT_IVA(Properties ctx, ReportEngine reportEngine) {
        super(ctx, reportEngine);
    }

    public String getExtension() {
        return "txt";
    }

    public String getName() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"FileIVATXT");
    }

    public boolean exportToFile(File file) {
        if (this.getReportEngine() == null || this.getCtx() == null) {
            return false;
        }
        return this.createTXTFile(this.convertFile(file), this.getReportEngine());
    }

    private boolean createTXTFile(Writer writer, ReportEngine engine) {
        try {
            int startAt = 0;
            PrintData printData = engine != null ? engine.getPrintData() : this.getPrintData();
            MPrintFormat printFormat = engine != null ? engine.getPrintFormat() : this.getPrintFormat();
            boolean firstLine = true;
            for (int row = startAt; row < printData.getRowCount(); ++row) {
                StringBuffer buffer = new StringBuffer();
                if (row != -1) {
                    printData.setRowIndex(row);
                }
                AtomicBoolean isFirstColumn = new AtomicBoolean(true);
                Arrays.asList(printFormat.getItems()).stream().filter(printFormatItem -> printFormatItem.isPrinted()).forEach(printFormatItem -> {
                    Object valueOfItem = printData.getNode(new Integer(printFormatItem.getAD_Column_ID()));
                    String data = "";
                    if (valueOfItem == null) {
                        if (printFormatItem.getPrintFormatType().equals("T") && !Util.isEmpty((String)printFormatItem.getPrintName())) {
                            data = printFormatItem.getPrintName() + (!Util.isEmpty((String)printFormatItem.getPrintNameSuffix()) ? printFormatItem.getPrintNameSuffix() : "");
                        }
                    } else if (valueOfItem instanceof PrintDataElement) {
                        PrintDataElement dataElement = (PrintDataElement)valueOfItem;
                        if (dataElement.isPKey()) {
                            data = dataElement.getValueAsString();
                        } else {
                            if (!Util.isEmpty((String)printFormatItem.getFormatPattern())) {
                                dataElement.setM_formatPattern(printFormatItem.getFormatPattern());
                            }
                            if (!Util.isEmpty((String)(data = dataElement.getValueDisplay(this.getLanguage())))) {
                                if (DisplayType.isNumeric((int)dataElement.getDisplayType())) {
                                    data = data.replaceAll(",", ".");
                                } else if (DisplayType.isText((int)dataElement.getDisplayType()) && (printFormatItem.getColumnName().equals("InvoiceNo") || printFormatItem.getColumnName().equals("AffectedDocumentNo") || printFormatItem.getColumnName().equals("ControlNo") || printFormatItem.getColumnName().equals("DocumentNo"))) {
                                    data = data.trim();
                                }
                            }
                        }
                    } else {
                        log.log(Level.SEVERE, "Element not PrintData(Element) " + valueOfItem.getClass());
                    }
                    if (Util.isEmpty((String)data)) {
                        data = "0";
                    }
                    if (isFirstColumn.get()) {
                        isFirstColumn.set(false);
                    } else {
                        buffer.append('\t');
                    }
                    this.createCSVvalue(buffer, data);
                });
                if (firstLine) {
                    firstLine = false;
                } else if (buffer.length() > 0) {
                    writer.write(CRLF);
                }
                writer.write(buffer.toString());
            }
            writer.flush();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", (Throwable)e);
        }
        return true;
    }

    private void createCSVvalue(StringBuffer sb, String content) {
        if (content == null || content.length() == 0) {
            return;
        }
        sb.append(content);
    }
}

