/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.util.Env;
import org.erpya.lve.model.MLVEListLine;
import org.erpya.lve.model.MLVEListVersion;

class WHConceptSetting {
    private MLVEListVersion rateToApply = null;
    private MLVEListLine varRateToApply = null;
    private BigDecimal amtBase = Env.ZERO;
    private BigDecimal amtBaseConverted = Env.ZERO;
    private BigDecimal amtSubtract = Env.ZERO;
    private boolean isCumulative = false;
    private boolean isValid = true;
    private boolean generateDocument = false;
    private BigDecimal rate = Env.ZERO;
    private BigDecimal currencyRate = null;

    public WHConceptSetting(MInvoice invoice, BigDecimal amtBase) {
        this.currencyRate = MConversionRate.getRate((int)invoice.getC_Currency_ID(), (int)MClient.get((Properties)invoice.getCtx()).getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
        this.setAmtBase(amtBase);
    }

    public void setAmtBase(BigDecimal amtBase) {
        Optional.ofNullable(amtBase).ifPresent(amountBase -> {
            this.amtBase = amountBase;
            this.amtBaseConverted = Optional.ofNullable(this.currencyRate).orElse(Env.ONE).multiply((BigDecimal)amountBase);
        });
    }

    public WHConceptSetting addAmtBase(BigDecimal amt) {
        Optional.ofNullable(amt).ifPresent(amount -> this.setAmtBase(amount.add(Optional.ofNullable(this.amtBase).orElse(Env.ZERO))));
        return this;
    }

    public BigDecimal getAmtBase() {
        return this.amtBase;
    }

    public BigDecimal getAmtBaseConverted() {
        return this.amtBaseConverted;
    }

    public BigDecimal getCurrencyRate() {
        return this.currencyRate;
    }

    public void setRateToApply(MLVEListVersion rateToApply) {
        this.rateToApply = rateToApply;
    }

    public void setVarRateToApply(MLVEListLine varRateToApply) {
        this.varRateToApply = varRateToApply;
    }

    public void setAmtSubtract(BigDecimal amtSubtract) {
        this.amtSubtract = amtSubtract;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setGenerateDocument(boolean generateDocument) {
        this.generateDocument = generateDocument;
    }

    public boolean isGenerateDocument() {
        return this.generateDocument;
    }

    public MLVEListVersion getRateToApply() {
        return this.rateToApply;
    }

    public MLVEListLine getVarRateToApply() {
        return this.varRateToApply;
    }

    public BigDecimal getAmtSubtract() {
        return this.amtSubtract;
    }

    public boolean isVarRate() {
        return this.varRateToApply != null;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public boolean isCumulative() {
        return this.isCumulative;
    }

    public void setCumulative(boolean isCumulative) {
        this.isCumulative = isCumulative;
    }

    public String toString() {
        return "Rate = " + this.getRate() + ",AmtBase = " + this.getAmtBase() + ",Subtract = " + this.getAmtSubtract() + ",GenerateDocument = " + this.isGenerateDocument() + ",IsValid = " + this.isValid();
    }
}

