/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.util.Arrays;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.MInvoice;
import org.compiere.model.Query;
import org.compiere.util.Util;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHSetting;
import org.spin.model.MWHWithholding;
import org.spin.util.AbstractWithholdingSetting;

public class POSWihholdingIVAProcess
extends AbstractWithholdingSetting {
    private MInvoice withholdingDocument;
    private MWHWithholding withholding;
    private String event;

    public MInvoice getWithholdingDocument() {
        return this.withholdingDocument;
    }

    public POSWihholdingIVAProcess(MWHSetting setting) {
        super(setting);
    }

    public String getEvent() {
        return this.event;
    }

    public boolean isValid() {
        if (this.getDocument().get_Table_ID() != I_C_Invoice.Table_ID) {
            return false;
        }
        if (this.getDocument().get_ValueAsInt("C_POS_ID") <= 0) {
            return false;
        }
        this.event = this.getSetting().getEventModelValidator();
        if (Util.isEmpty((String)this.event)) {
            return false;
        }
        this.withholdingDocument = (MInvoice)this.getDocument();
        return this.getWithholding() != null;
    }

    public String run() {
        if (this.getWithholding() != null) {
            this.withholding.setC_Invoice_ID(this.getWithholdingDocument().getC_Invoice_ID());
            this.withholding.saveEx();
            int documentTypeId = this.withholding.getWHDocType();
            if (documentTypeId > 0) {
                this.withholdingDocument.setC_DocTypeTarget_ID(documentTypeId);
                this.withholdingDocument.saveEx();
            }
            MWHDefinition whDefinition = (MWHDefinition)this.withholding.getWH_Definition();
            MWHSetting whSetting = (MWHSetting)this.withholding.getWH_Setting();
            Arrays.asList(this.withholdingDocument.getLines(true)).stream().findFirst().ifPresent(withholdingDocumentLine -> {
                if (whSetting.getC_Charge_ID() > 0) {
                    withholdingDocumentLine.setC_Charge_ID(whSetting.getC_Charge_ID());
                } else if (whDefinition.getC_Charge_ID() > 0) {
                    withholdingDocumentLine.setC_Charge_ID(whDefinition.getC_Charge_ID());
                }
                withholdingDocumentLine.saveEx();
            });
        }
        return null;
    }

    private MWHWithholding getWithholding() {
        if (this.withholding != null) {
            return this.withholding;
        }
        if (this.withholdingDocument != null) {
            this.withholding = (MWHWithholding)new Query(this.getContext(), "WH_Withholding", "SourceInvoice_ID IS NOT NULL AND SourceOrder_ID = ? AND WH_Definition_ID = ? AND Processed = 'Y' AND IsSimulation='N' AND C_Invoice_ID IS NULL AND DocStatus IN (?,?)", this.getTransactionName()).setParameters(new Object[]{this.withholdingDocument.getC_Order_ID(), this.getDefinition().getWH_Definition_ID(), "CO", "CL"}).first();
        }
        return this.withholding;
    }
}

