/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.I_C_Order;
import org.compiere.model.MOrder;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Util;
import org.spin.model.MWHSetting;
import org.spin.util.AbstractWithholdingSetting;

public class POSOrderIVAProcess
extends AbstractWithholdingSetting {
    private List<Integer> paymentReferences = new ArrayList<Integer>();
    private MOrder order;
    private String event;

    public MOrder getOrder() {
        return this.order;
    }

    public POSOrderIVAProcess(MWHSetting setting) {
        super(setting);
    }

    public String getEvent() {
        return this.event;
    }

    public List<Integer> getPaymentReferences() {
        return this.paymentReferences;
    }

    public boolean isValid() {
        if (this.getDocument().get_ValueAsInt("C_POS_ID") <= 0) {
            return false;
        }
        this.event = this.getSetting().getEventModelValidator();
        if (Util.isEmpty((String)this.event)) {
            return false;
        }
        if (this.getDocument().get_Table_ID() != I_C_Order.Table_ID) {
            return false;
        }
        this.order = (MOrder)this.getDocument();
        MTable paymentReferenceDefinition = MTable.get((Properties)this.getContext(), (String)"C_POSPaymentReference");
        if (paymentReferenceDefinition == null) {
            return false;
        }
        this.fillReferences();
        return this.paymentReferences.size() > 0;
    }

    private void fillReferences() {
        this.paymentReferences = new Query(this.getContext(), "C_POSPaymentReference", "C_Order_ID = ? AND TenderType = ? AND EXISTS(SELECT 1 FROM C_PaymentMethod pm WHERE pm.C_PaymentMethod_ID = C_POSPaymentReference.C_PaymentMethod_ID AND pm.WH_Type_ID = ?)", this.getTransactionName()).setParameters(new Object[]{this.order.getC_Order_ID(), "M", this.getSetting().getWH_Type_ID()}).getIDsAsList();
    }

    public String run() {
        MTable paymentReferenceDefinition = MTable.get((Properties)this.getContext(), (String)"C_POSPaymentReference");
        if (paymentReferenceDefinition != null) {
            int invoiceId = this.order.getC_Invoice_ID();
            this.paymentReferences.forEach(paymentReferenceId -> {
                PO paymentReference = paymentReferenceDefinition.getPO(paymentReferenceId.intValue(), this.getTransactionName());
                this.setWithholdingRate((BigDecimal)paymentReference.get_Value("Rate"));
                this.addBaseAmount((BigDecimal)paymentReference.get_Value("Base"));
                this.addWithholdingAmount((BigDecimal)paymentReference.get_Value("Amount"));
                this.setReturnValue("C_Currency_ID", paymentReference.get_ValueAsInt("C_Currency_ID"));
                this.setReturnValue("C_ConversionType_ID", paymentReference.get_ValueAsInt("C_ConversionType_ID"));
                this.addDescription(paymentReference.get_ValueAsString("Description"));
                this.setReturnValue("IsManual", true);
                this.setReturnValue("DateAcct", paymentReference.get_Value("PayDate"));
                if (invoiceId > 0) {
                    this.setReturnValue("SourceInvoice_ID", invoiceId);
                }
                paymentReference.set_ValueOfColumn("IsPaid", (Object)true);
                paymentReference.set_ValueOfColumn("Processed", (Object)true);
                paymentReference.saveEx();
                this.saveResult();
            });
        }
        return null;
    }
}

