/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MTable;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEWithholdingTax;
import org.spin.model.MCPaymentMethod;
import org.spin.model.MWHSetting;
import org.spin.util.AbstractWithholdingSetting;

public class POSOrderIVABase
extends AbstractWithholdingSetting {
    private MOrder order;
    private MBPartner businessPartner;
    private List<MOrderTax> taxes;
    private boolean isManual = false;
    BigDecimal withholdingRate = Env.ZERO;
    private PO defaultPaymentMethodallocated;

    public POSOrderIVABase(MWHSetting setting) {
        super(setting);
    }

    public PO getDefaultPaymentMethodAllocated() {
        if (this.defaultPaymentMethodallocated != null) {
            return this.defaultPaymentMethodallocated;
        }
        this.defaultPaymentMethodallocated = new Query(this.getContext(), "C_POSPaymentTypeAllocation", "C_POS_ID = ? AND IsPaymentReference = 'Y' AND EXISTS(SELECT 1 FROM C_PaymentMethod pm WHERE pm.C_PaymentMethod_ID = C_POSPaymentTypeAllocation.C_PaymentMethod_ID AND pm.TenderType = ? AND pm.WH_Type_ID = ?)", this.getTransactionName()).setParameters(new Object[]{this.order.getC_POS_ID(), "M", this.getSetting().getWH_Type_ID()}).setOnlyActiveRecords(true).first();
        return this.defaultPaymentMethodallocated;
    }

    public void setDefaultPaymentMethodAllocated(PO defaultPaymentMethodAllocated) {
        this.defaultPaymentMethodallocated = defaultPaymentMethodAllocated;
    }

    public boolean isValid() {
        boolean isValid = true;
        if (this.getDocument().get_Table_ID() != I_C_OrderLine.Table_ID && this.getDocument().get_Table_ID() != I_C_Order.Table_ID) {
            return false;
        }
        String event = this.getSetting().getEventModelValidator();
        if (Util.isEmpty((String)event)) {
            return false;
        }
        if (this.getDocument().get_Table_ID() == I_C_OrderLine.Table_ID) {
            if (!(this.getDocument().is_ValueChanged("LineNetAmt") || this.getDocument().is_ValueChanged("C_Tax_ID") || event.equals("TAN"))) {
                return false;
            }
            MOrderLine orderLine = (MOrderLine)this.getDocument();
            this.order = orderLine.getParent();
        } else {
            if (!this.getDocument().is_ValueChanged("C_DocTypeTarget_ID") && !this.getDocument().is_ValueChanged("C_BPartner_ID")) {
                return false;
            }
            this.order = (MOrder)this.getDocument();
        }
        if (this.order.getC_POS_ID() <= 0) {
            return false;
        }
        this.businessPartner = (MBPartner)this.order.getC_BPartner();
        if (this.order.isProcessed()) {
            return false;
        }
        if (!this.businessPartner.get_ValueAsBoolean("IsTaxpayer")) {
            this.deleteReference();
            return false;
        }
        Optional.ofNullable(this.order).ifPresent(order -> {
            this.setReturnValue("SourceOrder_ID", order.getC_Order_ID());
            this.setReturnValue("AD_Org_ID", order.getAD_Org_ID());
            if (order.isSOTrx()) {
                this.isManual = true;
                Optional.ofNullable(MOrgInfo.get((Properties)this.getContext(), (int)order.getAD_Org_ID(), (String)order.get_TrxName())).ifPresent(orgInfo -> {
                    this.businessPartner = MBPartner.get((Properties)this.getContext(), (int)orgInfo.get_ValueAsInt("WH_BPartner_ID"));
                });
            } else {
                this.isManual = false;
            }
        });
        if (this.businessPartner == null) {
            this.addLog("@C_BPartner_ID@ @NotFound@");
            isValid = false;
        } else {
            MDocType documentType;
            this.setReturnValue("SourceOrder_ID", this.order.getC_Order_ID());
            MLVEWithholdingTax currentWHTax = MLVEWithholdingTax.getFromClient(this.getContext(), this.getDocument().getAD_Org_ID(), "IV");
            if (currentWHTax == null) {
                this.addLog("@LVE_WithholdingTax_ID@ @NotFound@");
                isValid = false;
            }
            if (currentWHTax != null && currentWHTax.isClientExcluded()) {
                this.addLog("@IsClientExcluded@ " + currentWHTax.getName());
                isValid = false;
            }
            if ((documentType = MDocType.get((Properties)this.getContext(), (int)this.order.getC_DocTypeTarget_ID())) == null) {
                this.addLog("@C_DocType_ID@ @NotFound@");
                isValid = false;
            }
            if (this.order.get_ValueAsBoolean("IsWithholdingTaxExempt")) {
                this.deleteReference();
                return false;
            }
            if (this.businessPartner.get_ValueAsBoolean("IsWithholdingTaxExempt")) {
                this.deleteReference();
                return false;
            }
            int withholdingRateId = this.businessPartner.get_ValueAsInt("WithholdingTaxRate_ID");
            if (withholdingRateId == 0 && currentWHTax != null) {
                withholdingRateId = currentWHTax.getDefaultWithholdingRate_ID();
            }
            if (withholdingRateId == 0) {
                this.deleteReference();
                return false;
            }
            this.withholdingRate = MLVEList.get(this.getContext(), withholdingRateId).getListVersionAmount(this.order.getDateOrdered());
            this.setWithholdingRate(this.withholdingRate);
            if (this.getWithholdingRate().equals(Env.ZERO)) {
                this.deleteReference();
                return false;
            }
            BigDecimal tributeUnitAmount = Env.ZERO;
            if (currentWHTax != null) {
                tributeUnitAmount = currentWHTax.getValidTributeUnitAmount(this.order.getDateAcct());
            }
            if (tributeUnitAmount.equals(Env.ZERO)) {
                this.addLog("@TributeUnit@ (@Rate@ @NotFound@)");
                isValid = false;
            }
            this.taxes = Arrays.asList(this.order.getTaxes(true)).stream().filter(orderTax -> MTax.get((Properties)this.getContext(), (int)orderTax.getC_Tax_ID()).get_ValueAsBoolean("IsWithholdingTaxApplied") && orderTax.getTaxAmt() != null && orderTax.getTaxAmt().compareTo(Env.ZERO) > 0).collect(Collectors.toList());
        }
        if (this.getDefaultPaymentMethodAllocated() == null) {
            this.addLog("@C_PaymentMethod_ID@ @NotFound@");
            isValid = false;
        }
        return isValid;
    }

    public String run() {
        MTable posPaymentType = MTable.get((Properties)this.getContext(), (String)"C_POSPaymentTypeAllocation");
        if (posPaymentType != null) {
            PO paymentTypeAllocation = this.getDefaultPaymentMethodAllocated();
            if (paymentTypeAllocation == null) {
                return null;
            }
            if (Util.isEmpty((String)paymentTypeAllocation.get_ValueAsString("Name"))) {
                MCPaymentMethod paymentMethod = MCPaymentMethod.getById((Properties)this.getContext(), (int)paymentTypeAllocation.get_ValueAsInt("C_PaymentMethod_ID"), (String)this.getTransactionName());
                if (!Util.isEmpty((String)paymentMethod.getDescription())) {
                    this.addDescription(paymentMethod.getDescription() + " @of@ " + this.order.getDocumentNo());
                }
            } else {
                this.addDescription(paymentTypeAllocation.get_ValueAsString("Name") + " @of@ " + this.order.getDocumentNo());
            }
        }
        this.taxes.forEach(orderTax -> {
            this.setWithholdingRate(this.withholdingRate);
            this.addBaseAmount(orderTax.getTaxAmt());
            this.addWithholdingAmount(orderTax.getTaxAmt().multiply(this.getWithholdingRate(true)));
            MTax tax = MTax.get((Properties)this.getContext(), (int)orderTax.getC_Tax_ID());
            this.addDescription(tax.getName());
            this.setReturnValue("IsManual", this.isManual);
            int WHThirdParty_ID = this.order.get_ValueAsInt("WHThirdParty_ID");
            if (WHThirdParty_ID != 0) {
                this.setReturnValue("WHThirdParty_ID", WHThirdParty_ID);
            }
            this.setReturnValue("C_Tax_ID", orderTax.getC_Tax_ID());
            this.setReturnValue("IsSimulation", true);
        });
        return null;
    }

    protected void savePaymentReference(boolean createIfNotExists) {
        if (Optional.ofNullable(this.getWithholdingAmount()).orElse(Env.ZERO).compareTo(Env.ZERO) > 0) {
            MTable paymentReferenceDefinition = MTable.get((Properties)this.getContext(), (String)"C_POSPaymentReference");
            if (paymentReferenceDefinition != null) {
                if (this.getDefaultPaymentMethodAllocated() == null) {
                    return;
                }
                PO paymentReferenceToCreate = new Query(this.getContext(), "C_POSPaymentReference", "C_Order_ID = ? AND TenderType = ? AND C_PaymentMethod_ID = ? AND Processed = 'N'", this.getTransactionName()).setClient_ID().setParameters(new Object[]{this.order.getC_Order_ID(), "M", this.getDefaultPaymentMethodAllocated().get_ValueAsInt("C_PaymentMethod_ID")}).first();
                if (createIfNotExists && (paymentReferenceToCreate == null || paymentReferenceToCreate.get_ID() <= 0)) {
                    paymentReferenceToCreate = paymentReferenceDefinition.getPO(0, this.getTransactionName());
                }
                if (paymentReferenceToCreate != null) {
                    paymentReferenceToCreate.set_ValueOfColumn("Amount", (Object)this.getWithholdingAmount());
                    paymentReferenceToCreate.set_ValueOfColumn("AmtSource", (Object)this.getWithholdingAmount());
                    paymentReferenceToCreate.set_ValueOfColumn("Base", (Object)this.getBaseAmount());
                    paymentReferenceToCreate.set_ValueOfColumn("Rate", (Object)this.getWithholdingRate());
                    paymentReferenceToCreate.set_ValueOfColumn("C_BPartner_ID", (Object)this.order.getC_BPartner_ID());
                    paymentReferenceToCreate.set_ValueOfColumn("C_ConversionType_ID", (Object)this.order.getC_ConversionType_ID());
                    paymentReferenceToCreate.set_ValueOfColumn("C_Currency_ID", (Object)this.order.getC_Currency_ID());
                    paymentReferenceToCreate.set_ValueOfColumn("C_Order_ID", (Object)this.order.getC_Order_ID());
                    paymentReferenceToCreate.set_ValueOfColumn("C_POS_ID", (Object)this.order.getC_POS_ID());
                    if (this.order.getSalesRep_ID() > 0) {
                        paymentReferenceToCreate.set_ValueOfColumn("SalesRep_ID", (Object)this.order.getSalesRep_ID());
                    }
                    paymentReferenceToCreate.set_ValueOfColumn("IsReceipt", (Object)true);
                    paymentReferenceToCreate.set_ValueOfColumn("IsKeepReferenceAfterProcess", (Object)false);
                    paymentReferenceToCreate.set_ValueOfColumn("TenderType", (Object)"M");
                    paymentReferenceToCreate.set_ValueOfColumn("IsAutoCreatedReference", (Object)true);
                    paymentReferenceToCreate.set_ValueOfColumn("C_PaymentMethod_ID", (Object)this.getDefaultPaymentMethodAllocated().get_ValueAsInt("C_PaymentMethod_ID"));
                    paymentReferenceToCreate.set_ValueOfColumn("TenderType", (Object)"M");
                    paymentReferenceToCreate.set_ValueOfColumn("Description", (Object)Msg.parseTranslation((Properties)this.getContext(), (String)this.getProcessDescription()));
                    paymentReferenceToCreate.set_ValueOfColumn("PayDate", (Object)this.order.getDateOrdered());
                    paymentReferenceToCreate.saveEx();
                }
            }
            this.setWithholdingRate(Env.ZERO);
            this.setBaseAmount(Env.ZERO);
            this.setWithholdingAmount(Env.ZERO);
            this.setDefaultPaymentMethodAllocated(null);
        } else {
            this.deleteReference();
        }
    }

    private void deleteReference() {
        MTable paymentReferenceDefinition = MTable.get((Properties)this.getContext(), (String)"C_POSPaymentReference");
        if (paymentReferenceDefinition != null) {
            if (this.getDefaultPaymentMethodAllocated() == null) {
                return;
            }
            PO paymentReferenceToDelete = new Query(this.getContext(), "C_POSPaymentReference", "C_Order_ID = ? AND TenderType = ? AND C_PaymentMethod_ID = ?", this.getTransactionName()).setClient_ID().setParameters(new Object[]{this.order.getC_Order_ID(), "M", this.getDefaultPaymentMethodAllocated().get_ValueAsInt("C_PaymentMethod_ID")}).first();
            if (paymentReferenceToDelete != null) {
                paymentReferenceToDelete.deleteEx(true);
            }
        }
    }
}

