/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.util.Env;

public class OrganizationRulesUtil {
    public static final void recalculateInvoiceLineRate(MInvoice invoice, MInvoiceLine invoiceLine) {
        if (invoiceLine.getC_OrderLine_ID() > 0 && !invoiceLine.isProcessed()) {
            MOrderLine orderLine = (MOrderLine)invoiceLine.getC_OrderLine();
            MOrder order = orderLine.getParent();
            if (invoice.getC_Currency_ID() != order.getC_Currency_ID() && !invoice.isReversal()) {
                int conversionTypeId = invoice.getC_ConversionType_ID();
                if (conversionTypeId <= 0) {
                    conversionTypeId = order.getC_ConversionType_ID();
                }
                BigDecimal orderPriceList = Optional.ofNullable(orderLine.getPriceList()).orElse(Env.ZERO);
                BigDecimal orderPriceActual = Optional.ofNullable(orderLine.getPriceActual()).orElse(Env.ZERO);
                BigDecimal conversionRate = Optional.ofNullable(MConversionRate.getRate((int)order.getC_Currency_ID(), (int)invoice.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)conversionTypeId, (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID())).orElse(Env.ZERO);
                if (conversionRate.compareTo(Env.ZERO) == 0) {
                    throw new AdempiereException(MConversionRate.getErrorMessage((Properties)invoice.getCtx(), (String)"ErrorConvertingInvoiceCurrencyToBaseCurrency", (int)order.getC_Currency_ID(), (int)invoice.getC_Currency_ID(), (int)conversionTypeId, (Timestamp)invoice.getDateAcct(), (String)invoice.get_TrxName()));
                }
                MCurrency currencyTo = MCurrency.get((Properties)invoice.getCtx(), (int)invoice.getC_Currency_ID());
                BigDecimal invoicePriceList = orderPriceList.multiply(conversionRate).setScale(currencyTo.getStdPrecision(), 4);
                BigDecimal invoicePriceActual = orderPriceActual.multiply(conversionRate).setScale(currencyTo.getStdPrecision(), 4);
                invoiceLine.setPriceList(invoicePriceList);
                invoiceLine.setPrice(invoicePriceActual);
                invoiceLine.setLineNetAmt();
                invoiceLine.setTaxAmt();
            }
        }
    }
}

