/*
 * Decompiled with CFR 0.152.
 */
package org.erpya.lve.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.I_C_Order;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderTax;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.erpya.lve.model.MLVEList;
import org.erpya.lve.model.MLVEWithholdingTax;
import org.spin.model.MWHSetting;
import org.spin.util.AbstractWithholdingSetting;

public class OrderIVA
extends AbstractWithholdingSetting {
    private MOrder order;
    private MBPartner businessPartner;
    private List<MOrderTax> taxes;
    private boolean isManual = false;
    BigDecimal withholdingRate = Env.ZERO;

    public OrderIVA(MWHSetting setting) {
        super(setting);
    }

    public boolean isValid() {
        boolean isValid = true;
        if (this.getDocument().get_Table_ID() != I_C_Order.Table_ID) {
            this.addLog("@C_Order_ID@ @NotFound@");
            return false;
        }
        this.order = (MOrder)this.getDocument();
        this.businessPartner = (MBPartner)this.order.getC_BPartner();
        Optional.ofNullable(this.order).ifPresent(order -> {
            this.setReturnValue("SourceOrder_ID", order.getC_Order_ID());
            this.setReturnValue("AD_Org_ID", order.getAD_Org_ID());
            if (order.isSOTrx()) {
                this.isManual = true;
                Optional.ofNullable(MOrgInfo.get((Properties)this.getContext(), (int)order.getAD_Org_ID(), (String)order.get_TrxName())).ifPresent(orgInfo -> {
                    this.businessPartner = MBPartner.get((Properties)this.getContext(), (int)orgInfo.get_ValueAsInt("WH_BPartner_ID"));
                });
            } else {
                this.isManual = false;
            }
        });
        if (this.businessPartner == null) {
            this.addLog("@C_BPartner_ID@ @NotFound@");
            isValid = false;
        } else {
            int withholdingRateId;
            MDocType documentType;
            this.setReturnValue("SourceOrder_ID", this.order.getC_Order_ID());
            MLVEWithholdingTax currentWHTax = MLVEWithholdingTax.getFromClient(this.getContext(), this.getDocument().getAD_Org_ID(), "IV");
            if (currentWHTax == null) {
                this.addLog("@LVE_WithholdingTax_ID@ @NotFound@");
                isValid = false;
            }
            if (currentWHTax != null && currentWHTax.isClientExcluded()) {
                this.addLog("@IsClientExcluded@ " + currentWHTax.getName());
                isValid = false;
            }
            if (!this.order.getDocStatus().equals("CO")) {
                this.addLog("@Invalid@ @C_Order_ID@ @DocStatus@");
                isValid = false;
            }
            if ((documentType = MDocType.get((Properties)this.getContext(), (int)this.order.getC_DocTypeTarget_ID())) == null) {
                this.addLog("@C_DocType_ID@ @NotFound@");
                isValid = false;
            }
            if (this.order.get_ValueAsBoolean("IsWithholdingTaxExempt")) {
                isValid = false;
                this.addLog("@DocumentWithholdingTaxExempt@");
            }
            if (this.businessPartner.get_ValueAsBoolean("IsWithholdingTaxExempt")) {
                isValid = false;
                this.addLog("@BPartnerWithholdingTaxExempt@");
            }
            if ((withholdingRateId = this.businessPartner.get_ValueAsInt("WithholdingTaxRate_ID")) == 0 && currentWHTax != null) {
                withholdingRateId = currentWHTax.getDefaultWithholdingRate_ID();
            }
            if (withholdingRateId == 0) {
                this.addLog("@WithholdingTaxRate_ID@ @NotFound@");
                isValid = false;
            } else {
                this.withholdingRate = MLVEList.get(this.getContext(), withholdingRateId).getListVersionAmount(this.order.getDateOrdered());
                this.setWithholdingRate(this.withholdingRate);
            }
            if (this.getWithholdingRate().equals(Env.ZERO)) {
                this.addLog("@LVE_WithholdingTax_ID@ (@Rate@ @NotFound@)");
                isValid = false;
            }
            BigDecimal tributeUnitAmount = Env.ZERO;
            if (currentWHTax != null) {
                tributeUnitAmount = currentWHTax.getValidTributeUnitAmount(this.order.getDateAcct());
            }
            if (tributeUnitAmount.equals(Env.ZERO)) {
                this.addLog("@TributeUnit@ (@Rate@ @NotFound@)");
                isValid = false;
            }
            this.taxes = Arrays.asList(this.order.getTaxes(false)).stream().filter(orderTax -> MTax.get((Properties)this.getContext(), (int)orderTax.getC_Tax_ID()).get_ValueAsBoolean("IsWithholdingTaxApplied") && orderTax.getTaxAmt() != null && orderTax.getTaxAmt().compareTo(Env.ZERO) > 0).collect(Collectors.toList());
            if (this.taxes.size() == 0) {
                this.addLog("@NoTaxesForWithholding@");
                isValid = false;
            }
            if (this.isGenerated()) {
                isValid = false;
            }
        }
        return isValid;
    }

    public String run() {
        this.taxes.forEach(orderTax -> {
            this.setWithholdingRate(this.withholdingRate);
            this.addBaseAmount(orderTax.getTaxAmt());
            this.addWithholdingAmount(orderTax.getTaxAmt().multiply(this.getWithholdingRate(true)));
            MTax tax = MTax.get((Properties)this.getContext(), (int)orderTax.getC_Tax_ID());
            this.addDescription(tax.getName() + " @Processed@");
            this.setReturnValue("IsManual", this.isManual);
            int WHThirdParty_ID = this.order.get_ValueAsInt("WHThirdParty_ID");
            if (WHThirdParty_ID != 0) {
                this.setReturnValue("WHThirdParty_ID", WHThirdParty_ID);
            }
            this.setReturnValue("C_Tax_ID", orderTax.getC_Tax_ID());
            this.setReturnValue("IsSimulation", true);
            this.saveResult();
        });
        return null;
    }

    private boolean isGenerated() {
        if (this.order != null) {
            return new Query(this.getContext(), "WH_Withholding", "SourceOrder_ID = ? AND WH_Definition_ID = ? AND WH_Setting_ID = ? AND Processed = 'Y' AND IsSimulation='Y' AND DocStatus IN (?,?)", this.getTransactionName()).setParameters(new Object[]{this.order.get_ID(), this.getDefinition().get_ID(), this.getSetting().get_ID(), "CO", "CL"}).match();
        }
        return false;
    }
}

